/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.CachingFactory;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.FromRowUsingCreator;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public abstract class GetterBasedSchemaProvider
implements SchemaProvider {
    public abstract List<FieldValueGetter> fieldValueGetters(Class<?> var1, Schema var2);

    public abstract List<FieldValueTypeInformation> fieldValueTypeInformations(Class<?> var1, Schema var2);

    public abstract SchemaUserTypeCreator schemaTypeCreator(Class<?> var1, Schema var2);

    @Override
    public <T> SerializableFunction<T, Row> toRowFunction(TypeDescriptor<T> typeDescriptor) {
        Schema schema = this.schemaFor(typeDescriptor);
        return new ToRowWithValueGetters(schema);
    }

    @Override
    public <T> SerializableFunction<Row, T> fromRowFunction(TypeDescriptor<T> typeDescriptor) {
        Class clazz = (Class)typeDescriptor.getType();
        return new FromRowUsingCreator(clazz, this);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }

    private class ToRowWithValueGetters<T>
    implements SerializableFunction<T, Row> {
        private final Schema schema;
        private final Factory<List<FieldValueGetter>> getterFactory;

        public ToRowWithValueGetters(Schema schema) {
            this.schema = schema;
            this.getterFactory = new CachingFactory<List>(GetterBasedSchemaProvider.this::fieldValueGetters);
        }

        @Override
        public Row apply(T input) {
            return Row.withSchema(this.schema).withFieldValueGetters(this.getterFactory, input);
        }

        private GetterBasedSchemaProvider getOuter() {
            return GetterBasedSchemaProvider.this;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ToRowWithValueGetters that = (ToRowWithValueGetters)o;
            return this.getOuter().equals(that.getOuter()) && this.schema.equals(that.schema);
        }

        public int hashCode() {
            return Objects.hash(GetterBasedSchemaProvider.this, this.schema);
        }
    }
}

