/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ByteKey
implements Comparable<ByteKey>,
Serializable {
    public static final ByteKey EMPTY = ByteKey.of(new int[0]);
    private final ByteString value;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static ByteKey copyFrom(ByteBuffer value) {
        return new ByteKey(ByteString.copyFrom(value));
    }

    public static ByteKey copyFrom(byte[] bytes) {
        return new ByteKey(ByteString.copyFrom(bytes));
    }

    public static ByteKey of(int ... bytes) {
        byte[] ret = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            ret[i] = (byte)(bytes[i] & 0xFF);
        }
        return ByteKey.copyFrom(ret);
    }

    public ByteBuffer getValue() {
        return this.value.asReadOnlyByteBuffer();
    }

    public byte[] getBytes() {
        return this.value.toByteArray();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int compareTo(@Nonnull ByteKey other) {
        Preconditions.checkNotNull(other, "other");
        ByteString.ByteIterator thisIt = this.value.iterator();
        ByteString.ByteIterator otherIt = other.value.iterator();
        while (thisIt.hasNext() && otherIt.hasNext()) {
            int cmp = (thisIt.nextByte() & 0xFF) - (otherIt.nextByte() & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return this.value.size() - other.value.size();
    }

    private ByteKey(ByteString value) {
        this.value = value;
    }

    public String toString() {
        char[] encoded = new char[2 * this.value.size() + 2];
        encoded[0] = 91;
        int cnt = 1;
        ByteString.ByteIterator iterator = this.value.iterator();
        while (iterator.hasNext()) {
            byte b = iterator.nextByte();
            encoded[cnt] = HEX[(b & 0xF0) >>> 4];
            encoded[++cnt] = HEX[b & 0xF];
            ++cnt;
        }
        encoded[cnt] = 93;
        return new String(encoded);
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteKey)) {
            return false;
        }
        ByteKey other = (ByteKey)o;
        return other.value.size() == this.value.size() && this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

