/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;

public class ResourceIdCoder
extends AtomicCoder<ResourceId> {
    private static final Coder<String> STRING_CODER = StringUtf8Coder.of();
    private static final Coder<Boolean> BOOL_CODER = BooleanCoder.of();

    public static ResourceIdCoder of() {
        return new ResourceIdCoder();
    }

    @Override
    public void encode(ResourceId value, OutputStream os) throws IOException {
        STRING_CODER.encode(value.toString(), os);
        BOOL_CODER.encode(value.isDirectory(), os);
    }

    @Override
    public ResourceId decode(InputStream is) throws IOException {
        String spec = STRING_CODER.decode(is);
        boolean isDirectory = BOOL_CODER.decode(is);
        return FileSystems.matchNewResource(spec, isDirectory);
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }
}

