/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.AutoValue_TextIO_Read;
import org.apache.beam.sdk.io.AutoValue_TextIO_ReadAll;
import org.apache.beam.sdk.io.AutoValue_TextIO_ReadFiles;
import org.apache.beam.sdk.io.AutoValue_TextIO_Sink;
import org.apache.beam.sdk.io.AutoValue_TextIO_TypedWrite;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.DynamicFileDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSource;
import org.apache.beam.sdk.io.TextSink;
import org.apache.beam.sdk.io.TextSource;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

public class TextIO {
    private static final long DEFAULT_BUNDLE_SIZE_BYTES = 0x4000000L;

    public static Read read() {
        return new AutoValue_TextIO_Read.Builder().setCompression(Compression.AUTO).setHintMatchesManyFiles(false).setMatchConfiguration(FileIO.MatchConfiguration.create(EmptyMatchTreatment.DISALLOW)).build();
    }

    @Deprecated
    public static ReadAll readAll() {
        return new AutoValue_TextIO_ReadAll.Builder().setCompression(Compression.AUTO).setMatchConfiguration(FileIO.MatchConfiguration.create(EmptyMatchTreatment.ALLOW_IF_WILDCARD)).build();
    }

    public static ReadFiles readFiles() {
        return new AutoValue_TextIO_ReadFiles.Builder().setDesiredBundleSizeBytes(0x4000000L).build();
    }

    public static Write write() {
        return new Write();
    }

    public static <UserT> TypedWrite<UserT, Void> writeCustomType() {
        return new AutoValue_TextIO_TypedWrite.Builder().setFilenamePrefix(null).setTempDirectory(null).setShardTemplate(null).setFilenameSuffix(null).setFilenamePolicy(null).setDynamicDestinations(null).setDelimiter(new char[]{'\n'}).setWritableByteChannelFactory(FileBasedSink.CompressionType.UNCOMPRESSED).setWindowedWrites(false).setNoSpilling(false).build();
    }

    public static Sink sink() {
        return new AutoValue_TextIO_Sink.Builder().build();
    }

    private TextIO() {
    }

    @AutoValue
    public static abstract class Sink
    implements FileIO.Sink<String> {
        private transient @Nullable PrintWriter writer;

        abstract @Nullable String getHeader();

        abstract @Nullable String getFooter();

        abstract Builder toBuilder();

        public Sink withHeader(String header) {
            Preconditions.checkArgument(header != null, "header can not be null");
            return this.toBuilder().setHeader(header).build();
        }

        public Sink withFooter(String footer) {
            Preconditions.checkArgument(footer != null, "footer can not be null");
            return this.toBuilder().setFooter(footer).build();
        }

        @Override
        public void open(WritableByteChannel channel) throws IOException {
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(Channels.newOutputStream(channel), "UTF-8")));
            if (this.getHeader() != null) {
                this.writer.println(this.getHeader());
            }
        }

        @Override
        public void write(String element) throws IOException {
            this.writer.println(element);
        }

        @Override
        public void flush() throws IOException {
            if (this.getFooter() != null) {
                this.writer.println(this.getFooter());
            }
            this.writer.flush();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setHeader(String var1);

            abstract Builder setFooter(String var1);

            abstract Sink build();
        }
    }

    @Deprecated
    public static enum CompressionType {
        AUTO(Compression.AUTO),
        UNCOMPRESSED(Compression.UNCOMPRESSED),
        GZIP(Compression.GZIP),
        BZIP2(Compression.BZIP2),
        ZIP(Compression.ZIP),
        ZSTD(Compression.ZSTD),
        DEFLATE(Compression.DEFLATE);

        private final Compression canonical;

        private CompressionType(Compression canonical) {
            this.canonical = canonical;
        }

        public boolean matches(String filename) {
            return this.canonical.matches(filename);
        }
    }

    public static class Write
    extends PTransform<PCollection<String>, PDone> {
        @VisibleForTesting
        TypedWrite<String, ?> inner;

        Write() {
            this(TextIO.writeCustomType());
        }

        Write(TypedWrite<String, ?> inner) {
            this.inner = inner;
        }

        public Write to(String filenamePrefix) {
            return new Write(this.inner.to(filenamePrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write to(ResourceId filenamePrefix) {
            return new Write(this.inner.to(filenamePrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        public Write to(ValueProvider<String> outputPrefix) {
            return new Write(this.inner.to(outputPrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write toResource(ValueProvider<ResourceId> filenamePrefix) {
            return new Write(this.inner.toResource(filenamePrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write to(FileBasedSink.FilenamePolicy filenamePolicy) {
            return new Write(this.inner.to(filenamePolicy).withFormatFunction(SerializableFunctions.identity()));
        }

        @Deprecated
        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write to(FileBasedSink.DynamicDestinations<String, ?, String> dynamicDestinations) {
            return new Write(this.inner.to(dynamicDestinations).withFormatFunction(null));
        }

        @Deprecated
        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write to(SerializableFunction<String, DefaultFilenamePolicy.Params> destinationFunction, DefaultFilenamePolicy.Params emptyDestination) {
            return new Write(this.inner.to(destinationFunction, emptyDestination).withFormatFunction(SerializableFunctions.identity()));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write withTempDirectory(ValueProvider<ResourceId> tempDirectory) {
            return new Write(this.inner.withTempDirectory(tempDirectory));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write withTempDirectory(ResourceId tempDirectory) {
            return new Write(this.inner.withTempDirectory(tempDirectory));
        }

        public Write withShardNameTemplate(String shardTemplate) {
            return new Write(this.inner.withShardNameTemplate(shardTemplate));
        }

        public Write withSuffix(String filenameSuffix) {
            return new Write(this.inner.withSuffix(filenameSuffix));
        }

        public Write withNumShards(int numShards) {
            return new Write(this.inner.withNumShards(numShards));
        }

        public Write withNumShards(@Nullable ValueProvider<Integer> numShards) {
            return new Write(this.inner.withNumShards(numShards));
        }

        public Write withoutSharding() {
            return new Write(this.inner.withoutSharding());
        }

        public Write withDelimiter(char[] delimiter) {
            return new Write(this.inner.withDelimiter(delimiter));
        }

        public Write withHeader(@Nullable String header) {
            return new Write(this.inner.withHeader(header));
        }

        public Write withFooter(@Nullable String footer) {
            return new Write(this.inner.withFooter(footer));
        }

        public Write withWritableByteChannelFactory(FileBasedSink.WritableByteChannelFactory writableByteChannelFactory) {
            return new Write(this.inner.withWritableByteChannelFactory(writableByteChannelFactory));
        }

        public Write withCompression(Compression compression) {
            return new Write(this.inner.withCompression(compression));
        }

        public Write withWindowedWrites() {
            return new Write(this.inner.withWindowedWrites());
        }

        public Write withNoSpilling() {
            return new Write(this.inner.withNoSpilling());
        }

        public <DestinationT> TypedWrite<String, DestinationT> withOutputFilenames() {
            return this.inner;
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            this.inner.populateDisplayData(builder);
        }

        @Override
        public PDone expand(PCollection<String> input) {
            this.inner.expand(input);
            return PDone.in(input.getPipeline());
        }
    }

    @AutoValue
    public static abstract class TypedWrite<UserT, DestinationT>
    extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>> {
        abstract @Nullable ValueProvider<ResourceId> getFilenamePrefix();

        abstract @Nullable String getFilenameSuffix();

        abstract @Nullable ValueProvider<ResourceId> getTempDirectory();

        abstract char[] getDelimiter();

        abstract @Nullable String getHeader();

        abstract @Nullable String getFooter();

        abstract @Nullable ValueProvider<Integer> getNumShards();

        abstract @Nullable String getShardTemplate();

        abstract @Nullable FileBasedSink.FilenamePolicy getFilenamePolicy();

        abstract @Nullable FileBasedSink.DynamicDestinations<UserT, DestinationT, String> getDynamicDestinations();

        abstract @Nullable SerializableFunction<UserT, DefaultFilenamePolicy.Params> getDestinationFunction();

        abstract @Nullable DefaultFilenamePolicy.Params getEmptyDestination();

        abstract @Nullable SerializableFunction<UserT, String> getFormatFunction();

        abstract boolean getWindowedWrites();

        abstract boolean getNoSpilling();

        abstract FileBasedSink.WritableByteChannelFactory getWritableByteChannelFactory();

        abstract Builder<UserT, DestinationT> toBuilder();

        public TypedWrite<UserT, DestinationT> to(String filenamePrefix) {
            return this.to(FileBasedSink.convertToFileResourceIfPossible(filenamePrefix));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public TypedWrite<UserT, DestinationT> to(ResourceId filenamePrefix) {
            return this.toResource(ValueProvider.StaticValueProvider.of(filenamePrefix));
        }

        public TypedWrite<UserT, DestinationT> to(ValueProvider<String> outputPrefix) {
            return this.toResource(ValueProvider.NestedValueProvider.of(outputPrefix, FileBasedSink::convertToFileResourceIfPossible));
        }

        public TypedWrite<UserT, DestinationT> to(FileBasedSink.FilenamePolicy filenamePolicy) {
            return this.toBuilder().setFilenamePolicy(filenamePolicy).build();
        }

        @Deprecated
        public <NewDestinationT> TypedWrite<UserT, NewDestinationT> to(FileBasedSink.DynamicDestinations<UserT, NewDestinationT, String> dynamicDestinations) {
            return this.toBuilder().setDynamicDestinations(dynamicDestinations).build();
        }

        @Deprecated
        public TypedWrite<UserT, DefaultFilenamePolicy.Params> to(SerializableFunction<UserT, DefaultFilenamePolicy.Params> destinationFunction, DefaultFilenamePolicy.Params emptyDestination) {
            return this.toBuilder().setDestinationFunction(destinationFunction).setEmptyDestination(emptyDestination).build();
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public TypedWrite<UserT, DestinationT> toResource(ValueProvider<ResourceId> filenamePrefix) {
            return this.toBuilder().setFilenamePrefix(filenamePrefix).build();
        }

        @Deprecated
        public TypedWrite<UserT, DestinationT> withFormatFunction(@Nullable SerializableFunction<UserT, String> formatFunction) {
            return this.toBuilder().setFormatFunction(formatFunction).build();
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public TypedWrite<UserT, DestinationT> withTempDirectory(ValueProvider<ResourceId> tempDirectory) {
            return this.toBuilder().setTempDirectory(tempDirectory).build();
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public TypedWrite<UserT, DestinationT> withTempDirectory(ResourceId tempDirectory) {
            return this.withTempDirectory(ValueProvider.StaticValueProvider.of(tempDirectory));
        }

        public TypedWrite<UserT, DestinationT> withShardNameTemplate(String shardTemplate) {
            return this.toBuilder().setShardTemplate(shardTemplate).build();
        }

        public TypedWrite<UserT, DestinationT> withSuffix(String filenameSuffix) {
            return this.toBuilder().setFilenameSuffix(filenameSuffix).build();
        }

        public TypedWrite<UserT, DestinationT> withNumShards(int numShards) {
            Preconditions.checkArgument(numShards >= 0);
            if (numShards == 0) {
                return this.withNumShards(null);
            }
            return this.withNumShards(ValueProvider.StaticValueProvider.of(numShards));
        }

        public TypedWrite<UserT, DestinationT> withNumShards(@Nullable ValueProvider<Integer> numShards) {
            return this.toBuilder().setNumShards(numShards).build();
        }

        public TypedWrite<UserT, DestinationT> withoutSharding() {
            return this.withNumShards(1).withShardNameTemplate("");
        }

        public TypedWrite<UserT, DestinationT> withDelimiter(char[] delimiter) {
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        public TypedWrite<UserT, DestinationT> withHeader(@Nullable String header) {
            return this.toBuilder().setHeader(header).build();
        }

        public TypedWrite<UserT, DestinationT> withFooter(@Nullable String footer) {
            return this.toBuilder().setFooter(footer).build();
        }

        public TypedWrite<UserT, DestinationT> withWritableByteChannelFactory(FileBasedSink.WritableByteChannelFactory writableByteChannelFactory) {
            return this.toBuilder().setWritableByteChannelFactory(writableByteChannelFactory).build();
        }

        public TypedWrite<UserT, DestinationT> withCompression(Compression compression) {
            Preconditions.checkArgument(compression != null, "compression can not be null");
            return this.withWritableByteChannelFactory(FileBasedSink.CompressionType.fromCanonical(compression));
        }

        public TypedWrite<UserT, DestinationT> withWindowedWrites() {
            return this.toBuilder().setWindowedWrites(true).build();
        }

        public TypedWrite<UserT, DestinationT> withNoSpilling() {
            return this.toBuilder().setNoSpilling(true).build();
        }

        private FileBasedSink.DynamicDestinations<UserT, DestinationT, String> resolveDynamicDestinations() {
            FileBasedSink.DynamicDestinations<UserT, Object, String> dynamicDestinations = this.getDynamicDestinations();
            if (dynamicDestinations == null) {
                if (this.getDestinationFunction() != null) {
                    dynamicDestinations = DynamicFileDestinations.toDefaultPolicies(this.getDestinationFunction(), this.getEmptyDestination(), this.getFormatFunction());
                } else {
                    FileBasedSink.FilenamePolicy usedFilenamePolicy = this.getFilenamePolicy();
                    if (usedFilenamePolicy == null) {
                        usedFilenamePolicy = DefaultFilenamePolicy.fromStandardParameters(this.getFilenamePrefix(), this.getShardTemplate(), this.getFilenameSuffix(), this.getWindowedWrites());
                    }
                    dynamicDestinations = DynamicFileDestinations.constant(usedFilenamePolicy, this.getFormatFunction());
                }
            }
            return dynamicDestinations;
        }

        @Override
        public WriteFilesResult<DestinationT> expand(PCollection<UserT> input) {
            ValueProvider<ResourceId> tempDirectory;
            Preconditions.checkState(this.getFilenamePrefix() != null || this.getTempDirectory() != null, "Need to set either the filename prefix or the tempDirectory of a TextIO.Write transform.");
            ArrayList<Serializable> allToArgs = Lists.newArrayList(this.getFilenamePolicy(), this.getDynamicDestinations(), this.getFilenamePrefix(), this.getDestinationFunction());
            Preconditions.checkArgument(1 == Iterables.size(allToArgs.stream().filter(Predicates.notNull()::apply).collect(Collectors.toList())), "Exactly one of filename policy, dynamic destinations, filename prefix, or destination function must be set");
            if (this.getDynamicDestinations() != null) {
                Preconditions.checkArgument(this.getFormatFunction() == null, "A format function should not be specified with DynamicDestinations. Use DynamicDestinations.formatRecord instead");
            }
            if (this.getFilenamePolicy() != null || this.getDynamicDestinations() != null) {
                Preconditions.checkState(this.getShardTemplate() == null && this.getFilenameSuffix() == null, "shardTemplate and filenameSuffix should only be used with the default filename policy");
            }
            if ((tempDirectory = this.getTempDirectory()) == null) {
                tempDirectory = this.getFilenamePrefix();
            }
            WriteFiles write = WriteFiles.to(new TextSink<UserT, DestinationT>(tempDirectory, this.resolveDynamicDestinations(), this.getDelimiter(), this.getHeader(), this.getFooter(), this.getWritableByteChannelFactory()));
            if (this.getNumShards() != null) {
                write = write.withNumShards(this.getNumShards());
            }
            if (this.getWindowedWrites()) {
                write = write.withWindowedWrites();
            }
            if (this.getNoSpilling()) {
                write = write.withNoSpilling();
            }
            return (WriteFilesResult)input.apply("WriteFiles", write);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.resolveDynamicDestinations().populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item("numShards", this.getNumShards()).withLabel("Maximum Output Shards")).addIfNotNull(DisplayData.item("tempDirectory", this.getTempDirectory()).withLabel("Directory for temporary files")).addIfNotNull(DisplayData.item("fileHeader", this.getHeader()).withLabel("File Header")).addIfNotNull(DisplayData.item("fileFooter", this.getFooter()).withLabel("File Footer")).add(DisplayData.item("writableByteChannelFactory", this.getWritableByteChannelFactory().toString()).withLabel("Compression/Transformation Type"));
        }

        @AutoValue.Builder
        static abstract class Builder<UserT, DestinationT> {
            Builder() {
            }

            abstract Builder<UserT, DestinationT> setFilenamePrefix(@Nullable ValueProvider<ResourceId> var1);

            abstract Builder<UserT, DestinationT> setTempDirectory(@Nullable ValueProvider<ResourceId> var1);

            abstract Builder<UserT, DestinationT> setShardTemplate(@Nullable String var1);

            abstract Builder<UserT, DestinationT> setFilenameSuffix(@Nullable String var1);

            abstract Builder<UserT, DestinationT> setHeader(@Nullable String var1);

            abstract Builder<UserT, DestinationT> setFooter(@Nullable String var1);

            abstract Builder<UserT, DestinationT> setDelimiter(char[] var1);

            abstract Builder<UserT, DestinationT> setFilenamePolicy(@Nullable FileBasedSink.FilenamePolicy var1);

            abstract Builder<UserT, DestinationT> setDynamicDestinations(@Nullable FileBasedSink.DynamicDestinations<UserT, DestinationT, String> var1);

            abstract Builder<UserT, DestinationT> setDestinationFunction(@Nullable SerializableFunction<UserT, DefaultFilenamePolicy.Params> var1);

            abstract Builder<UserT, DestinationT> setEmptyDestination(DefaultFilenamePolicy.Params var1);

            abstract Builder<UserT, DestinationT> setFormatFunction(@Nullable SerializableFunction<UserT, String> var1);

            abstract Builder<UserT, DestinationT> setNumShards(@Nullable ValueProvider<Integer> var1);

            abstract Builder<UserT, DestinationT> setWindowedWrites(boolean var1);

            abstract Builder<UserT, DestinationT> setNoSpilling(boolean var1);

            abstract Builder<UserT, DestinationT> setWritableByteChannelFactory(FileBasedSink.WritableByteChannelFactory var1);

            abstract TypedWrite<UserT, DestinationT> build();
        }
    }

    @AutoValue
    public static abstract class ReadFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<String>> {
        abstract long getDesiredBundleSizeBytes();

        abstract byte @Nullable [] getDelimiter();

        abstract Builder toBuilder();

        @VisibleForTesting
        ReadFiles withDesiredBundleSizeBytes(long desiredBundleSizeBytes) {
            return this.toBuilder().setDesiredBundleSizeBytes(desiredBundleSizeBytes).build();
        }

        public ReadFiles withDelimiter(byte[] delimiter) {
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        @Override
        public PCollection<String> expand(PCollection<FileIO.ReadableFile> input) {
            return (PCollection)input.apply("Read all via FileBasedSource", new ReadAllViaFileBasedSource<String>(this.getDesiredBundleSizeBytes(), new CreateTextSourceFn(this.getDelimiter()), StringUtf8Coder.of()));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item("delimiter", Arrays.toString(this.getDelimiter())).withLabel("Custom delimiter to split records"));
        }

        private static class CreateTextSourceFn
        implements SerializableFunction<String, FileBasedSource<String>> {
            private byte[] delimiter;

            private CreateTextSourceFn(byte[] delimiter) {
                this.delimiter = delimiter;
            }

            @Override
            public FileBasedSource<String> apply(String input) {
                return new TextSource(ValueProvider.StaticValueProvider.of(input), EmptyMatchTreatment.DISALLOW, this.delimiter);
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setDesiredBundleSizeBytes(long var1);

            abstract Builder setDelimiter(byte @Nullable [] var1);

            abstract ReadFiles build();
        }
    }

    @Deprecated
    @AutoValue
    public static abstract class ReadAll
    extends PTransform<PCollection<String>, PCollection<String>> {
        abstract FileIO.MatchConfiguration getMatchConfiguration();

        abstract Compression getCompression();

        abstract byte @Nullable [] getDelimiter();

        abstract Builder toBuilder();

        public ReadAll withMatchConfiguration(FileIO.MatchConfiguration configuration) {
            return this.toBuilder().setMatchConfiguration(configuration).build();
        }

        @Deprecated
        public ReadAll withCompressionType(CompressionType compressionType) {
            return this.withCompression(compressionType.canonical);
        }

        public ReadAll withCompression(Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        public ReadAll withEmptyMatchTreatment(EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        public ReadAll watchForNewFiles(Duration pollInterval, Watch.Growth.TerminationCondition<String, ?> terminationCondition) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition));
        }

        ReadAll withDelimiter(byte[] delimiter) {
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        @Override
        public PCollection<String> expand(PCollection<String> input) {
            return input.apply(FileIO.matchAll().withConfiguration(this.getMatchConfiguration())).apply(FileIO.readMatches().withCompression(this.getCompression()).withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT)).apply(TextIO.readFiles().withDelimiter(this.getDelimiter()));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("compressionType", this.getCompression().toString()).withLabel("Compression Type")).addIfNotNull(DisplayData.item("delimiter", Arrays.toString(this.getDelimiter())).withLabel("Custom delimiter to split records")).include("matchConfiguration", this.getMatchConfiguration());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setMatchConfiguration(FileIO.MatchConfiguration var1);

            abstract Builder setCompression(Compression var1);

            abstract Builder setDelimiter(byte @Nullable [] var1);

            abstract ReadAll build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<String>> {
        abstract @Nullable ValueProvider<String> getFilepattern();

        abstract FileIO.MatchConfiguration getMatchConfiguration();

        abstract boolean getHintMatchesManyFiles();

        abstract Compression getCompression();

        abstract byte @Nullable [] getDelimiter();

        abstract Builder toBuilder();

        public Read from(String filepattern) {
            Preconditions.checkArgument(filepattern != null, "filepattern can not be null");
            return this.from(ValueProvider.StaticValueProvider.of(filepattern));
        }

        public Read from(ValueProvider<String> filepattern) {
            Preconditions.checkArgument(filepattern != null, "filepattern can not be null");
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public Read withMatchConfiguration(FileIO.MatchConfiguration matchConfiguration) {
            return this.toBuilder().setMatchConfiguration(matchConfiguration).build();
        }

        @Deprecated
        public Read withCompressionType(CompressionType compressionType) {
            return this.withCompression(compressionType.canonical);
        }

        public Read withCompression(Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        public Read watchForNewFiles(Duration pollInterval, Watch.Growth.TerminationCondition<String, ?> terminationCondition) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition));
        }

        public Read withHintMatchesManyFiles() {
            return this.toBuilder().setHintMatchesManyFiles(true).build();
        }

        public Read withEmptyMatchTreatment(EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        public Read withDelimiter(byte[] delimiter) {
            Preconditions.checkArgument(delimiter != null, "delimiter can not be null");
            Preconditions.checkArgument(!Read.isSelfOverlapping(delimiter), "delimiter must not self-overlap");
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        static boolean isSelfOverlapping(byte[] s2) {
            for (int i = 1; i < s2.length - 1; ++i) {
                if (!ByteBuffer.wrap(s2, 0, i).equals(ByteBuffer.wrap(s2, s2.length - i, i))) continue;
                return true;
            }
            return false;
        }

        @Override
        public PCollection<String> expand(PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), "need to set the filepattern of a TextIO.Read transform");
            if (this.getMatchConfiguration().getWatchInterval() == null && !this.getHintMatchesManyFiles()) {
                return (PCollection)input.apply("Read", org.apache.beam.sdk.io.Read.from(this.getSource()));
            }
            return ((PCollection)input.apply("Create filepattern", Create.ofProvider(this.getFilepattern(), StringUtf8Coder.of()))).apply("Match All", FileIO.matchAll().withConfiguration(this.getMatchConfiguration())).apply("Read Matches", FileIO.readMatches().withCompression(this.getCompression()).withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT)).apply("Via ReadFiles", TextIO.readFiles().withDelimiter(this.getDelimiter()));
        }

        protected FileBasedSource<String> getSource() {
            return CompressedSource.from(new TextSource(this.getFilepattern(), this.getMatchConfiguration().getEmptyMatchTreatment(), this.getDelimiter())).withCompression(this.getCompression());
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("compressionType", this.getCompression().toString()).withLabel("Compression Type")).addIfNotNull(DisplayData.item("filePattern", this.getFilepattern()).withLabel("File Pattern")).include("matchConfiguration", this.getMatchConfiguration()).addIfNotNull(DisplayData.item("delimiter", Arrays.toString(this.getDelimiter())).withLabel("Custom delimiter to split records"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setFilepattern(ValueProvider<String> var1);

            abstract Builder setMatchConfiguration(FileIO.MatchConfiguration var1);

            abstract Builder setHintMatchesManyFiles(boolean var1);

            abstract Builder setCompression(Compression var1);

            abstract Builder setDelimiter(byte @Nullable [] var1);

            abstract Read build();
        }
    }
}

