/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.LocalResourceId;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;

@Experimental(value=Experimental.Kind.FILESYSTEM)
public final class LocalResources {
    public static ResourceId fromFile(File file, boolean isDirectory) {
        return LocalResourceId.fromPath(file.toPath(), isDirectory);
    }

    public static ResourceId fromPath(Path path, boolean isDirectory) {
        return LocalResourceId.fromPath(path, isDirectory);
    }

    public static ResourceId fromString(String filename, boolean isDirectory) {
        return LocalResourceId.fromPath(Paths.get(filename, new String[0]), isDirectory);
    }

    public static ValueProvider<ResourceId> fromString(ValueProvider<String> resourceProvider, boolean isDirectory) {
        return ValueProvider.NestedValueProvider.of(resourceProvider, input -> LocalResources.fromString(input, isDirectory));
    }

    private LocalResources() {
    }
}

