/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.SystemUtils;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.LocalResourceId;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalFileSystem
extends FileSystem<LocalResourceId> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileSystem.class);
    private static final Pattern GLOB_PREFIX = Pattern.compile("(?<PREFIX>[^\\[*?]*)[\\[*?].*");

    LocalFileSystem() {
    }

    @Override
    protected List<MatchResult> match(List<String> specs) throws IOException {
        return this.match(new File(".").getAbsolutePath(), specs);
    }

    @VisibleForTesting
    List<MatchResult> match(String baseDir, List<String> specs) throws IOException {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (String spec : specs) {
            ret.add(this.matchOne(baseDir, spec));
        }
        return ret.build();
    }

    @Override
    protected WritableByteChannel create(LocalResourceId resourceId, CreateOptions createOptions) throws IOException {
        LOG.debug("creating file {}", (Object)resourceId);
        File absoluteFile = resourceId.getPath().toFile().getAbsoluteFile();
        if (!(absoluteFile.getParentFile() == null || absoluteFile.getParentFile().exists() || absoluteFile.getParentFile().mkdirs() || absoluteFile.getParentFile().exists())) {
            throw new IOException("Unable to create parent directories for '" + resourceId + "'");
        }
        return Channels.newChannel(new BufferedOutputStream(new FileOutputStream(absoluteFile)));
    }

    @Override
    protected ReadableByteChannel open(LocalResourceId resourceId) throws IOException {
        LOG.debug("opening file {}", (Object)resourceId);
        FileInputStream inputStream = new FileInputStream(resourceId.getPath().toFile());
        return inputStream.getChannel();
    }

    @Override
    protected void copy(List<LocalResourceId> srcResourceIds, List<LocalResourceId> destResourceIds) throws IOException {
        Preconditions.checkArgument(srcResourceIds.size() == destResourceIds.size(), "Number of source files %s must equal number of destination files %s", srcResourceIds.size(), destResourceIds.size());
        int numFiles = srcResourceIds.size();
        for (int i = 0; i < numFiles; ++i) {
            LocalResourceId src = srcResourceIds.get(i);
            LocalResourceId dst = destResourceIds.get(i);
            LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
            File parent = dst.getCurrentDirectory().getPath().toFile();
            if (!parent.exists()) {
                Preconditions.checkArgument(parent.mkdirs() || parent.exists(), "Unable to make output directory %s in order to copy into file %s", (Object)parent, (Object)dst.getPath());
            }
            Files.copy(src.getPath(), dst.getPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    @Override
    protected void rename(List<LocalResourceId> srcResourceIds, List<LocalResourceId> destResourceIds, MoveOptions ... moveOptions) throws IOException {
        if (moveOptions.length > 0) {
            throw new UnsupportedOperationException("Support for move options is not yet implemented.");
        }
        Preconditions.checkArgument(srcResourceIds.size() == destResourceIds.size(), "Number of source files %s must equal number of destination files %s", srcResourceIds.size(), destResourceIds.size());
        int numFiles = srcResourceIds.size();
        for (int i = 0; i < numFiles; ++i) {
            LocalResourceId src = srcResourceIds.get(i);
            LocalResourceId dst = destResourceIds.get(i);
            LOG.debug("Renaming {} to {}", (Object)src, (Object)dst);
            File parent = dst.getCurrentDirectory().getPath().toFile();
            if (!parent.exists()) {
                Preconditions.checkArgument(parent.mkdirs() || parent.exists(), "Unable to make output directory %s in order to move into file %s", (Object)parent, (Object)dst.getPath());
            }
            Files.move(src.getPath(), dst.getPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
    }

    @Override
    protected void delete(Collection<LocalResourceId> resourceIds) throws IOException {
        for (LocalResourceId resourceId : resourceIds) {
            try {
                Files.delete(resourceId.getPath());
            }
            catch (NoSuchFileException e) {
                LOG.info("Ignoring failed deletion of file {} which already does not exist.", (Object)resourceId, (Object)e);
            }
        }
    }

    @Override
    protected LocalResourceId matchNewResource(String singleResourceSpec, boolean isDirectory) {
        if (isDirectory) {
            if (!singleResourceSpec.endsWith(File.separator)) {
                singleResourceSpec = singleResourceSpec + File.separator;
            }
        } else {
            Preconditions.checkArgument(!singleResourceSpec.endsWith(File.separator), "Expected file path but received directory path [%s].", (Object)singleResourceSpec);
        }
        Path path = Paths.get(singleResourceSpec, new String[0]);
        return LocalResourceId.fromPath(path, isDirectory);
    }

    @Override
    protected String getScheme() {
        return "file";
    }

    private MatchResult matchOne(String baseDir, String spec) {
        File specAsFile;
        File absoluteFile;
        if (spec.toLowerCase().startsWith("file:")) {
            spec = spec.substring("file:".length());
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            List<String> prefixes = Arrays.asList("///", "/");
            for (String prefix : prefixes) {
                if (!spec.toLowerCase().startsWith(prefix)) continue;
                spec = spec.substring(prefix.length());
            }
        }
        File file = absoluteFile = (specAsFile = new File(spec)).isAbsolute() ? specAsFile : new File(baseDir, spec);
        if (absoluteFile.exists()) {
            return MatchResult.create(MatchResult.Status.OK, ImmutableList.of(this.toMetadata(absoluteFile)));
        }
        File parent = this.getSpecNonGlobPrefixParentFile(absoluteFile.getAbsolutePath());
        if (!parent.exists()) {
            return MatchResult.create(MatchResult.Status.NOT_FOUND, Collections.emptyList());
        }
        String pathToMatch = absoluteFile.getAbsolutePath().replaceAll(Matcher.quoteReplacement("\\"), Matcher.quoteReplacement("\\\\"));
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pathToMatch);
        Iterable<File> files = org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.Files.fileTraverser().depthFirstPreOrder(parent);
        Iterable matchedFiles = StreamSupport.stream(files.spliterator(), false).filter(Predicates.and(org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.Files.isFile(), input -> matcher.matches(input.toPath()))::apply).collect(Collectors.toList());
        LinkedList<MatchResult.Metadata> result = Lists.newLinkedList();
        for (File match : matchedFiles) {
            result.add(this.toMetadata(match));
        }
        if (result.isEmpty()) {
            return MatchResult.create(MatchResult.Status.NOT_FOUND, new FileNotFoundException(String.format("No files found for spec: %s in working directory %s", spec, baseDir)));
        }
        return MatchResult.create(MatchResult.Status.OK, result);
    }

    private File getSpecNonGlobPrefixParentFile(String spec) {
        String specNonWildcardPrefix = LocalFileSystem.getNonWildcardPrefix(spec);
        File file = new File(specNonWildcardPrefix);
        return specNonWildcardPrefix.endsWith(File.separator) ? file.getAbsoluteFile() : file.getAbsoluteFile().getParentFile();
    }

    private MatchResult.Metadata toMetadata(File file) {
        return MatchResult.Metadata.builder().setResourceId(LocalResourceId.fromPath(file.toPath(), file.isDirectory())).setIsReadSeekEfficient(true).setSizeBytes(file.length()).setLastModifiedMillis(file.lastModified()).build();
    }

    private static String getNonWildcardPrefix(String globExp) {
        Matcher m3 = GLOB_PREFIX.matcher(globExp);
        return !m3.matches() ? globExp : m3.group("PREFIX");
    }
}

