/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.DynamicAvroDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AvroSink<UserT, DestinationT, OutputT>
extends FileBasedSink<UserT, DestinationT, OutputT> {
    private final boolean genericRecords;

    AvroSink(ValueProvider<ResourceId> outputPrefix, DynamicAvroDestinations<UserT, DestinationT, OutputT> dynamicDestinations, boolean genericRecords) {
        super(outputPrefix, dynamicDestinations, Compression.UNCOMPRESSED);
        this.genericRecords = genericRecords;
    }

    @Override
    public DynamicAvroDestinations<UserT, DestinationT, OutputT> getDynamicDestinations() {
        return (DynamicAvroDestinations)super.getDynamicDestinations();
    }

    @Override
    public FileBasedSink.WriteOperation<DestinationT, OutputT> createWriteOperation() {
        return new AvroWriteOperation(this, this.genericRecords);
    }

    private static class AvroWriter<DestinationT, OutputT>
    extends FileBasedSink.Writer<DestinationT, OutputT> {
        private @Nullable DataFileWriter<OutputT> dataFileWriter;
        private final DynamicAvroDestinations<?, DestinationT, OutputT> dynamicDestinations;
        private final boolean genericRecords;

        public AvroWriter(FileBasedSink.WriteOperation<DestinationT, OutputT> writeOperation, DynamicAvroDestinations<?, DestinationT, OutputT> dynamicDestinations, boolean genericRecords) {
            super(writeOperation, "application/octet-stream");
            this.dynamicDestinations = dynamicDestinations;
            this.genericRecords = genericRecords;
        }

        @Override
        protected void prepareWrite(WritableByteChannel channel) throws Exception {
            Object destination = this.getDestination();
            CodecFactory codec = this.dynamicDestinations.getCodec(destination);
            Schema schema = this.dynamicDestinations.getSchema(destination);
            Map<String, Object> metadata = this.dynamicDestinations.getMetadata(destination);
            DatumWriterFactory<OutputT> datumWriterFactory = this.dynamicDestinations.getDatumWriterFactory(destination);
            DatumWriter<Object> datumWriter = datumWriterFactory == null ? (this.genericRecords ? new GenericDatumWriter<OutputT>(schema) : new ReflectDatumWriter(schema)) : datumWriterFactory.apply(schema);
            this.dataFileWriter = new DataFileWriter<OutputT>(datumWriter).setCodec(codec);
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                Object v = entry.getValue();
                if (v instanceof String) {
                    this.dataFileWriter.setMeta(entry.getKey(), (String)v);
                    continue;
                }
                if (v instanceof Long) {
                    this.dataFileWriter.setMeta(entry.getKey(), (Long)v);
                    continue;
                }
                if (v instanceof byte[]) {
                    this.dataFileWriter.setMeta(entry.getKey(), (byte[])v);
                    continue;
                }
                throw new IllegalStateException("Metadata value type must be one of String, Long, or byte[]. Found " + v.getClass().getSimpleName());
            }
            this.dataFileWriter.create(schema, Channels.newOutputStream(channel));
        }

        @Override
        public void write(OutputT value) throws Exception {
            this.dataFileWriter.append(value);
        }

        @Override
        protected void finishWrite() throws Exception {
            this.dataFileWriter.flush();
        }
    }

    private static class AvroWriteOperation<DestinationT, OutputT>
    extends FileBasedSink.WriteOperation<DestinationT, OutputT> {
        private final DynamicAvroDestinations<?, DestinationT, OutputT> dynamicDestinations;
        private final boolean genericRecords;

        private AvroWriteOperation(AvroSink<?, DestinationT, OutputT> sink, boolean genericRecords) {
            super(sink);
            this.dynamicDestinations = sink.getDynamicDestinations();
            this.genericRecords = genericRecords;
        }

        @Override
        public FileBasedSink.Writer<DestinationT, OutputT> createWriter() throws Exception {
            return new AvroWriter<DestinationT, OutputT>(this, this.dynamicDestinations, this.genericRecords);
        }
    }

    @FunctionalInterface
    public static interface DatumWriterFactory<T>
    extends Serializable {
        public DatumWriter<T> apply(Schema var1);
    }
}

