/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadIdResponseInterceptor
implements HttpResponseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(UploadIdResponseInterceptor.class);
    private static final String UPLOAD_ID_PARAM = "upload_id";
    private static final String UPLOAD_TYPE_PARAM = "uploadType";
    private static final String UPLOAD_HEADER = "X-GUploader-UploadID";

    @Override
    public void interceptResponse(HttpResponse response) throws IOException {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        String uploadId = response.getHeaders().getFirstHeaderStringValue(UPLOAD_HEADER);
        if (uploadId == null) {
            return;
        }
        GenericUrl url = response.getRequest().getUrl();
        if (url.get(UPLOAD_ID_PARAM) == null && url.get(UPLOAD_TYPE_PARAM) != null) {
            LOG.debug("Upload ID for url {} on worker {} is {}", url, System.getProperty("worker_id"), uploadId);
        }
    }
}

