/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.UploadIdResponseInterceptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class Transport {
    public static HttpTransport getTransport() {
        return SingletonHelper.HTTP_TRANSPORT;
    }

    public static JsonFactory getJsonFactory() {
        return SingletonHelper.JSON_FACTORY;
    }

    private static ApiComponents apiComponentsFromUrl(String urlString) {
        try {
            URL url = new URL(urlString);
            String rootUrl = url.getProtocol() + "://" + url.getHost() + (url.getPort() > 0 ? ":" + url.getPort() : "");
            return new ApiComponents(rootUrl, url.getPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL: " + urlString);
        }
    }

    public static Storage.Builder newStorageClient(GcsOptions options) {
        String servicePath = options.getGcsEndpoint();
        Storage.Builder storageBuilder = new Storage.Builder(Transport.getTransport(), Transport.getJsonFactory(), Transport.chainHttpRequestInitializer(options.getGcpCredential(), new RetryHttpRequestInitializer(ImmutableList.of(Integer.valueOf(404)), new UploadIdResponseInterceptor()))).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer(options.getGoogleApiTrace());
        if (servicePath != null) {
            ApiComponents components = Transport.apiComponentsFromUrl(servicePath);
            storageBuilder.setRootUrl(components.rootUrl);
            storageBuilder.setServicePath(components.servicePath);
            storageBuilder.setBatchPath(Paths.get("batch/", components.servicePath).toString());
        }
        return storageBuilder;
    }

    private static HttpRequestInitializer chainHttpRequestInitializer(Credentials credential, HttpRequestInitializer httpRequestInitializer) {
        if (credential == null) {
            return new ChainingHttpRequestInitializer(new NullCredentialInitializer(), httpRequestInitializer);
        }
        return new ChainingHttpRequestInitializer(new HttpCredentialsAdapter(credential), httpRequestInitializer);
    }

    private static class ApiComponents {
        public String rootUrl;
        public String servicePath;

        public ApiComponents(String root, String path) {
            this.rootUrl = root;
            this.servicePath = path;
        }
    }

    private static class SingletonHelper {
        private static final JsonFactory JSON_FACTORY;
        private static final HttpTransport HTTP_TRANSPORT;

        private SingletonHelper() {
        }

        static {
            try {
                JSON_FACTORY = JacksonFactory.getDefaultInstance();
                HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

