/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.values.TypeDescriptor;

public class TextualIntegerCoder
extends AtomicCoder<Integer> {
    private static final TypeDescriptor<Integer> TYPE_DESCRIPTOR = new TypeDescriptor<Integer>(){};

    public static TextualIntegerCoder of() {
        return new TextualIntegerCoder();
    }

    protected TextualIntegerCoder() {
    }

    @Override
    public void encode(Integer value, OutputStream outStream) throws IOException, CoderException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(Integer value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        String textualValue = value.toString();
        StringUtf8Coder.of().encode(textualValue, outStream, context);
    }

    @Override
    public Integer decode(InputStream inStream) throws IOException, CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public Integer decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        String textualValue = StringUtf8Coder.of().decode(inStream, context);
        try {
            return Integer.valueOf(textualValue);
        }
        catch (NumberFormatException exn) {
            throw new CoderException("error when decoding a textual integer", exn);
        }
    }

    @Override
    public void verifyDeterministic() {
        StringUtf8Coder.of().verifyDeterministic();
    }

    @Override
    public TypeDescriptor<Integer> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected long getEncodedElementByteSize(Integer value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        String textualValue = value.toString();
        return StringUtf8Coder.of().getEncodedElementByteSize(textualValue);
    }
}

