/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class StructuredCoder<T>
extends Coder<T> {
    protected StructuredCoder() {
    }

    public List<? extends Coder<?>> getComponents() {
        return this.getCoderArguments();
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructuredCoder that = (StructuredCoder)o;
        return this.getComponents().equals(that.getComponents());
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.getComponents().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String s2 = this.getClass().getName();
        builder.append(s2.substring(s2.lastIndexOf(46) + 1));
        List<Coder<?>> componentCoders = this.getComponents();
        if (!componentCoders.isEmpty()) {
            builder.append('(');
            boolean first = true;
            for (Coder<?> componentCoder : componentCoders) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(componentCoder.toString());
            }
            builder.append(')');
        }
        return builder.toString();
    }
}

