/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.ExposedByteArrayOutputStream;
import org.apache.beam.sdk.util.StreamUtils;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Utf8;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;

public class StringUtf8Coder
extends AtomicCoder<String> {
    private static final StringUtf8Coder INSTANCE = new StringUtf8Coder();
    private static final TypeDescriptor<String> TYPE_DESCRIPTOR = new TypeDescriptor<String>(){};

    public static StringUtf8Coder of() {
        return INSTANCE;
    }

    private static void writeString(String value, OutputStream dos) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        VarInt.encode(bytes.length, dos);
        dos.write(bytes);
    }

    private static String readString(InputStream dis) throws IOException {
        int len = VarInt.decodeInt(dis);
        if (len < 0) {
            throw new CoderException("Invalid encoded string length: " + len);
        }
        byte[] bytes = new byte[len];
        ByteStreams.readFully(dis, bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private StringUtf8Coder() {
    }

    @Override
    public void encode(String value, OutputStream outStream) throws IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(String value, OutputStream outStream, Coder.Context context) throws IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null String");
        }
        if (context.isWholeStream) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            if (outStream instanceof ExposedByteArrayOutputStream) {
                ((ExposedByteArrayOutputStream)outStream).writeAndOwn(bytes);
            } else {
                outStream.write(bytes);
            }
        } else {
            StringUtf8Coder.writeString(value, outStream);
        }
    }

    @Override
    public String decode(InputStream inStream) throws IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public String decode(InputStream inStream, Coder.Context context) throws IOException {
        if (context.isWholeStream) {
            byte[] bytes = StreamUtils.getBytesWithoutClosing(inStream);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        try {
            return StringUtf8Coder.readString(inStream);
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public TypeDescriptor<String> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public long getEncodedElementByteSize(String value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null String");
        }
        int size = Utf8.encodedLength(value);
        return (long)VarInt.getLength(size) + (long)size;
    }
}

