/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NullableCoder<T>
extends StructuredCoder<T> {
    private final Coder<T> valueCoder;
    private static final int ENCODE_NULL = 0;
    private static final int ENCODE_PRESENT = 1;

    public static <T> NullableCoder<T> of(Coder<T> valueCoder) {
        if (valueCoder instanceof NullableCoder) {
            return (NullableCoder)valueCoder;
        }
        return new NullableCoder<T>(valueCoder);
    }

    private NullableCoder(Coder<T> valueCoder) {
        this.valueCoder = valueCoder;
    }

    public Coder<T> getValueCoder() {
        return this.valueCoder;
    }

    @Override
    public void encode(@Nullable T value, OutputStream outStream) throws IOException, CoderException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(@Nullable T value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            outStream.write(0);
        } else {
            outStream.write(1);
            this.valueCoder.encode(value, outStream, context);
        }
    }

    @Override
    public T decode(InputStream inStream) throws IOException, CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public @Nullable T decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        int b = inStream.read();
        if (b == 0) {
            return null;
        }
        if (b != 1) {
            throw new CoderException(String.format("NullableCoder expects either a byte valued %s (null) or %s (present), got %s", 0, 1, b));
        }
        return this.valueCoder.decode(inStream, context);
    }

    @Override
    public List<Coder<T>> getCoderArguments() {
        return ImmutableList.of(this.valueCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        NullableCoder.verifyDeterministic(this, "Value coder must be deterministic", this.valueCoder);
    }

    @Override
    public boolean consistentWithEquals() {
        return this.valueCoder.consistentWithEquals();
    }

    @Override
    public Object structuralValue(@Nullable T value) {
        if (value == null) {
            return Optional.absent();
        }
        return Optional.of(this.valueCoder.structuralValue(value));
    }

    @Override
    public void registerByteSizeObserver(@Nullable T value, ElementByteSizeObserver observer) throws Exception {
        observer.update(1);
        if (value != null) {
            this.valueCoder.registerByteSizeObserver(value, observer);
        }
    }

    @Override
    protected long getEncodedElementByteSize(@Nullable T value) throws Exception {
        if (value == null) {
            return 1L;
        }
        if (this.valueCoder instanceof StructuredCoder) {
            return 1L + ((StructuredCoder)this.valueCoder).getEncodedElementByteSize(value);
        }
        return super.getEncodedElementByteSize(value);
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(@Nullable T value) {
        if (value == null) {
            return true;
        }
        return this.valueCoder.isRegisterByteSizeObserverCheap(value);
    }

    @Override
    public TypeDescriptor<T> getEncodedTypeDescriptor() {
        return this.valueCoder.getEncodedTypeDescriptor();
    }
}

