/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.values.TypeDescriptor;

public class DoubleCoder
extends AtomicCoder<Double> {
    private static final DoubleCoder INSTANCE = new DoubleCoder();
    private static final TypeDescriptor<Double> TYPE_DESCRIPTOR = new TypeDescriptor<Double>(){};

    public static DoubleCoder of() {
        return INSTANCE;
    }

    private DoubleCoder() {
    }

    @Override
    public void encode(Double value, OutputStream outStream) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Double");
        }
        new DataOutputStream(outStream).writeDouble(value);
    }

    @Override
    public Double decode(InputStream inStream) throws IOException, CoderException {
        try {
            return new DataInputStream(inStream).readDouble();
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Floating point encodings are not guaranteed to be deterministic.");
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Double value) {
        return true;
    }

    @Override
    public TypeDescriptor<Double> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected long getEncodedElementByteSize(Double value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Double");
        }
        return 8L;
    }
}

