/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.BitSetCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviderRegistrar;
import org.apache.beam.sdk.coders.CoderProviders;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.FloatCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.ReadableFileCoder;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MetadataCoder;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.fs.ResourceIdCoder;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSetMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.SetMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoderRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CoderRegistry.class);
    private static final List<CoderProvider> REGISTERED_CODER_FACTORIES;
    private ArrayDeque<CoderProvider> coderProviders = new ArrayDeque<CoderProvider>(REGISTERED_CODER_FACTORIES);

    public static CoderRegistry createDefault() {
        return new CoderRegistry();
    }

    private CoderRegistry() {
    }

    public void registerCoderProvider(CoderProvider coderProvider) {
        this.coderProviders.addFirst(coderProvider);
    }

    public void registerCoderForClass(Class<?> clazz, Coder<?> coder) {
        this.registerCoderForType(TypeDescriptor.of(clazz), coder);
    }

    public void registerCoderForType(TypeDescriptor<?> type, Coder<?> coder) {
        this.registerCoderProvider(CoderProviders.forCoder(type, coder));
    }

    public <T> Coder<T> getCoder(Class<T> clazz) throws CannotProvideCoderException {
        return this.getCoder(TypeDescriptor.of(clazz));
    }

    public <T> Coder<T> getCoder(TypeDescriptor<T> type) throws CannotProvideCoderException {
        return this.getCoderFromTypeDescriptor(type, HashMultimap.create());
    }

    @Deprecated
    @Internal
    public <InputT, OutputT> Coder<OutputT> getCoder(TypeDescriptor<OutputT> typeDescriptor, TypeDescriptor<InputT> inputTypeDescriptor, Coder<InputT> inputCoder) throws CannotProvideCoderException {
        Preconditions.checkArgument(typeDescriptor != null);
        Preconditions.checkArgument(inputTypeDescriptor != null);
        Preconditions.checkArgument(inputCoder != null);
        return this.getCoderFromTypeDescriptor(typeDescriptor, this.getTypeToCoderBindings(inputTypeDescriptor.getType(), inputCoder));
    }

    @Deprecated
    @Internal
    public <InputT, OutputT> Coder<OutputT> getOutputCoder(SerializableFunction<InputT, OutputT> fn, Coder<InputT> inputCoder) throws CannotProvideCoderException {
        ParameterizedType fnType = (ParameterizedType)TypeDescriptor.of(fn.getClass()).getSupertype(SerializableFunction.class).getType();
        return this.getCoder(fn.getClass(), SerializableFunction.class, ImmutableMap.of(fnType.getActualTypeArguments()[0], inputCoder), SerializableFunction.class.getTypeParameters()[1]);
    }

    @Deprecated
    @Internal
    public <T, OutputT> Coder<OutputT> getCoder(Class<? extends T> subClass, Class<T> baseClass, Map<Type, ? extends Coder<?>> knownCoders, TypeVariable<?> param) throws CannotProvideCoderException {
        Map<Type, Coder<?>> inferredCoders = this.getDefaultCoders(subClass, baseClass, knownCoders);
        Coder<?> paramCoderOrNull = inferredCoders.get(param);
        if (paramCoderOrNull != null) {
            return paramCoderOrNull;
        }
        throw new CannotProvideCoderException("Cannot infer coder for type parameter " + param);
    }

    private <T> Map<Type, Coder<?>> getDefaultCoders(Class<? extends T> subClass, Class<T> baseClass, Map<Type, ? extends Coder<?>> knownCoders) {
        TypeVariable<Class<T>>[] typeParams = baseClass.getTypeParameters();
        Coder[] knownCodersArray = new Coder[typeParams.length];
        for (int i = 0; i < typeParams.length; ++i) {
            knownCodersArray[i] = knownCoders.get(typeParams[i]);
        }
        Coder<?>[] resultArray = this.getDefaultCoders(subClass, baseClass, knownCodersArray);
        HashMap result = new HashMap();
        for (int i = 0; i < typeParams.length; ++i) {
            if (resultArray[i] == null) continue;
            result.put(typeParams[i], resultArray[i]);
        }
        return result;
    }

    private <T> Coder<?>[] getDefaultCoders(Class<? extends T> subClass, Class<T> baseClass, @Nullable Coder<?>[] knownCoders) {
        Type type = TypeDescriptor.of(subClass).getSupertype(baseClass).getType();
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException(type + " is not a ParameterizedType");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        if (knownCoders == null) {
            knownCoders = new Coder[typeArgs.length];
        } else if (typeArgs.length != knownCoders.length) {
            throw new IllegalArgumentException(String.format("Class %s has %d parameters, but %d coders are requested.", baseClass.getCanonicalName(), typeArgs.length, knownCoders.length));
        }
        HashMultimap<Type, Coder<?>> context = HashMultimap.create();
        for (int i = 0; i < knownCoders.length; ++i) {
            if (knownCoders[i] == null) continue;
            try {
                CoderRegistry.verifyCompatible(knownCoders[i], typeArgs[i]);
            }
            catch (IncompatibleCoderException exn) {
                throw new IllegalArgumentException(String.format("Provided coders for type arguments of %s contain incompatibilities: Cannot encode elements of type %s with coder %s", baseClass, typeArgs[i], knownCoders[i]), exn);
            }
            context.putAll(this.getTypeToCoderBindings(typeArgs[i], knownCoders[i]));
        }
        Coder[] result = new Coder[typeArgs.length];
        for (int i = 0; i < knownCoders.length; ++i) {
            if (knownCoders[i] != null) {
                result[i] = knownCoders[i];
                continue;
            }
            try {
                result[i] = this.getCoderFromTypeDescriptor(TypeDescriptor.of(typeArgs[i]), context);
                continue;
            }
            catch (CannotProvideCoderException exc) {
                result[i] = null;
            }
        }
        return result;
    }

    @VisibleForTesting
    static <T, CoderT extends Coder<T>, CandidateT> void verifyCompatible(CoderT coder, Type candidateType) throws IncompatibleCoderException {
        Class<?> coderClass = coder.getClass();
        TypeDescriptor<?> coderDescriptor = TypeDescriptor.of(coderClass);
        TypeDescriptor codedDescriptor = CoderUtils.getCodedType(coderDescriptor);
        Class codedClass = codedDescriptor.getRawType();
        Type codedType = codedDescriptor.getType();
        TypeDescriptor<?> candidateDescriptor = TypeDescriptor.of(candidateType);
        Class<?> candidateClass = candidateDescriptor.getRawType();
        if (candidateType instanceof TypeVariable) {
            return;
        }
        if (!codedClass.isAssignableFrom(candidateClass)) {
            throw new IncompatibleCoderException(String.format("Cannot encode elements of type %s with coder %s because the coded type %s is not assignable from %s", candidateType, coder, codedClass, candidateType), coder, candidateType);
        }
        TypeDescriptor<?> candidateOkDescriptor = candidateDescriptor;
        if (codedType instanceof ParameterizedType && !CoderRegistry.isNullOrEmpty(coder.getCoderArguments())) {
            List<Coder<?>> typeArgumentCoders;
            ParameterizedType parameterizedSupertype = (ParameterizedType)candidateOkDescriptor.getSupertype(codedClass).getType();
            Type[] typeArguments = parameterizedSupertype.getActualTypeArguments();
            if (typeArguments.length < (typeArgumentCoders = coder.getCoderArguments()).size()) {
                throw new IncompatibleCoderException(String.format("Cannot encode elements of type %s with coder %s: the generic supertype %s has %s type parameters, which is less than the number of coder arguments %s has (%s).", candidateOkDescriptor, coder, parameterizedSupertype, typeArguments.length, coder, typeArgumentCoders.size()), coder, candidateOkDescriptor.getType());
            }
            for (int i = 0; i < typeArgumentCoders.size(); ++i) {
                try {
                    Coder<?> typeArgumentCoder = typeArgumentCoders.get(i);
                    CoderRegistry.verifyCompatible(typeArgumentCoder, candidateDescriptor.resolveType(typeArguments[i]).getType());
                    continue;
                }
                catch (IncompatibleCoderException exn) {
                    throw new IncompatibleCoderException(String.format("Cannot encode elements of type %s with coder %s because some component coder is incompatible", candidateType, coder), coder, candidateType, exn);
                }
            }
        }
    }

    private static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> Coder<T> getCoderFromTypeDescriptor(TypeDescriptor<T> typeDescriptor, SetMultimap<Type, Coder<?>> typeCoderBindings) throws CannotProvideCoderException {
        Coder<?> coder;
        Type type = typeDescriptor.getType();
        if (typeDescriptor.equals(TypeDescriptors.rows())) {
            throw new CannotProvideCoderException("Cannot provide a coder for a Beam Row. Please provide a schema instead using PCollection.setRowSchema.");
        }
        if (typeCoderBindings.containsKey(type)) {
            Collection coders = typeCoderBindings.get((Object)type);
            if (coders.size() != 1) throw new CannotProvideCoderException(String.format("Cannot provide a coder for type variable %s because the actual type is over specified by multiple incompatible coders %s.", type, coders), CannotProvideCoderException.ReasonCode.OVER_SPECIFIED);
            coder = (Coder<?>)Iterables.getOnlyElement(coders);
        } else if (type instanceof Class) {
            coder = this.getCoderFromFactories(typeDescriptor, Collections.emptyList());
        } else if (type instanceof ParameterizedType) {
            coder = this.getCoderFromParameterizedType((ParameterizedType)type, typeCoderBindings);
        } else if (type instanceof TypeVariable) {
            coder = this.getCoderFromFactories(typeDescriptor, Collections.emptyList());
        } else {
            if (!(type instanceof WildcardType)) throw new RuntimeException("Internal error: unexpected kind of Type: " + type);
            throw new CannotProvideCoderException(String.format("Cannot provide a coder for wildcard type %s.", type), CannotProvideCoderException.ReasonCode.UNKNOWN);
        }
        LOG.debug("Coder for {}: {}", (Object)typeDescriptor, (Object)coder);
        return coder;
    }

    private Coder<?> getCoderFromParameterizedType(ParameterizedType type, SetMultimap<Type, Coder<?>> typeCoderBindings) throws CannotProvideCoderException {
        ArrayList typeArgumentCoders = new ArrayList();
        for (Type typeArgument : type.getActualTypeArguments()) {
            try {
                Coder<?> typeArgumentCoder = this.getCoderFromTypeDescriptor(TypeDescriptor.of(typeArgument), typeCoderBindings);
                typeArgumentCoders.add(typeArgumentCoder);
            }
            catch (CannotProvideCoderException exc) {
                throw new CannotProvideCoderException(String.format("Cannot provide coder for parameterized type %s: %s", type, exc.getMessage()), exc);
            }
        }
        return this.getCoderFromFactories(TypeDescriptor.of(type), typeArgumentCoders);
    }

    private Coder<?> getCoderFromFactories(TypeDescriptor<?> typeDescriptor, List<Coder<?>> typeArgumentCoders) throws CannotProvideCoderException {
        ArrayList<CannotProvideCoderException> suppressedExceptions = new ArrayList<CannotProvideCoderException>();
        for (CoderProvider coderProvider : this.coderProviders) {
            try {
                return coderProvider.coderFor(typeDescriptor, typeArgumentCoders);
            }
            catch (CannotProvideCoderException e) {
                suppressedExceptions.add(e);
            }
        }
        StringBuilder messageBuilder = new StringBuilder().append("Unable to provide a Coder for ").append(typeDescriptor).append(".\n").append("  Building a Coder using a registered CoderProvider failed.\n").append("  See suppressed exceptions for detailed failures.");
        CannotProvideCoderException exceptionOnFailure = new CannotProvideCoderException(messageBuilder.toString());
        for (CannotProvideCoderException suppressedException : suppressedExceptions) {
            exceptionOnFailure.addSuppressed(suppressedException);
        }
        throw exceptionOnFailure;
    }

    private SetMultimap<Type, Coder<?>> getTypeToCoderBindings(Type type, Coder<?> coder) {
        Preconditions.checkArgument(type != null);
        Preconditions.checkArgument(coder != null);
        if (type instanceof TypeVariable || type instanceof Class) {
            return ImmutableSetMultimap.of(type, coder);
        }
        if (type instanceof ParameterizedType) {
            return this.getTypeToCoderBindings((ParameterizedType)type, coder);
        }
        return ImmutableSetMultimap.of();
    }

    private SetMultimap<Type, Coder<?>> getTypeToCoderBindings(ParameterizedType type, Coder<?> coder) {
        List<Type> typeArguments = Arrays.asList(type.getActualTypeArguments());
        List<Coder<?>> coderArguments = coder.getCoderArguments();
        if (coderArguments == null || typeArguments.size() != coderArguments.size()) {
            return ImmutableSetMultimap.of();
        }
        HashMultimap<Type, Coder<?>> typeToCoder = HashMultimap.create();
        typeToCoder.put(type, coder);
        for (int i = 0; i < typeArguments.size(); ++i) {
            Type typeArgument = typeArguments.get(i);
            Coder<?> coderArgument = coderArguments.get(i);
            if (coderArgument == null) continue;
            typeToCoder.putAll(this.getTypeToCoderBindings(typeArgument, coderArgument));
        }
        return ((ImmutableSetMultimap.Builder)ImmutableSetMultimap.builder().putAll(typeToCoder)).build();
    }

    static {
        ArrayList<CoderProvider> codersToRegister = new ArrayList<CoderProvider>();
        codersToRegister.add(new CommonTypes());
        TreeSet<Object> registrars = Sets.newTreeSet(ReflectHelpers.ObjectsClassComparator.INSTANCE);
        registrars.addAll(Lists.newArrayList(ServiceLoader.load(CoderProviderRegistrar.class, ReflectHelpers.findClassLoader())));
        codersToRegister.addAll(new DefaultCoder.DefaultCoderProviderRegistrar().getCoderProviders());
        for (CoderProviderRegistrar coderProviderRegistrar : registrars) {
            codersToRegister.addAll(coderProviderRegistrar.getCoderProviders());
        }
        codersToRegister.add(SerializableCoder.getCoderProvider());
        REGISTERED_CODER_FACTORIES = ImmutableList.copyOf(codersToRegister);
    }

    @VisibleForTesting
    static class IncompatibleCoderException
    extends RuntimeException {
        private Coder<?> coder;
        private Type type;

        IncompatibleCoderException(String message, Coder<?> coder, Type type) {
            super(message);
            this.coder = coder;
            this.type = type;
        }

        IncompatibleCoderException(String message, Coder<?> coder, Type type, Throwable cause) {
            super(message, cause);
            this.coder = coder;
            this.type = type;
        }

        public Coder<?> getCoder() {
            return this.coder;
        }

        public Type getType() {
            return this.type;
        }
    }

    private static class CommonTypes
    extends CoderProvider {
        private final Map<Class<?>, CoderProvider> commonTypesToCoderProviders;

        private CommonTypes() {
            ImmutableMap.Builder<Class<IntervalWindow>, CoderProvider> builder = ImmutableMap.builder();
            builder.put(Boolean.class, CoderProviders.fromStaticMethods(Boolean.class, BooleanCoder.class));
            builder.put(Byte.class, CoderProviders.fromStaticMethods(Byte.class, ByteCoder.class));
            builder.put(BitSet.class, CoderProviders.fromStaticMethods(BitSet.class, BitSetCoder.class));
            builder.put(Float.class, CoderProviders.fromStaticMethods(Float.class, FloatCoder.class));
            builder.put(Double.class, CoderProviders.fromStaticMethods(Double.class, DoubleCoder.class));
            builder.put(Instant.class, CoderProviders.fromStaticMethods(Instant.class, InstantCoder.class));
            builder.put(Integer.class, CoderProviders.fromStaticMethods(Integer.class, VarIntCoder.class));
            builder.put(Iterable.class, CoderProviders.fromStaticMethods(Iterable.class, IterableCoder.class));
            builder.put(KV.class, CoderProviders.fromStaticMethods(KV.class, KvCoder.class));
            builder.put(List.class, CoderProviders.fromStaticMethods(List.class, ListCoder.class));
            builder.put(Long.class, CoderProviders.fromStaticMethods(Long.class, VarLongCoder.class));
            builder.put(Map.class, CoderProviders.fromStaticMethods(Map.class, MapCoder.class));
            builder.put(MatchResult.Metadata.class, CoderProviders.fromStaticMethods(MatchResult.Metadata.class, MetadataCoder.class));
            builder.put(ResourceId.class, CoderProviders.fromStaticMethods(ResourceId.class, ResourceIdCoder.class));
            builder.put(FileIO.ReadableFile.class, CoderProviders.fromStaticMethods(FileIO.ReadableFile.class, ReadableFileCoder.class));
            builder.put(Set.class, CoderProviders.fromStaticMethods(Set.class, SetCoder.class));
            builder.put(String.class, CoderProviders.fromStaticMethods(String.class, StringUtf8Coder.class));
            builder.put(TimestampedValue.class, CoderProviders.fromStaticMethods(TimestampedValue.class, TimestampedValue.TimestampedValueCoder.class));
            builder.put(Void.class, CoderProviders.fromStaticMethods(Void.class, VoidCoder.class));
            builder.put(byte[].class, CoderProviders.fromStaticMethods(byte[].class, ByteArrayCoder.class));
            builder.put(IntervalWindow.class, CoderProviders.forCoder(TypeDescriptor.of(IntervalWindow.class), IntervalWindow.getCoder()));
            this.commonTypesToCoderProviders = builder.build();
        }

        @Override
        public <T> Coder<T> coderFor(TypeDescriptor<T> typeDescriptor, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
            CoderProvider factory = this.commonTypesToCoderProviders.get(typeDescriptor.getRawType());
            if (factory == null) {
                throw new CannotProvideCoderException(String.format("%s is not one of the common types.", typeDescriptor));
            }
            return factory.coderFor(typeDescriptor, componentCoders);
        }
    }
}

