/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.Objects;
import org.apache.beam.runners.core.metrics.DirtyState;
import org.apache.beam.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.util.HistogramData;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HistogramCell
implements Histogram,
MetricCell<HistogramData> {
    private final DirtyState dirty = new DirtyState();
    private final HistogramData value;
    private final MetricName name;

    public HistogramCell(KV<MetricName, HistogramData.BucketType> kv) {
        this.name = kv.getKey();
        this.value = new HistogramData(kv.getValue());
    }

    @Override
    public void reset() {
        this.dirty.afterModification();
        this.value.clear();
    }

    @Override
    public void update(double value) {
        this.value.record(value);
        this.dirty.afterModification();
    }

    public void update(HistogramCell other) {
        this.value.update(other.value);
        this.dirty.afterModification();
    }

    public void incBucketCount(int bucketIndex, long count) {
        this.value.incBucketCount(bucketIndex, count);
        this.dirty.afterModification();
    }

    public void incTopBucketCount(long count) {
        this.value.incTopBucketCount(count);
        this.dirty.afterModification();
    }

    public void incBottomBucketCount(long count) {
        this.value.incBottomBucketCount(count);
        this.dirty.afterModification();
    }

    @Override
    public DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public HistogramData getCumulative() {
        return this.value;
    }

    @Override
    public MetricName getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof HistogramCell) {
            HistogramCell histogramCell = (HistogramCell)object;
            return Objects.equals(this.dirty, histogramCell.dirty) && Objects.equals(this.value, histogramCell.value) && Objects.equals(this.name, histogramCell.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dirty, this.value, this.name);
    }
}

