/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction.resources;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.resources.PipelineResourcesOptions;
import org.apache.beam.sdk.options.FileStagingOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.ZipFiles;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Funnels;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hasher;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineResources {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineResources.class);

    public static List<String> detectClassPathResourcesToStage(ClassLoader classLoader, PipelineOptions options) {
        PipelineResourcesOptions artifactsRelatedOptions = options.as(PipelineResourcesOptions.class);
        List<String> detectedResources = artifactsRelatedOptions.getPipelineResourcesDetector().detect(classLoader);
        return detectedResources.stream().filter(PipelineResources.isStageable()).collect(Collectors.toList());
    }

    private static Predicate<String> isStageable() {
        return resourcePath -> !resourcePath.contains("gradle/wrapper");
    }

    public static void prepareFilesForStaging(FileStagingOptions options) {
        List<String> filesToStage = options.getFilesToStage();
        if (filesToStage == null || filesToStage.isEmpty()) {
            filesToStage = PipelineResources.detectClassPathResourcesToStage(ReflectHelpers.findClassLoader(), options);
            LOG.info("PipelineOptions.filesToStage was not specified. Defaulting to files from the classpath: will stage {} files. Enable logging at DEBUG level to see which files will be staged.", (Object)filesToStage.size());
            LOG.debug("Classpath elements: {}", (Object)filesToStage);
        }
        String tmpJarLocation = MoreObjects.firstNonNull(options.getTempLocation(), System.getProperty("java.io.tmpdir"));
        List<String> resourcesToStage = PipelineResources.prepareFilesForStaging(filesToStage, tmpJarLocation);
        options.setFilesToStage(resourcesToStage);
    }

    public static List<String> prepareFilesForStaging(List<String> resourcesToStage, String tmpJarLocation) {
        return resourcesToStage.stream().map(File::new).map(file -> {
            Preconditions.checkState(file.exists(), "To-be-staged file does not exist: '%s'", file);
            return file.isDirectory() ? PipelineResources.packageDirectoriesToStage(file, tmpJarLocation) : file.getAbsolutePath();
        }).collect(Collectors.toList());
    }

    private static String packageDirectoriesToStage(File directoryToStage, String tmpJarLocation) {
        String hash = PipelineResources.calculateDirectoryContentHash(directoryToStage);
        String pathForJar = PipelineResources.getUniqueJarPath(hash, tmpJarLocation);
        try {
            ZipFiles.zipDirectoryOverwrite(directoryToStage, new File(pathForJar));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return pathForJar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String calculateDirectoryContentHash(File directoryToStage) {
        Hasher hasher = Hashing.sha256().newHasher();
        try (OutputStream hashStream = Funnels.asOutputStream(hasher);){
            ZipFiles.zipDirectory(directoryToStage, hashStream);
            String string = hasher.hash().toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getUniqueJarPath(String contentHash, String tmpJarLocation) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(tmpJarLocation), "Please provide temporary location for storing the jar files.");
        return String.format("%s%s%s.jar", tmpJarLocation, File.separator, contentHash);
    }
}

