/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction.graph;

import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.ProjectionProducer;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class ProjectionProducerVisitor
extends Pipeline.PipelineVisitor.Defaults {
    private final Map<PCollection<?>, FieldAccessDescriptor> pCollectionFieldAccess;
    private final ImmutableMap.Builder<ProjectionProducer<PTransform<?, ?>>, Map<PCollection<?>, FieldAccessDescriptor>> pushdownOpportunities = ImmutableMap.builder();

    ProjectionProducerVisitor(Map<PCollection<?>, FieldAccessDescriptor> pCollectionFieldAccess) {
        this.pCollectionFieldAccess = pCollectionFieldAccess;
    }

    Map<ProjectionProducer<PTransform<?, ?>>, Map<PCollection<?>, FieldAccessDescriptor>> getPushdownOpportunities() {
        return this.pushdownOpportunities.build();
    }

    @Override
    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        PTransform<?, ?> transform = node.getTransform();
        if (!(transform instanceof ProjectionProducer)) {
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }
        ProjectionProducer pushdownProjector = (ProjectionProducer)((Object)transform);
        if (!pushdownProjector.supportsProjectionPushdown()) {
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }
        ImmutableMap.Builder<PCollection<?>, FieldAccessDescriptor> builder = ImmutableMap.builder();
        for (PCollection<?> output : node.getOutputs().values()) {
            FieldAccessDescriptor fieldAccess = this.pCollectionFieldAccess.get(output);
            if (fieldAccess == null || fieldAccess.getAllFields()) continue;
            builder.put(output, fieldAccess);
        }
        ImmutableMap localOpportunities = builder.build();
        if (localOpportunities.isEmpty()) {
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }
        this.pushdownOpportunities.put(pushdownProjector, localOpportunities);
        return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
    }
}

