/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.HashSet;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;

public class UnconsumedReads {
    public static void ensureAllReadsConsumed(Pipeline pipeline) {
        final HashSet unconsumed = new HashSet();
        pipeline.traverseTopologically(new Pipeline.PipelineVisitor.Defaults(){

            @Override
            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                unconsumed.removeAll(node.getInputs().values());
            }

            @Override
            public void visitValue(PValue value, TransformHierarchy.Node producer) {
                String urn = PTransformTranslation.urnForTransformOrNull(producer.getTransform());
                if ("beam:transform:read:v1".equals(urn)) {
                    unconsumed.add((PCollection)value);
                }
            }
        });
        int i = 0;
        for (PCollection unconsumedPCollection : unconsumed) {
            UnconsumedReads.consume(unconsumedPCollection, i);
            ++i;
        }
    }

    private static <T> void consume(PCollection<T> unconsumedPCollection, int uniq) {
        String uniqueName = "DropInputs" + (uniq == 0 ? "" : Integer.valueOf(uniq));
        unconsumedPCollection.apply(uniqueName, ParDo.of(new NoOpDoFn()));
    }

    private static class NoOpDoFn<T>
    extends DoFn<T, T> {
        private NoOpDoFn() {
        }

        @DoFn.ProcessElement
        public void doNothing(DoFn.ProcessContext context) {
        }
    }
}

