/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.beam.runners.core.construction.AutoValue_Timer;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

@AutoValue
public abstract class Timer<K> {
    public static <K> Timer<K> of(K userKey, String dynamicTimerTag, Collection<? extends BoundedWindow> windows, Instant fireTimestamp, Instant holdTimestamp, PaneInfo pane) {
        return new AutoValue_Timer<K>(userKey, dynamicTimerTag, windows, false, fireTimestamp, holdTimestamp, pane);
    }

    public static <K> Timer<K> cleared(K userKey, String dynamicTimerTag, Collection<? extends BoundedWindow> windows) {
        return new AutoValue_Timer<K>(userKey, dynamicTimerTag, windows, true, null, null, null);
    }

    public abstract @Nullable K getUserKey();

    public abstract String getDynamicTimerTag();

    public abstract Collection<? extends BoundedWindow> getWindows();

    public abstract boolean getClearBit();

    public abstract @Nullable Instant getFireTimestamp();

    public abstract @Nullable Instant getHoldTimestamp();

    public abstract @Nullable PaneInfo getPane();

    public final boolean equals(@Nullable Object other) {
        if (!(other instanceof Timer)) {
            return false;
        }
        Timer that = (Timer)other;
        return Objects.equals(this.getUserKey(), that.getUserKey()) && Objects.equals(this.getDynamicTimerTag(), that.getDynamicTimerTag()) && Objects.equals(this.getWindows(), that.getWindows()) && this.getClearBit() == that.getClearBit() && Objects.equals(this.getFireTimestamp(), that.getFireTimestamp()) && Objects.equals(this.getHoldTimestamp(), that.getHoldTimestamp()) && Objects.equals(this.getPane(), that.getPane());
    }

    public final int hashCode() {
        if (this.getClearBit()) {
            return Objects.hash(this.getUserKey(), this.getDynamicTimerTag(), this.getClearBit(), this.getWindows());
        }
        return Objects.hash(this.getUserKey(), this.getDynamicTimerTag(), this.getClearBit(), this.getFireTimestamp().getMillis(), this.getHoldTimestamp().getMillis(), this.getWindows(), this.getPane());
    }

    public static class Coder<K>
    extends StructuredCoder<Timer<K>> {
        private final org.apache.beam.sdk.coders.Coder<K> keyCoder;
        private final org.apache.beam.sdk.coders.Coder<Collection<? extends BoundedWindow>> windowsCoder;
        private final org.apache.beam.sdk.coders.Coder<? extends BoundedWindow> windowCoder;

        public static <K> Coder<K> of(org.apache.beam.sdk.coders.Coder<K> keyCoder, org.apache.beam.sdk.coders.Coder<? extends BoundedWindow> windowCoder) {
            return new Coder<K>(keyCoder, windowCoder);
        }

        private Coder(org.apache.beam.sdk.coders.Coder<K> keyCoder, org.apache.beam.sdk.coders.Coder<? extends BoundedWindow> windowCoder) {
            this.windowCoder = windowCoder;
            this.keyCoder = keyCoder;
            this.windowsCoder = CollectionCoder.of(windowCoder);
        }

        @Override
        public void encode(Timer<K> timer, OutputStream outStream) throws IOException {
            this.keyCoder.encode(timer.getUserKey(), outStream);
            StringUtf8Coder.of().encode(timer.getDynamicTimerTag(), outStream);
            this.windowsCoder.encode(timer.getWindows(), outStream);
            BooleanCoder.of().encode(timer.getClearBit(), outStream);
            if (!timer.getClearBit()) {
                InstantCoder.of().encode(timer.getFireTimestamp(), outStream);
                InstantCoder.of().encode(timer.getHoldTimestamp(), outStream);
                PaneInfo.PaneInfoCoder.INSTANCE.encode(timer.getPane(), outStream);
            }
        }

        @Override
        public Timer<K> decode(InputStream inStream) throws IOException {
            K userKey = this.keyCoder.decode(inStream);
            String dynamicTimerTag = StringUtf8Coder.of().decode(inStream);
            Collection<? extends BoundedWindow> windows = this.windowsCoder.decode(inStream);
            boolean clearBit = BooleanCoder.of().decode(inStream);
            if (clearBit) {
                return Timer.cleared(userKey, dynamicTimerTag, windows);
            }
            Instant fireTimestamp = InstantCoder.of().decode(inStream);
            Instant holdTimestamp = InstantCoder.of().decode(inStream);
            PaneInfo pane = PaneInfo.PaneInfoCoder.INSTANCE.decode(inStream);
            return Timer.of(userKey, dynamicTimerTag, windows, fireTimestamp, holdTimestamp, pane);
        }

        @Override
        public List<? extends org.apache.beam.sdk.coders.Coder<?>> getCoderArguments() {
            return Collections.singletonList(this.keyCoder);
        }

        @Override
        public List<? extends org.apache.beam.sdk.coders.Coder<?>> getComponents() {
            return Arrays.asList(this.keyCoder, this.windowCoder);
        }

        public org.apache.beam.sdk.coders.Coder<? extends BoundedWindow> getWindowCoder() {
            return this.windowCoder;
        }

        public org.apache.beam.sdk.coders.Coder<Collection<? extends BoundedWindow>> getWindowsCoder() {
            return this.windowsCoder;
        }

        public org.apache.beam.sdk.coders.Coder<K> getValueCoder() {
            return this.keyCoder;
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            Coder.verifyDeterministic(this, "UserKey coder must be deterministic", this.keyCoder);
            Coder.verifyDeterministic(this, "Window coder must be deterministic", this.windowCoder);
        }

        @Override
        public void registerByteSizeObserver(Timer<K> value, ElementByteSizeObserver observer) throws Exception {
            this.keyCoder.registerByteSizeObserver(value.getUserKey(), observer);
            StringUtf8Coder.of().registerByteSizeObserver(value.getDynamicTimerTag(), observer);
            this.windowsCoder.registerByteSizeObserver(value.getWindows(), observer);
            BooleanCoder.of().registerByteSizeObserver(value.getClearBit(), observer);
            if (!value.getClearBit()) {
                InstantCoder.of().registerByteSizeObserver(value.getFireTimestamp(), observer);
                InstantCoder.of().registerByteSizeObserver(value.getHoldTimestamp(), observer);
                PaneInfo.PaneInfoCoder.INSTANCE.registerByteSizeObserver(value.getPane(), observer);
            }
        }
    }
}

