/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.AutoValue_ParDoTranslation_ParDoLikeTimerFamilySpecs;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.runners.core.construction.CombineTranslation;
import org.apache.beam.runners.core.construction.PCollectionViewTranslation;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.DoFnWithExecutionInformation;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

public class ParDoTranslation {
    public static final String REQUIRES_STATEFUL_PROCESSING_URN = "beam:requirement:pardo:stateful:v1";
    public static final String REQUIRES_BUNDLE_FINALIZATION_URN = "beam:requirement:pardo:finalization:v1";
    public static final String REQUIRES_STABLE_INPUT_URN = "beam:requirement:pardo:stable_input:v1";
    public static final String REQUIRES_TIME_SORTED_INPUT_URN = "beam:requirement:pardo:time_sorted_input:v1";
    public static final String REQUIRES_SPLITTABLE_DOFN_URN = "beam:requirement:pardo:splittable_dofn:v1";
    public static final String REQUIRES_ON_WINDOW_EXPIRATION_URN = "beam:requirement:pardo:on_window_expiration:v1";
    public static final String CUSTOM_JAVA_DO_FN_URN = "beam:dofn:javasdk:0.1";
    public static final String CUSTOM_JAVA_VIEW_FN_URN = "beam:viewfn:javasdk:0.1";
    public static final String CUSTOM_JAVA_WINDOW_MAPPING_FN_URN = "beam:windowmappingfn:javasdk:0.1";

    public static RunnerApi.ParDoPayload translateParDo(AppliedPTransform<?, ?, ParDo.MultiOutput<?, ?>> appliedPTransform, SdkComponents components) throws IOException {
        ParDo.MultiOutput<?, ?> parDo = appliedPTransform.getTransform();
        Pipeline pipeline = appliedPTransform.getPipeline();
        DoFn<?, ?> doFn = parDo.getFn();
        Set allInputs = appliedPTransform.getInputs().keySet().stream().map(TupleTag::getId).collect(Collectors.toSet());
        Set sideInputs = parDo.getSideInputs().values().stream().map(s2 -> s2.getTagInternal().getId()).collect(Collectors.toSet());
        String mainInputName = (String)Iterables.getOnlyElement(Sets.difference(allInputs, sideInputs));
        PCollection<?> mainInput = appliedPTransform.getInputs().get(new TupleTag(mainInputName));
        DoFnSchemaInformation doFnSchemaInformation = ParDo.getDoFnSchemaInformation(doFn, mainInput);
        return ParDoTranslation.translateParDo(parDo, mainInput, doFnSchemaInformation, pipeline, components);
    }

    public static <InputT> RunnerApi.ParDoPayload translateParDo(final ParDo.MultiOutput<InputT, ?> parDo, PCollection<InputT> mainInput, final DoFnSchemaInformation doFnSchemaInformation, Pipeline pipeline, final SdkComponents components) throws IOException {
        Coder keyCoder;
        String restrictionCoderId;
        final DoFn<InputT, ?> doFn = parDo.getFn();
        final DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        if (signature.processElement().isSplittable()) {
            DoFnInvoker<InputT, ?> doFnInvoker = DoFnInvokers.invokerFor(doFn);
            KvCoder restrictionAndWatermarkStateCoder = KvCoder.of(doFnInvoker.invokeGetRestrictionCoder(pipeline.getCoderRegistry()), doFnInvoker.invokeGetWatermarkEstimatorStateCoder(pipeline.getCoderRegistry()));
            restrictionCoderId = components.registerCoder(restrictionAndWatermarkStateCoder);
        } else {
            restrictionCoderId = "";
        }
        final Coder<?> windowCoder = mainInput.getWindowingStrategy().getWindowFn().windowCoder();
        if (signature.usesState() || signature.usesTimers()) {
            Preconditions.checkArgument(mainInput.getCoder() instanceof KvCoder, "DoFn's that use state or timers must have an input PCollection with a KvCoder but received %s", mainInput.getCoder());
            keyCoder = ((KvCoder)mainInput.getCoder()).getKeyCoder();
        } else {
            keyCoder = null;
        }
        return ParDoTranslation.payloadForParDoLike(new ParDoLike(){

            @Override
            public RunnerApi.FunctionSpec translateDoFn(SdkComponents newComponents) {
                return ParDoTranslation.translateDoFn(parDo.getFn(), parDo.getMainOutputTag(), parDo.getSideInputs(), doFnSchemaInformation, newComponents);
            }

            @Override
            public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents components2) {
                HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
                for (PCollectionView<?> sideInput : parDo.getSideInputs().values()) {
                    sideInputs.put(sideInput.getTagInternal().getId(), ParDoTranslation.translateView(sideInput, components2));
                }
                return sideInputs;
            }

            @Override
            public Map<String, RunnerApi.StateSpec> translateStateSpecs(SdkComponents components2) throws IOException {
                HashMap<String, RunnerApi.StateSpec> stateSpecs = new HashMap<String, RunnerApi.StateSpec>();
                for (Map.Entry<String, DoFnSignature.StateDeclaration> state : signature.stateDeclarations().entrySet()) {
                    RunnerApi.StateSpec spec = ParDoTranslation.translateStateSpec(DoFnSignatures.getStateSpecOrThrow(state.getValue(), doFn), components2);
                    stateSpecs.put(state.getKey(), spec);
                }
                return stateSpecs;
            }

            @Override
            public ParDoLikeTimerFamilySpecs translateTimerFamilySpecs(SdkComponents newComponents) {
                RunnerApi.TimerFamilySpec spec;
                HashMap<String, RunnerApi.TimerFamilySpec> timerFamilySpecs = new HashMap<String, RunnerApi.TimerFamilySpec>();
                for (Map.Entry<String, DoFnSignature.TimerDeclaration> entry : signature.timerDeclarations().entrySet()) {
                    spec = ParDoTranslation.translateTimerFamilySpec(DoFnSignatures.getTimerSpecOrThrow(entry.getValue(), doFn), newComponents, keyCoder, windowCoder);
                    timerFamilySpecs.put(entry.getKey(), spec);
                }
                for (Map.Entry<String, Object> entry : signature.timerFamilyDeclarations().entrySet()) {
                    spec = ParDoTranslation.translateTimerFamilySpec(DoFnSignatures.getTimerFamilySpecOrThrow((DoFnSignature.TimerFamilyDeclaration)entry.getValue(), doFn), newComponents, keyCoder, windowCoder);
                    timerFamilySpecs.put(entry.getKey(), spec);
                }
                String onWindowExpirationTimerFamilySpec = null;
                if (signature.onWindowExpiration() != null) {
                    RunnerApi.TimerFamilySpec timerFamilySpec = RunnerApi.TimerFamilySpec.newBuilder().setTimeDomain(ParDoTranslation.translateTimeDomain(TimeDomain.EVENT_TIME)).setTimerFamilyCoderId(ParDoTranslation.registerCoderOrThrow(components, Timer.Coder.of(keyCoder, windowCoder))).build();
                    for (int i = 0; i < Integer.MAX_VALUE && timerFamilySpecs.containsKey(onWindowExpirationTimerFamilySpec = "onWindowExpiration" + i); ++i) {
                    }
                    timerFamilySpecs.put(onWindowExpirationTimerFamilySpec, timerFamilySpec);
                }
                return ParDoLikeTimerFamilySpecs.create(timerFamilySpecs, onWindowExpirationTimerFamilySpec);
            }

            @Override
            public boolean isStateful() {
                return !signature.stateDeclarations().isEmpty() || !signature.timerDeclarations().isEmpty() || !signature.timerFamilyDeclarations().isEmpty() || signature.onWindowExpiration() != null;
            }

            @Override
            public boolean isSplittable() {
                return signature.processElement().isSplittable();
            }

            @Override
            public boolean isRequiresStableInput() {
                return signature.processElement().requiresStableInput();
            }

            @Override
            public boolean isRequiresTimeSortedInput() {
                return signature.processElement().requiresTimeSortedInput();
            }

            @Override
            public boolean requestsFinalization() {
                return signature.startBundle() != null && signature.startBundle().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer()) || signature.processElement() != null && signature.processElement().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer()) || signature.finishBundle() != null && signature.finishBundle().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer());
            }

            @Override
            public String translateRestrictionCoderId(SdkComponents newComponents) {
                return restrictionCoderId;
            }
        }, components);
    }

    public static DoFn<?, ?> getDoFn(RunnerApi.ParDoPayload payload) throws InvalidProtocolBufferException {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getDoFn();
    }

    public static DoFn<?, ?> getDoFn(AppliedPTransform<?, ?, ?> application) throws IOException {
        Object transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getFn();
        }
        return ParDoTranslation.getDoFn(ParDoTranslation.getParDoPayload(application));
    }

    public static DoFnSchemaInformation getSchemaInformation(AppliedPTransform<?, ?, ?> application) {
        try {
            return ParDoTranslation.getSchemaInformation(ParDoTranslation.getParDoPayload(application));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DoFnSchemaInformation getSchemaInformation(RunnerApi.PTransform pTransform) {
        try {
            return ParDoTranslation.getSchemaInformation(ParDoTranslation.getParDoPayload(pTransform));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DoFnSchemaInformation getSchemaInformation(RunnerApi.ParDoPayload payload) {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getSchemaInformation();
    }

    public static TupleTag<?> getMainOutputTag(RunnerApi.ParDoPayload payload) throws InvalidProtocolBufferException {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getMainOutputTag();
    }

    public static Map<String, PCollectionView<?>> getSideInputMapping(AppliedPTransform<?, ?, ?> application) {
        try {
            return ParDoTranslation.getSideInputMapping(ParDoTranslation.getParDoPayload(application));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, PCollectionView<?>> getSideInputMapping(RunnerApi.PTransform pTransform) {
        try {
            return ParDoTranslation.getSideInputMapping(ParDoTranslation.getParDoPayload(pTransform));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, PCollectionView<?>> getSideInputMapping(RunnerApi.ParDoPayload payload) {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getSideInputMapping();
    }

    public static TupleTag<?> getMainOutputTag(AppliedPTransform<?, ?, ?> application) throws IOException {
        Object transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getMainOutputTag();
        }
        return ParDoTranslation.getMainOutputTag(ParDoTranslation.getParDoPayload(application));
    }

    public static TupleTagList getAdditionalOutputTags(AppliedPTransform<?, ?, ?> application) throws IOException {
        Object transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getAdditionalOutputTags();
        }
        RunnerApi.PTransform protoTransform = PTransformTranslation.toProto(application, SdkComponents.create(application.getPipeline().getOptions()));
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom(protoTransform.getSpec().getPayload());
        TupleTag<?> mainOutputTag = ParDoTranslation.getMainOutputTag(payload);
        Sets.SetView<String> outputTags = Sets.difference(protoTransform.getOutputsMap().keySet(), Collections.singleton(mainOutputTag.getId()));
        ArrayList additionalOutputTags = new ArrayList();
        for (String outputTag : outputTags) {
            additionalOutputTags.add(new TupleTag(outputTag));
        }
        return TupleTagList.of(additionalOutputTags);
    }

    public static Map<TupleTag<?>, Coder<?>> getOutputCoders(AppliedPTransform<?, ?, ?> application) {
        return application.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(e -> (TupleTag)e.getKey(), e -> ((PCollection)e.getValue()).getCoder()));
    }

    public static List<PCollectionView<?>> getSideInputs(AppliedPTransform<?, ?, ?> application) throws IOException {
        Object transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getSideInputs().values().stream().collect(Collectors.toList());
        }
        SdkComponents sdkComponents = SdkComponents.create(application.getPipeline().getOptions());
        RunnerApi.PTransform parDoProto = PTransformTranslation.toProto(application, sdkComponents);
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom(parDoProto.getSpec().getPayload());
        ArrayList views = new ArrayList();
        RehydratedComponents components = RehydratedComponents.forComponents(sdkComponents.toComponents());
        for (Map.Entry<String, RunnerApi.SideInput> sideInputEntry : payload.getSideInputsMap().entrySet()) {
            String sideInputTag = sideInputEntry.getKey();
            RunnerApi.SideInput sideInput = sideInputEntry.getValue();
            PCollection<?> originalPCollection = Preconditions.checkNotNull(application.getInputs().get(new TupleTag(sideInputTag)), "no input with tag %s", (Object)sideInputTag);
            views.add(PCollectionViewTranslation.viewFromProto(sideInput, sideInputTag, originalPCollection, parDoProto, components));
        }
        return views;
    }

    public static RunnerApi.PCollection getMainInput(RunnerApi.PTransform ptransform, RunnerApi.Components components) throws IOException {
        Preconditions.checkArgument("beam:transform:pardo:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_pair_with_restriction:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_split_and_size_restrictions:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_truncate_sized_restrictions:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_elements:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_sized_element_and_restrictions:v1".equals(ptransform.getSpec().getUrn()), "Unexpected payload type %s", (Object)ptransform.getSpec().getUrn());
        return components.getPcollectionsOrThrow(ptransform.getInputsOrThrow(ParDoTranslation.getMainInputName(ptransform)));
    }

    public static String getMainInputName(RunnerApi.PTransformOrBuilder ptransform) throws IOException {
        Preconditions.checkArgument("beam:transform:pardo:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_pair_with_restriction:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_split_and_size_restrictions:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_truncate_sized_restrictions:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_elements:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_sized_element_and_restrictions:v1".equals(ptransform.getSpec().getUrn()), "Unexpected payload type %s", (Object)ptransform.getSpec().getUrn());
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom(ptransform.getSpec().getPayload());
        return ParDoTranslation.getMainInputName(ptransform, payload);
    }

    private static String getMainInputName(RunnerApi.PTransformOrBuilder ptransform, RunnerApi.ParDoPayload payload) {
        return Iterables.getOnlyElement(Sets.difference(ptransform.getInputsMap().keySet(), Sets.union(payload.getSideInputsMap().keySet(), payload.getTimerFamilySpecsMap().keySet())));
    }

    public static RunnerApi.StateSpec translateStateSpec(StateSpec<?> stateSpec, final SdkComponents components) throws IOException {
        final RunnerApi.StateSpec.Builder builder = RunnerApi.StateSpec.newBuilder();
        return stateSpec.match(new StateSpec.Cases<RunnerApi.StateSpec>(){

            @Override
            public RunnerApi.StateSpec dispatchValue(Coder<?> valueCoder) {
                return builder.setReadModifyWriteSpec(RunnerApi.ReadModifyWriteStateSpec.newBuilder().setCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).build();
            }

            @Override
            public RunnerApi.StateSpec dispatchBag(Coder<?> elementCoder) {
                return builder.setBagSpec(RunnerApi.BagStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).build();
            }

            @Override
            public RunnerApi.StateSpec dispatchOrderedList(Coder<?> elementCoder) {
                return builder.setOrderedListSpec(RunnerApi.OrderedListStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).build();
            }

            @Override
            public RunnerApi.StateSpec dispatchCombining(Combine.CombineFn<?, ?, ?> combineFn, Coder<?> accumCoder) {
                return builder.setCombiningSpec(RunnerApi.CombiningStateSpec.newBuilder().setAccumulatorCoderId(ParDoTranslation.registerCoderOrThrow(components, accumCoder)).setCombineFn(CombineTranslation.toProto(combineFn, components))).build();
            }

            @Override
            public RunnerApi.StateSpec dispatchMap(Coder<?> keyCoder, Coder<?> valueCoder) {
                return builder.setMapSpec(RunnerApi.MapStateSpec.newBuilder().setKeyCoderId(ParDoTranslation.registerCoderOrThrow(components, keyCoder)).setValueCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).build();
            }

            @Override
            public RunnerApi.StateSpec dispatchSet(Coder<?> elementCoder) {
                return builder.setSetSpec(RunnerApi.SetStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).build();
            }
        });
    }

    @VisibleForTesting
    static StateSpec<?> fromProto(RunnerApi.StateSpec stateSpec, RehydratedComponents components) throws IOException {
        switch (stateSpec.getSpecCase()) {
            case READ_MODIFY_WRITE_SPEC: {
                return StateSpecs.value(components.getCoder(stateSpec.getReadModifyWriteSpec().getCoderId()));
            }
            case BAG_SPEC: {
                return StateSpecs.bag(components.getCoder(stateSpec.getBagSpec().getElementCoderId()));
            }
            case COMBINING_SPEC: {
                RunnerApi.FunctionSpec combineFnSpec = stateSpec.getCombiningSpec().getCombineFn();
                if (!combineFnSpec.getUrn().equals("beam:combinefn:javasdk:v1")) {
                    throw new UnsupportedOperationException(String.format("Cannot create %s from non-Java %s: %s", StateSpec.class.getSimpleName(), Combine.CombineFn.class.getSimpleName(), combineFnSpec.getUrn()));
                }
                Combine.CombineFn combineFn = (Combine.CombineFn)SerializableUtils.deserializeFromByteArray(combineFnSpec.getPayload().toByteArray(), Combine.CombineFn.class.getSimpleName());
                return StateSpecs.combining(components.getCoder(stateSpec.getCombiningSpec().getAccumulatorCoderId()), combineFn);
            }
            case MAP_SPEC: {
                return StateSpecs.map(components.getCoder(stateSpec.getMapSpec().getKeyCoderId()), components.getCoder(stateSpec.getMapSpec().getValueCoderId()));
            }
            case SET_SPEC: {
                return StateSpecs.set(components.getCoder(stateSpec.getSetSpec().getElementCoderId()));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", RunnerApi.StateSpec.class.getName(), stateSpec));
    }

    public static String registerCoderOrThrow(SdkComponents components, Coder coder) {
        try {
            return components.registerCoder(coder);
        }
        catch (IOException exc) {
            throw new RuntimeException("Failure to register coder", exc);
        }
    }

    public static RunnerApi.TimerFamilySpec translateTimerFamilySpec(TimerSpec timer, SdkComponents components, Coder<?> keyCoder, Coder<BoundedWindow> windowCoder) {
        return RunnerApi.TimerFamilySpec.newBuilder().setTimeDomain(ParDoTranslation.translateTimeDomain(timer.getTimeDomain())).setTimerFamilyCoderId(ParDoTranslation.registerCoderOrThrow(components, Timer.Coder.of(keyCoder, windowCoder))).build();
    }

    public static RunnerApi.TimeDomain.Enum translateTimeDomain(TimeDomain timeDomain) {
        switch (timeDomain) {
            case EVENT_TIME: {
                return RunnerApi.TimeDomain.Enum.EVENT_TIME;
            }
            case PROCESSING_TIME: {
                return RunnerApi.TimeDomain.Enum.PROCESSING_TIME;
            }
            case SYNCHRONIZED_PROCESSING_TIME: {
                throw new IllegalArgumentException(String.format("%s is not permitted for user timers", TimeDomain.SYNCHRONIZED_PROCESSING_TIME.name()));
            }
        }
        throw new IllegalArgumentException("Unknown time domain");
    }

    public static RunnerApi.FunctionSpec translateDoFn(DoFn<?, ?> fn, TupleTag<?> tag, Map<String, PCollectionView<?>> sideInputMapping, DoFnSchemaInformation doFnSchemaInformation, SdkComponents components) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_DO_FN_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(DoFnWithExecutionInformation.of(fn, tag, sideInputMapping, doFnSchemaInformation)))).build();
    }

    public static DoFnWithExecutionInformation doFnWithExecutionInformationFromProto(RunnerApi.FunctionSpec fnSpec) {
        Preconditions.checkArgument(fnSpec.getUrn().equals(CUSTOM_JAVA_DO_FN_URN), "Expected %s to be %s with URN %s, but URN was %s", (Object)DoFn.class.getSimpleName(), (Object)RunnerApi.FunctionSpec.class.getSimpleName(), (Object)CUSTOM_JAVA_DO_FN_URN, (Object)fnSpec.getUrn());
        byte[] serializedFn = fnSpec.getPayload().toByteArray();
        return (DoFnWithExecutionInformation)SerializableUtils.deserializeFromByteArray(serializedFn, "Custom DoFn With Execution Info");
    }

    public static Map<String, RunnerApi.SideInput> translateSideInputs(List<PCollectionView<?>> views, SdkComponents components) {
        HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
        for (PCollectionView<?> sideInput : views) {
            sideInputs.put(sideInput.getTagInternal().getId(), ParDoTranslation.translateView(sideInput, components));
        }
        return sideInputs;
    }

    public static RunnerApi.SideInput translateView(PCollectionView<?> view, SdkComponents components) {
        RunnerApi.SideInput.Builder builder = RunnerApi.SideInput.newBuilder();
        builder.setAccessPattern(RunnerApi.FunctionSpec.newBuilder().setUrn(view.getViewFn().getMaterialization().getUrn()).build());
        builder.setViewFn(ParDoTranslation.translateViewFn(view.getViewFn(), components));
        builder.setWindowMappingFn(ParDoTranslation.translateWindowMappingFn(view.getWindowMappingFn(), components));
        return builder.build();
    }

    public static RunnerApi.FunctionSpec translateViewFn(ViewFn<?, ?> viewFn, SdkComponents components) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_VIEW_FN_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(viewFn))).build();
    }

    private static <T> RunnerApi.ParDoPayload getParDoPayload(AppliedPTransform<?, ?, ?> transform) throws IOException {
        SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
        RunnerApi.PTransform parDoPTransform = PTransformTranslation.toProto(transform, Collections.emptyList(), components);
        return ParDoTranslation.getParDoPayload(parDoPTransform);
    }

    private static RunnerApi.ParDoPayload getParDoPayload(RunnerApi.PTransform parDoPTransform) throws IOException {
        return RunnerApi.ParDoPayload.parseFrom(parDoPTransform.getSpec().getPayload());
    }

    public static boolean usesStateOrTimers(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return payload.getStateSpecsCount() > 0 || payload.getTimerFamilySpecsCount() > 0;
    }

    public static boolean isSplittable(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return !payload.getRestrictionCoderId().isEmpty();
    }

    public static RunnerApi.FunctionSpec translateWindowMappingFn(WindowMappingFn<?> windowMappingFn, SdkComponents components) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_WINDOW_MAPPING_FN_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(windowMappingFn))).build();
    }

    public static RunnerApi.ParDoPayload payloadForParDoLike(ParDoLike parDo, SdkComponents components) throws IOException {
        if (parDo.isStateful()) {
            components.addRequirement(REQUIRES_STATEFUL_PROCESSING_URN);
        }
        if (parDo.isSplittable()) {
            components.addRequirement(REQUIRES_SPLITTABLE_DOFN_URN);
        }
        if (parDo.requestsFinalization()) {
            components.addRequirement(REQUIRES_BUNDLE_FINALIZATION_URN);
        }
        if (parDo.isRequiresStableInput()) {
            components.addRequirement(REQUIRES_STABLE_INPUT_URN);
        }
        if (parDo.isRequiresTimeSortedInput()) {
            components.addRequirement(REQUIRES_TIME_SORTED_INPUT_URN);
        }
        ParDoLikeTimerFamilySpecs timerFamilySpecs = parDo.translateTimerFamilySpecs(components);
        RunnerApi.ParDoPayload.Builder builder = RunnerApi.ParDoPayload.newBuilder().setDoFn(parDo.translateDoFn(components)).putAllStateSpecs(parDo.translateStateSpecs(components)).putAllTimerFamilySpecs(timerFamilySpecs.timerFamilySpecs()).putAllSideInputs(parDo.translateSideInputs(components)).setRequiresStableInput(parDo.isRequiresStableInput()).setRequiresTimeSortedInput(parDo.isRequiresTimeSortedInput()).setRestrictionCoderId(parDo.translateRestrictionCoderId(components)).setRequestsFinalization(parDo.requestsFinalization());
        if (timerFamilySpecs.onWindowExpirationTimerFamilySpec() != null) {
            components.addRequirement(REQUIRES_ON_WINDOW_EXPIRATION_URN);
            builder.setOnWindowExpirationTimerFamilySpec(timerFamilySpecs.onWindowExpirationTimerFamilySpec());
        }
        return builder.build();
    }

    static {
        Preconditions.checkState(REQUIRES_STATEFUL_PROCESSING_URN.equals(BeamUrns.getUrn(RunnerApi.StandardRequirements.Enum.REQUIRES_STATEFUL_PROCESSING)));
        Preconditions.checkState(REQUIRES_BUNDLE_FINALIZATION_URN.equals(BeamUrns.getUrn(RunnerApi.StandardRequirements.Enum.REQUIRES_BUNDLE_FINALIZATION)));
        Preconditions.checkState(REQUIRES_STABLE_INPUT_URN.equals(BeamUrns.getUrn(RunnerApi.StandardRequirements.Enum.REQUIRES_STABLE_INPUT)));
        Preconditions.checkState(REQUIRES_TIME_SORTED_INPUT_URN.equals(BeamUrns.getUrn(RunnerApi.StandardRequirements.Enum.REQUIRES_TIME_SORTED_INPUT)));
        Preconditions.checkState(REQUIRES_SPLITTABLE_DOFN_URN.equals(BeamUrns.getUrn(RunnerApi.StandardRequirements.Enum.REQUIRES_SPLITTABLE_DOFN)));
        Preconditions.checkState(REQUIRES_ON_WINDOW_EXPIRATION_URN.equals(BeamUrns.getUrn(RunnerApi.StandardRequirements.Enum.REQUIRES_ON_WINDOW_EXPIRATION)));
    }

    public static interface ParDoLike {
        public RunnerApi.FunctionSpec translateDoFn(SdkComponents var1);

        public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents var1);

        public Map<String, RunnerApi.StateSpec> translateStateSpecs(SdkComponents var1) throws IOException;

        public ParDoLikeTimerFamilySpecs translateTimerFamilySpecs(SdkComponents var1);

        public boolean isStateful();

        public boolean isSplittable();

        public boolean isRequiresStableInput();

        public boolean isRequiresTimeSortedInput();

        public boolean requestsFinalization();

        public String translateRestrictionCoderId(SdkComponents var1);
    }

    @AutoValue
    public static abstract class ParDoLikeTimerFamilySpecs {
        public static ParDoLikeTimerFamilySpecs create(Map<String, RunnerApi.TimerFamilySpec> timerFamilySpecs, @Nullable String onWindowExpirationTimerFamilySpec) {
            return new AutoValue_ParDoTranslation_ParDoLikeTimerFamilySpecs(timerFamilySpecs, onWindowExpirationTimerFamilySpec);
        }

        abstract Map<String, RunnerApi.TimerFamilySpec> timerFamilySpecs();

        @Nullable
        abstract String onWindowExpirationTimerFamilySpec();
    }

    public static class ParDoTranslator
    implements PTransformTranslation.TransformTranslator<ParDo.MultiOutput<?, ?>> {
        public static PTransformTranslation.TransformTranslator create() {
            return new ParDoTranslator();
        }

        private ParDoTranslator() {
        }

        @Override
        public String getUrn(ParDo.MultiOutput<?, ?> transform) {
            return "beam:transform:pardo:v1";
        }

        @Override
        public boolean canTranslate(PTransform<?, ?> pTransform) {
            return pTransform instanceof ParDo.MultiOutput;
        }

        @Override
        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
            RunnerApi.PTransform.Builder builder = PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components);
            AppliedPTransform<?, ?, ?> appliedParDo = appliedPTransform;
            RunnerApi.ParDoPayload payload = ParDoTranslation.translateParDo(appliedParDo, components);
            builder.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:pardo:v1").setPayload(payload.toByteString()).build());
            builder.setEnvironmentId(components.getEnvironmentIdFor(appliedParDo.getResourceHints()));
            return builder.build();
        }
    }
}

