/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.NoSuchElementException;
import org.apache.beam.sdk.util.common.Reiterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PeekingReiterator<T>
implements Reiterator<T> {
    private @Nullable T nextElement;
    private boolean nextElementComputed;
    private final Reiterator<T> iterator;

    public PeekingReiterator(Reiterator<T> iterator) {
        this.iterator = Preconditions.checkNotNull(iterator);
    }

    PeekingReiterator(PeekingReiterator<T> it) {
        this.iterator = Preconditions.checkNotNull(Preconditions.checkNotNull(it).iterator.copy());
        this.nextElement = it.nextElement;
        this.nextElementComputed = it.nextElementComputed;
    }

    @Override
    public boolean hasNext() {
        this.computeNext();
        return this.nextElementComputed;
    }

    @Override
    public T next() {
        T result = this.peek();
        this.nextElementComputed = false;
        return result;
    }

    @Override
    public void remove() {
        Preconditions.checkState(!this.nextElementComputed, "After peek(), remove() is disallowed until next() is called");
        this.iterator.remove();
    }

    @Override
    public PeekingReiterator<T> copy() {
        return new PeekingReiterator<T>(this);
    }

    public T peek() {
        this.computeNext();
        if (!this.nextElementComputed) {
            throw new NoSuchElementException();
        }
        return this.nextElement;
    }

    private void computeNext() {
        if (this.nextElementComputed) {
            return;
        }
        if (!this.iterator.hasNext()) {
            return;
        }
        this.nextElement = this.iterator.next();
        this.nextElementComputed = true;
    }
}

