/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.status;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.AtomicDouble;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMonitor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryMonitor.class);
    public static final long DEFAULT_SLEEP_TIME_MILLIS = 15000L;
    private static final int NUM_MONITORED_PERIODS = 4;
    private static final double GC_THRASHING_PERCENTAGE_PER_SERVER = 60.0;
    private static final double GC_THRASHING_PERCENTAGE_PER_PERIOD = 50.0;
    private static final int HEAP_DUMP_RESERVED_BYTES = 0xA00000;
    private static final int DEFAULT_SHUT_DOWN_AFTER_NUM_GCTHRASHING = 8;
    private static final int NORMAL_LOGGING_PERIOD_MILLIS = 300000;
    private final GCStatsProvider gcStatsProvider;
    private final long sleepTimeMillis;
    private final int shutDownAfterNumGCThrashing;
    private final Queue<Boolean> periodIsThrashing = new ArrayDeque<Boolean>();
    private long timeInGC = 0L;
    @SuppressFBWarnings(value={"unused"})
    private byte[] reservedForDumpingHeap = new byte[0xA00000];
    private final boolean canDumpHeap;
    private final double gcThrashingPercentagePerPeriod;
    private final AtomicBoolean isThrashing = new AtomicBoolean(false);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicDouble lastMeasuredGCPercentage = new AtomicDouble(0.0);
    private final AtomicDouble maxGCPercentage = new AtomicDouble(0.0);
    private final AtomicInteger numPushbacks = new AtomicInteger(0);
    private final Object waitingForResources = new Object();
    private final Object waitingForStateChange = new Object();
    private final @Nullable String uploadFilePath;
    private final File localDumpFolder;

    public static MemoryMonitor fromOptions(PipelineOptions options) {
        String uploadFilePath = options.getTempLocation();
        boolean canDumpHeap = uploadFilePath != null;
        return new MemoryMonitor(new SystemGCStatsProvider(), 15000L, 8, canDumpHeap, 50.0, uploadFilePath, MemoryMonitor.getLoggingDir());
    }

    @VisibleForTesting
    static MemoryMonitor forTest(GCStatsProvider gcStatsProvider, long sleepTimeMillis, int shutDownAfterNumGCThrashing, boolean canDumpHeap, double gcThrashingPercentagePerPeriod, @Nullable String uploadFilePath, File localDumpFolder) {
        return new MemoryMonitor(gcStatsProvider, sleepTimeMillis, shutDownAfterNumGCThrashing, canDumpHeap, gcThrashingPercentagePerPeriod, uploadFilePath, localDumpFolder);
    }

    private MemoryMonitor(GCStatsProvider gcStatsProvider, long sleepTimeMillis, int shutDownAfterNumGCThrashing, boolean canDumpHeap, double gcThrashingPercentagePerPeriod, @Nullable String uploadFilePath, File localDumpFolder) {
        this.gcStatsProvider = gcStatsProvider;
        this.sleepTimeMillis = sleepTimeMillis;
        this.shutDownAfterNumGCThrashing = shutDownAfterNumGCThrashing;
        this.canDumpHeap = canDumpHeap;
        this.gcThrashingPercentagePerPeriod = gcThrashingPercentagePerPeriod;
        this.uploadFilePath = uploadFilePath;
        this.localDumpFolder = localDumpFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void waitForRunning() {
        Object object = this.waitingForStateChange;
        synchronized (object) {
            boolean interrupted = false;
            try {
                while (!this.isRunning.get()) {
                    try {
                        this.waitingForStateChange.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void waitForThrashingState(boolean desiredThrashingState) {
        Object object = this.waitingForStateChange;
        synchronized (object) {
            boolean interrupted = false;
            try {
                while (this.isThrashing.get() != desiredThrashingState) {
                    try {
                        this.waitingForStateChange.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private File getDefaultHeapDumpPath() {
        return new File(this.localDumpFolder, "heap_dump.hprof");
    }

    @VisibleForTesting
    boolean tryUploadHeapDumpIfItExists() {
        if (this.uploadFilePath == null) {
            return false;
        }
        boolean uploadedHeapDump = false;
        File localSource = this.getDefaultHeapDumpPath();
        LOG.info("Looking for heap dump at {}", (Object)localSource);
        if (localSource.exists()) {
            LOG.warn("Heap dump {} detected, attempting to upload file to ", (Object)localSource);
            String remoteDest = String.format("%s/heap_dump%s.hprof", this.uploadFilePath, UUID.randomUUID().toString());
            ResourceId resource = org.apache.beam.sdk.io.FileSystems.matchNewResource(remoteDest, false);
            try {
                this.uploadFile(localSource, resource);
                uploadedHeapDump = true;
                LOG.warn("Heap dump {} uploaded to {}", (Object)localSource, (Object)remoteDest);
            }
            catch (IOException e) {
                LOG.error("Error uploading heap dump to {}", (Object)remoteDest, (Object)e);
            }
            try {
                Files.delete(localSource.toPath());
                LOG.info("Deleted local heap dump {}", (Object)localSource);
            }
            catch (IOException e) {
                LOG.warn("Unable to delete local heap dump {}", (Object)localSource, (Object)e);
            }
        }
        return uploadedHeapDump;
    }

    private void uploadFile(File srcPath, ResourceId destination) throws IOException {
        CreateOptions.StandardCreateOptions createOptions = ((CreateOptions.StandardCreateOptions.Builder)CreateOptions.StandardCreateOptions.builder().setMimeType("application/octet-stream")).build();
        try (WritableByteChannel dst = org.apache.beam.sdk.io.FileSystems.create(destination, createOptions);
             ReadableByteChannel src = Channels.newChannel(new FileInputStream(srcPath));){
            ByteStreams.copy(src, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.waitingForStateChange;
        synchronized (object) {
            this.isRunning.set(false);
            this.waitingForStateChange.notifyAll();
        }
    }

    public boolean isThrashing() {
        return this.isThrashing.get();
    }

    private void updateIsThrashing() {
        if (this.periodIsThrashing.size() < 4) {
            this.setIsThrashing(false);
            return;
        }
        int numPeriodsInGCThrashing = 0;
        for (Boolean state : this.periodIsThrashing) {
            numPeriodsInGCThrashing += state != false ? 1 : 0;
        }
        boolean serverInGcThrashing = (double)(numPeriodsInGCThrashing * 100) >= (double)this.periodIsThrashing.size() * 60.0;
        this.setIsThrashing(serverInGcThrashing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIsThrashing(boolean serverInGcThrashing) {
        Object object = this.waitingForResources;
        synchronized (object) {
            Object object2 = this.waitingForStateChange;
            synchronized (object2) {
                boolean prev = this.isThrashing.getAndSet(serverInGcThrashing);
                if (prev && !serverInGcThrashing) {
                    this.waitingForResources.notifyAll();
                }
                if (prev != serverInGcThrashing) {
                    this.waitingForStateChange.notifyAll();
                }
            }
        }
    }

    private boolean wasLastPeriodInGCThrashing(long now, long lastTimeWokeUp) {
        long inGC = this.gcStatsProvider.totalGCTimeMilliseconds();
        double gcPercentage = (double)(inGC - this.timeInGC) * 100.0 / (double)(now - lastTimeWokeUp);
        this.lastMeasuredGCPercentage.set(gcPercentage);
        this.maxGCPercentage.set(Math.max(this.maxGCPercentage.get(), gcPercentage));
        this.timeInGC = inGC;
        return gcPercentage > this.gcThrashingPercentagePerPeriod;
    }

    private void updateData(long now, long lastTimeWokeUp) {
        int numIntervals = 4;
        while (this.periodIsThrashing.size() >= numIntervals) {
            this.periodIsThrashing.poll();
        }
        boolean wasThrashing = this.wasLastPeriodInGCThrashing(now, lastTimeWokeUp);
        this.periodIsThrashing.offer(wasThrashing);
    }

    public @Nullable File tryToDumpHeap() {
        if (!this.canDumpHeap) {
            return null;
        }
        this.reservedForDumpingHeap = null;
        try {
            return this.dumpHeap();
        }
        catch (Exception e) {
            LOG.warn("Unable to dump heap: ", e);
            return null;
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    private void shutDownDueToGcThrashing(int thrashingCount) {
        File heapDumpFile = this.tryToDumpHeap();
        LOG.error("Shutting down JVM after {} consecutive periods of measured GC thrashing. Memory is {}. Heap dump {}.", thrashingCount, this.describeMemory(), heapDumpFile == null ? "not written" : "written to '" + heapDumpFile + "'");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.waitingForStateChange;
        synchronized (object) {
            Preconditions.checkState(!this.isRunning.getAndSet(true), "already running");
            if (this.gcThrashingPercentagePerPeriod <= 0.0 || this.gcThrashingPercentagePerPeriod >= 100.0) {
                LOG.warn("gcThrashingPercentagePerPeriod: {} is not valid value. Not starting MemoryMonitor.", (Object)this.gcThrashingPercentagePerPeriod);
                this.isRunning.set(false);
            }
            this.waitingForStateChange.notifyAll();
        }
        this.tryUploadHeapDumpIfItExists();
        try {
            long lastTimeWokeUp = System.currentTimeMillis();
            long lastLog = -1L;
            int currentThrashingCount = 0;
            while (true) {
                Object object2 = this.waitingForStateChange;
                synchronized (object2) {
                    this.waitingForStateChange.wait(this.sleepTimeMillis);
                }
                if (this.isRunning.get()) {
                    long now = System.currentTimeMillis();
                    this.updateData(now, lastTimeWokeUp);
                    this.updateIsThrashing();
                    if (lastLog < 0L || lastLog + 300000L < now) {
                        LOG.info("Memory is {}", (Object)this.describeMemory());
                        lastLog = now;
                    }
                    if (this.isThrashing.get()) {
                        if (this.shutDownAfterNumGCThrashing > 0 && ++currentThrashingCount >= this.shutDownAfterNumGCThrashing) {
                            this.shutDownDueToGcThrashing(currentThrashingCount);
                        }
                    } else {
                        currentThrashingCount = 0;
                    }
                    lastTimeWokeUp = now;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("The GCThrashingMonitor was interrupted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForResources(String context) {
        if (!this.isThrashing.get()) {
            return;
        }
        this.numPushbacks.incrementAndGet();
        LOG.info("Waiting for resources for {}. Memory is {}", (Object)context, (Object)this.describeMemory());
        Object object = this.waitingForResources;
        synchronized (object) {
            boolean interrupted = false;
            try {
                while (this.isThrashing.get()) {
                    try {
                        this.waitingForResources.wait();
                    }
                    catch (InterruptedException e1) {
                        interrupted = true;
                        LOG.debug("waitForResources was interrupted.");
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        LOG.info("Resources granted for {}. Memory is {}", (Object)context, (Object)this.describeMemory());
    }

    private static File getLoggingDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public File dumpHeap() throws MalformedObjectNameException, InstanceNotFoundException, ReflectionException, MBeanException, IOException {
        return MemoryMonitor.dumpHeap(this.localDumpFolder);
    }

    @VisibleForTesting
    static synchronized File dumpHeap(File directory) throws MalformedObjectNameException, InstanceNotFoundException, ReflectionException, MBeanException, IOException {
        boolean liveObjectsOnly = false;
        File fileName = new File(directory, "heap_dump.hprof");
        if (fileName.exists() && !fileName.delete()) {
            throw new IOException("heap_dump.hprof already existed and couldn't be deleted!");
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName oname = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
        Object[] parameters = new Object[]{fileName.getPath(), liveObjectsOnly};
        String[] signatures = new String[]{String.class.getName(), Boolean.TYPE.getName()};
        mbs.invoke(oname, "dumpHeap", parameters, signatures);
        if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            Files.setPosixFilePermissions(fileName.toPath(), ImmutableSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ));
        } else {
            fileName.setReadable(true, true);
        }
        LOG.warn("Heap dumped to {}", (Object)fileName);
        return fileName;
    }

    public String describeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long usedMemory = totalMemory - runtime.freeMemory();
        return String.format("used/total/max = %d/%d/%d MB, GC last/max = %.2f/%.2f %%, #pushbacks=%d, gc thrashing=%s", usedMemory >> 20, totalMemory >> 20, maxMemory >> 20, this.lastMeasuredGCPercentage.get(), this.maxGCPercentage.get(), this.numPushbacks.get(), this.isThrashing.get());
    }

    private static class SystemGCStatsProvider
    implements GCStatsProvider {
        private SystemGCStatsProvider() {
        }

        @Override
        public long totalGCTimeMilliseconds() {
            long inGC = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                inGC += gc.getCollectionTime();
            }
            return inGC;
        }
    }

    public static interface GCStatsProvider {
        public long totalGCTimeMilliseconds();
    }
}

