/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.io.IOException;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateFetchingIterators;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class MultimapSideInput<K, V>
implements Materializations.MultimapView<K, V> {
    private final Cache<?, ?> cache;
    private final BeamFnStateClient beamFnStateClient;
    private final BeamFnApi.StateRequest keysRequest;
    private final Coder<K> keyCoder;
    private final Coder<V> valueCoder;

    public MultimapSideInput(Cache<?, ?> cache, BeamFnStateClient beamFnStateClient, String instructionId, BeamFnApi.StateKey stateKey, Coder<K> keyCoder, Coder<V> valueCoder) {
        Preconditions.checkArgument(stateKey.hasMultimapKeysSideInput(), "Expected MultimapKeysSideInput StateKey but received %s.", (Object)stateKey);
        this.cache = cache;
        this.beamFnStateClient = beamFnStateClient;
        this.keysRequest = BeamFnApi.StateRequest.newBuilder().setInstructionId(instructionId).setStateKey(stateKey).build();
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
    }

    @Override
    public Iterable<K> get() {
        return StateFetchingIterators.readAllAndDecodeStartingFrom(this.cache, this.beamFnStateClient, this.keysRequest, this.keyCoder);
    }

    @Override
    public Iterable<V> get(K k) {
        ByteString.Output output = ByteString.newOutput();
        try {
            this.keyCoder.encode(k, output);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to encode key %s for side input id %s.", k, this.keysRequest.getStateKey().getMultimapKeysSideInput().getSideInputId()), e);
        }
        ByteString encodedKey = output.toByteString();
        BeamFnApi.StateKey stateKey = BeamFnApi.StateKey.newBuilder().setMultimapSideInput(BeamFnApi.StateKey.MultimapSideInput.newBuilder().setTransformId(this.keysRequest.getStateKey().getMultimapKeysSideInput().getTransformId()).setSideInputId(this.keysRequest.getStateKey().getMultimapKeysSideInput().getSideInputId()).setWindow(this.keysRequest.getStateKey().getMultimapKeysSideInput().getWindow()).setKey(encodedKey)).build();
        BeamFnApi.StateRequest request = this.keysRequest.toBuilder().setStateKey(stateKey).build();
        return StateFetchingIterators.readAllAndDecodeStartingFrom(Caches.subCache(this.cache, "ValuesForKey", encodedKey), this.beamFnStateClient, request, this.valueCoder);
    }
}

