/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.beam.sdk.fn.stream.PrefetchableIterables;
import org.apache.beam.sdk.fn.stream.PrefetchableIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.nullness.qual.Nullable;

class LazyCachingIteratorToIterable<T>
extends PrefetchableIterables.Default<T> {
    private final List<T> cachedElements = new ArrayList<T>();
    private final PrefetchableIterator<T> iterator;

    public LazyCachingIteratorToIterable(PrefetchableIterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public PrefetchableIterator<T> createIterator() {
        return new CachingIterator();
    }

    public int hashCode() {
        return this.iterator.hasNext() ? Objects.hashCode(this.iterator.next()) : -1789023489;
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof Iterable && Iterables.elementsEqual(this, (Iterable)obj);
    }

    public String toString() {
        return Iterables.toString(this);
    }

    private class CachingIterator
    implements PrefetchableIterator<T> {
        private int position = 0;

        private CachingIterator() {
        }

        @Override
        public boolean isReady() {
            if (this.position < LazyCachingIteratorToIterable.this.cachedElements.size()) {
                return true;
            }
            return LazyCachingIteratorToIterable.this.iterator.isReady();
        }

        @Override
        public void prefetch() {
            if (!this.isReady()) {
                LazyCachingIteratorToIterable.this.iterator.prefetch();
            }
        }

        @Override
        public boolean hasNext() {
            return this.position < LazyCachingIteratorToIterable.this.cachedElements.size() || LazyCachingIteratorToIterable.this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.position < LazyCachingIteratorToIterable.this.cachedElements.size()) {
                return LazyCachingIteratorToIterable.this.cachedElements.get(this.position++);
            }
            if (!LazyCachingIteratorToIterable.this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Object rval = LazyCachingIteratorToIterable.this.iterator.next();
            LazyCachingIteratorToIterable.this.cachedElements.add(rval);
            ++this.position;
            return rval;
        }
    }
}

