/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.data;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.ExecutionStateTracker;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.ShortIdMap;
import org.apache.beam.runners.core.metrics.SimpleExecutionState;
import org.apache.beam.runners.core.metrics.SimpleStateRegistry;
import org.apache.beam.sdk.function.ThrowingRunnable;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;

public class PTransformFunctionRegistry {
    private MetricsContainerStepMap metricsContainerRegistry;
    private ExecutionStateTracker stateTracker;
    private String executionStateName;
    private List<ThrowingRunnable> runnables = new ArrayList<ThrowingRunnable>();
    private SimpleStateRegistry executionStates = new SimpleStateRegistry();

    public PTransformFunctionRegistry(MetricsContainerStepMap metricsContainerRegistry, ExecutionStateTracker stateTracker, String executionStateName) {
        this.metricsContainerRegistry = metricsContainerRegistry;
        this.executionStateName = executionStateName;
        this.stateTracker = stateTracker;
    }

    public void register(String pTransformId, ThrowingRunnable runnable) {
        HashMap<String, String> labelsMetadata = new HashMap<String, String>();
        labelsMetadata.put("PTRANSFORM", pTransformId);
        String executionTimeUrn = "";
        if (this.executionStateName.equals("start")) {
            executionTimeUrn = MonitoringInfoConstants.Urns.START_BUNDLE_MSECS;
        } else if (this.executionStateName.equals("finish")) {
            executionTimeUrn = MonitoringInfoConstants.Urns.FINISH_BUNDLE_MSECS;
        }
        SimpleExecutionState state = new SimpleExecutionState(this.executionStateName, executionTimeUrn, labelsMetadata);
        this.executionStates.register(state);
        ThrowingRunnable wrapped = () -> {
            MetricsContainerImpl container = this.metricsContainerRegistry.getContainer(pTransformId);
            Closeable metricCloseable = MetricsEnvironment.scopedMetricsContainer(container);
            Throwable throwable = null;
            try {
                Closeable trackerCloseable = this.stateTracker.enterState(state);
                Throwable throwable2 = null;
                try {
                    runnable.run();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (trackerCloseable != null) {
                        PTransformFunctionRegistry.$closeResource(throwable2, trackerCloseable);
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (metricCloseable != null) {
                    PTransformFunctionRegistry.$closeResource(throwable, metricCloseable);
                }
            }
        };
        this.runnables.add(wrapped);
    }

    public void reset() {
        this.executionStates.reset();
    }

    public List<MetricsApi.MonitoringInfo> getExecutionTimeMonitoringInfos() {
        return this.executionStates.getExecutionTimeMonitoringInfos();
    }

    public Map<String, ByteString> getExecutionTimeMonitoringData(ShortIdMap shortIds) {
        return this.executionStates.getExecutionTimeMonitoringData(shortIds);
    }

    public List<ThrowingRunnable> getFunctions() {
        return this.runnables;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

