/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.SdkHarnessOptions;
import org.apache.beam.sdk.util.Weighted;
import org.apache.beam.sdk.util.WeightedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheStats;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.RemovalListener;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.RemovalNotification;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Weigher;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Caches {
    private static final Logger LOG = LoggerFactory.getLogger(Caches.class);
    @VisibleForTesting
    static final int WEIGHT_RATIO = 6;
    private static final MemoryMeter MEMORY_METER = MemoryMeter.builder().withGuessing(MemoryMeter.Guess.BEST).build();

    public static long weigh(Object o) {
        if (o == null) {
            return 8L;
        }
        return MEMORY_METER.measureDeep(o);
    }

    public static <K, V> Cache<K, V> noop() {
        return Caches.forMaximumBytes(0L);
    }

    public static <K, V> Cache<K, V> eternal() {
        return Caches.forMaximumBytes(Long.MAX_VALUE);
    }

    public static <K, V> Cache<K, V> fromOptions(PipelineOptions options) {
        return Caches.forMaximumBytes((long)options.as(SdkHarnessOptions.class).getMaxCacheMemoryUsageMb() << 20);
    }

    public static <K, V> Cache<K, V> subCache(Cache<?, ?> cache, Object keyPrefix, Object ... additionalKeyPrefix) {
        if (cache instanceof SubCache) {
            return new SubCache(((SubCache)cache).cache, ((SubCache)cache).keyPrefix.subKey(keyPrefix, additionalKeyPrefix), ((SubCache)cache).maxWeightInBytes, ((SubCache)cache).weightInBytes);
        }
        throw new IllegalArgumentException(String.format("An unsupported type of cache was passed in. Received %s.", cache == null ? "null" : cache.getClass()));
    }

    @VisibleForTesting
    static <K, V> Cache<K, V> forMaximumBytes(long maximumBytes) {
        LongAdder weightInBytes = new LongAdder();
        return new SubCache(new ShrinkOnEviction(CacheBuilder.newBuilder().maximumWeight(maximumBytes >> 6).weigher(new Weigher<CompositeKey, WeightedValue<Object>>(){

            @Override
            public int weigh(CompositeKey key, WeightedValue<Object> value) {
                long size = (key.getWeight() + value.getWeight() - 1L >> 6) + 1L;
                if (size > Integer.MAX_VALUE) {
                    LOG.warn("Entry with size {} MiBs inserted into the cache. This is larger than the maximum individual entry size of {} MiBs. The cache will under report its memory usage by the difference. This may lead to OutOfMemoryErrors.", (Object)((size - 1L >> 20) + 1L), (Object)131072);
                    return Integer.MAX_VALUE;
                }
                return (int)size;
            }
        }).concurrencyLevel(1).recordStats(), weightInBytes).getCache(), CompositeKeyPrefix.ROOT, maximumBytes, weightInBytes);
    }

    private static long findWeight(Object o) {
        if (o instanceof WeightedValue) {
            return ((WeightedValue)o).getWeight();
        }
        if (o instanceof Weighted) {
            return ((Weighted)o).getWeight();
        }
        return Caches.weigh(o);
    }

    private static WeightedValue<Object> addWeightedValue(CompositeKey key, Object o, LongAdder weightInBytes) {
        WeightedValue<Object> rval = o instanceof WeightedValue ? (WeightedValue<Object>)o : (o instanceof Weighted ? WeightedValue.of(o, ((Weighted)o).getWeight()) : WeightedValue.of(o, Caches.weigh(o)));
        weightInBytes.add(key.getWeight() + rval.getWeight());
        return rval;
    }

    public static class ClearableCache<K, V>
    extends SubCache<K, V> {
        private final Set<K> weakHashSet = Collections.newSetFromMap(new WeakHashMap());

        public ClearableCache(Cache<K, V> cache) {
            super(((SubCache)cache).cache, ((SubCache)cache).keyPrefix, ((SubCache)cache).maxWeightInBytes, ((SubCache)cache).weightInBytes);
        }

        @Override
        public V computeIfAbsent(K key, Function<K, V> loadingFunction) {
            this.weakHashSet.add(key);
            return super.computeIfAbsent(key, loadingFunction);
        }

        @Override
        public void put(K key, V value) {
            this.weakHashSet.add(key);
            super.put(key, value);
        }

        @Override
        public void remove(K key) {
            this.weakHashSet.remove(key);
            super.remove(key);
        }

        public void clear() {
            for (K key : this.weakHashSet) {
                super.remove(key);
            }
            this.weakHashSet.clear();
        }
    }

    @VisibleForTesting
    static class CompositeKey
    implements Weighted {
        private final Object[] namespace;
        private final Object key;
        private final long weight;

        private CompositeKey(Object[] namespace, long namespaceWeight, Object key) {
            this.namespace = namespace;
            this.key = key;
            this.weight = namespaceWeight + Caches.findWeight(key);
        }

        public String toString() {
            return "CompositeKey{namespace=" + Arrays.toString(this.namespace) + ", key=" + this.key + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompositeKey)) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            return Arrays.equals(this.namespace, that.namespace) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Arrays.hashCode(this.namespace);
        }

        @Override
        public long getWeight() {
            return this.weight;
        }
    }

    static class CompositeKeyPrefix {
        public static final CompositeKeyPrefix ROOT = new CompositeKeyPrefix(new Object[0], 0L);
        private final Object[] namespace;
        private final long weight;

        private CompositeKeyPrefix(Object[] namespace, long weight) {
            this.namespace = namespace;
            this.weight = weight;
        }

        CompositeKeyPrefix subKey(Object suffix, Object ... additionalSuffixes) {
            Object[] subKey = new Object[this.namespace.length + 1 + additionalSuffixes.length];
            System.arraycopy(this.namespace, 0, subKey, 0, this.namespace.length);
            subKey[this.namespace.length] = suffix;
            System.arraycopy(additionalSuffixes, 0, subKey, this.namespace.length + 1, additionalSuffixes.length);
            long subKeyWeight = this.weight + Caches.findWeight(suffix);
            for (int i = 0; i < additionalSuffixes.length; ++i) {
                subKeyWeight += Caches.findWeight(additionalSuffixes[i]);
            }
            return new CompositeKeyPrefix(subKey, subKeyWeight);
        }

        <K> CompositeKey valueKey(K k) {
            return new CompositeKey(this.namespace, this.weight, k);
        }

        boolean isProperPrefixOf(CompositeKey otherKey) {
            if (this.namespace.length > otherKey.namespace.length) {
                return false;
            }
            for (int i = this.namespace.length - 1; i >= 0; --i) {
                if (Objects.equals(this.namespace[i], otherKey.namespace[i])) continue;
                return false;
            }
            return true;
        }

        boolean isEquivalentNamespace(CompositeKey otherKey) {
            if (this.namespace.length != otherKey.namespace.length) {
                return false;
            }
            for (int i = this.namespace.length - 1; i >= 0; --i) {
                if (Objects.equals(this.namespace[i], otherKey.namespace[i])) continue;
                return false;
            }
            return true;
        }
    }

    private static class SubCache<K, V>
    implements Cache<K, V> {
        private final org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache<CompositeKey, WeightedValue<Object>> cache;
        private final CompositeKeyPrefix keyPrefix;
        private final long maxWeightInBytes;
        private final LongAdder weightInBytes;

        SubCache(org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache<CompositeKey, WeightedValue<Object>> cache, CompositeKeyPrefix keyPrefix, long maxWeightInBytes, LongAdder weightInBytes) {
            this.cache = cache;
            this.keyPrefix = keyPrefix;
            this.maxWeightInBytes = maxWeightInBytes;
            this.weightInBytes = weightInBytes;
        }

        @Override
        public V peek(K key) {
            WeightedValue<Object> value = this.cache.getIfPresent(this.keyPrefix.valueKey(key));
            if (value == null) {
                return null;
            }
            return (V)value.getValue();
        }

        @Override
        public V computeIfAbsent(K key, Function<K, V> loadingFunction) {
            try {
                CompositeKey compositeKey = this.keyPrefix.valueKey(key);
                return (V)this.cache.get(compositeKey, () -> Caches.addWeightedValue(compositeKey, loadingFunction.apply(key), this.weightInBytes)).getValue();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void put(K key, V value) {
            CompositeKey compositeKey = this.keyPrefix.valueKey(key);
            this.cache.put(compositeKey, Caches.addWeightedValue(compositeKey, value, this.weightInBytes));
        }

        @Override
        public void remove(K key) {
            this.cache.invalidate(this.keyPrefix.valueKey(key));
        }

        @Override
        public String describeStats() {
            CacheStats stats = this.cache.stats();
            return String.format("used/max %d/%d MB, hit %.2f%%, lookups %d, avg load time %.0f ns, loads %d, evictions %d", this.weightInBytes.longValue() >> 20, this.maxWeightInBytes >> 20, stats.hitRate() * 100.0, stats.requestCount(), stats.averageLoadPenalty(), stats.loadCount(), stats.evictionCount());
        }
    }

    @VisibleForTesting
    static class ShrinkOnEviction
    implements RemovalListener<CompositeKey, WeightedValue<Object>> {
        private final org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache<CompositeKey, WeightedValue<Object>> cache;
        private final LongAdder weightInBytes;

        ShrinkOnEviction(CacheBuilder<CompositeKey, WeightedValue<Object>> cacheBuilder, LongAdder weightInBytes) {
            this.cache = cacheBuilder.removalListener(this).build();
            this.weightInBytes = weightInBytes;
        }

        public org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache<CompositeKey, WeightedValue<Object>> getCache() {
            return this.cache;
        }

        @Override
        public void onRemoval(RemovalNotification<CompositeKey, WeightedValue<Object>> removalNotification) {
            this.weightInBytes.add(-(((CompositeKey)removalNotification.getKey()).getWeight() + ((WeightedValue)removalNotification.getValue()).getWeight()));
            if (removalNotification.wasEvicted()) {
                if (!(((WeightedValue)removalNotification.getValue()).getValue() instanceof Cache.Shrinkable)) {
                    return;
                }
                Object updatedEntry = ((Cache.Shrinkable)((WeightedValue)removalNotification.getValue()).getValue()).shrink();
                if (updatedEntry != null) {
                    this.cache.put((CompositeKey)removalNotification.getKey(), Caches.addWeightedValue((CompositeKey)removalNotification.getKey(), updatedEntry, this.weightInBytes));
                }
            }
        }
    }
}

