/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.ArrayTypeSignature;
import io.github.classgraph.ClassGraphException;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.Classfile;
import io.github.classgraph.HasName;
import io.github.classgraph.MethodParameterInfo;
import io.github.classgraph.MethodTypeSignature;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanResultObject;
import io.github.classgraph.TypeParameter;
import io.github.classgraph.TypeSignature;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nonapi.io.github.classgraph.types.ParseException;
import nonapi.io.github.classgraph.types.TypeUtils;
import nonapi.io.github.classgraph.utils.LogNode;

public class MethodInfo
extends ScanResultObject
implements Comparable<MethodInfo>,
HasName {
    private String declaringClassName;
    private String name;
    private int modifiers;
    AnnotationInfoList annotationInfo;
    private String typeDescriptorStr;
    private transient MethodTypeSignature typeDescriptor;
    private String typeSignatureStr;
    private transient MethodTypeSignature typeSignature;
    private String[] parameterNames;
    private int[] parameterModifiers;
    AnnotationInfo[][] parameterAnnotationInfo;
    private transient MethodParameterInfo[] parameterInfo;
    private boolean hasBody;
    private List<Classfile.MethodTypeAnnotationDecorator> typeAnnotationDecorators;

    MethodInfo() {
    }

    MethodInfo(String definingClassName, String methodName, AnnotationInfoList methodAnnotationInfo, int modifiers, String typeDescriptorStr, String typeSignatureStr, String[] parameterNames, int[] parameterModifiers, AnnotationInfo[][] parameterAnnotationInfo, boolean hasBody, List<Classfile.MethodTypeAnnotationDecorator> methodTypeAnnotationDecorators) {
        this.declaringClassName = definingClassName;
        this.name = methodName;
        this.modifiers = modifiers;
        this.typeDescriptorStr = typeDescriptorStr;
        this.typeSignatureStr = typeSignatureStr;
        this.parameterNames = parameterNames;
        this.parameterModifiers = parameterModifiers;
        this.parameterAnnotationInfo = parameterAnnotationInfo;
        this.annotationInfo = methodAnnotationInfo == null || methodAnnotationInfo.isEmpty() ? null : methodAnnotationInfo;
        this.hasBody = hasBody;
        this.typeAnnotationDecorators = methodTypeAnnotationDecorators;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getModifiersStr() {
        StringBuilder buf = new StringBuilder();
        TypeUtils.modifiersToString(this.modifiers, TypeUtils.ModifierType.METHOD, this.isDefault(), buf);
        return buf.toString();
    }

    @Override
    public ClassInfo getClassInfo() {
        return super.getClassInfo();
    }

    public MethodTypeSignature getTypeDescriptor() {
        if (this.typeDescriptor == null) {
            try {
                this.typeDescriptor = MethodTypeSignature.parse(this.typeDescriptorStr, this.declaringClassName);
                this.typeDescriptor.setScanResult(this.scanResult);
                if (this.typeAnnotationDecorators != null) {
                    for (Classfile.MethodTypeAnnotationDecorator decorator : this.typeAnnotationDecorators) {
                        decorator.decorate(this.typeDescriptor);
                    }
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.typeDescriptor;
    }

    public String getTypeDescriptorStr() {
        return this.typeDescriptorStr;
    }

    public MethodTypeSignature getTypeSignature() {
        if (this.typeSignature == null && this.typeSignatureStr != null) {
            try {
                this.typeSignature = MethodTypeSignature.parse(this.typeSignatureStr, this.declaringClassName);
                this.typeSignature.setScanResult(this.scanResult);
                if (this.typeAnnotationDecorators != null) {
                    for (Classfile.MethodTypeAnnotationDecorator decorator : this.typeAnnotationDecorators) {
                        decorator.decorate(this.typeSignature);
                    }
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid type signature for method " + this.getClassName() + "." + this.getName() + (this.getClassInfo() != null ? " in classpath element " + this.getClassInfo().getClasspathElementURI() : "") + " : " + this.typeSignatureStr, e);
            }
        }
        return this.typeSignature;
    }

    public String getTypeSignatureStr() {
        return this.typeSignatureStr;
    }

    public MethodTypeSignature getTypeSignatureOrTypeDescriptor() {
        MethodTypeSignature typeSig = null;
        try {
            typeSig = this.getTypeSignature();
            if (typeSig != null) {
                return typeSig;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getTypeDescriptor();
    }

    public String getTypeSignatureOrTypeDescriptorStr() {
        if (this.typeSignatureStr != null) {
            return this.typeSignatureStr;
        }
        return this.typeDescriptorStr;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public boolean isVarArgs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public boolean hasBody() {
        return this.hasBody;
    }

    public boolean isDefault() {
        ClassInfo classInfo = this.getClassInfo();
        return classInfo != null && classInfo.isInterface() && this.hasBody;
    }

    public MethodParameterInfo[] getParameterInfo() {
        if (this.parameterInfo == null) {
            int i;
            List<TypeSignature> paramTypeDescriptors = null;
            int numParams = 0;
            try {
                MethodTypeSignature typeSig = this.getTypeDescriptor();
                if (typeSig != null) {
                    paramTypeDescriptors = typeSig.getParameterTypeSignatures();
                    numParams = paramTypeDescriptors.size();
                }
            }
            catch (Exception typeSig) {
                // empty catch block
            }
            List<TypeSignature> paramTypeSignatures = null;
            try {
                MethodTypeSignature typeSig = this.getTypeSignature();
                if (typeSig != null) {
                    paramTypeSignatures = typeSig.getParameterTypeSignatures();
                }
            }
            catch (Exception typeSig) {
                // empty catch block
            }
            if (paramTypeSignatures != null && paramTypeSignatures.size() > numParams) {
                throw new ClassGraphException("typeSignatureParamTypes.size() > typeDescriptorParamTypes.size() for method " + this.declaringClassName + "." + this.name);
            }
            int otherParamMax = Math.max(this.parameterNames == null ? 0 : this.parameterNames.length, Math.max(this.parameterModifiers == null ? 0 : this.parameterModifiers.length, this.parameterAnnotationInfo == null ? 0 : this.parameterAnnotationInfo.length));
            if (otherParamMax > numParams) {
                throw new ClassGraphException("Type descriptor for method " + this.declaringClassName + "." + this.name + " has insufficient parameters");
            }
            String[] paramNamesAligned = null;
            if (this.parameterNames != null && numParams > 0) {
                if (this.parameterNames.length == numParams) {
                    paramNamesAligned = this.parameterNames;
                } else {
                    paramNamesAligned = new String[numParams];
                    int lenDiff = numParams - this.parameterNames.length;
                    for (int i2 = 0; i2 < this.parameterNames.length; ++i2) {
                        paramNamesAligned[lenDiff + i2] = this.parameterNames[i2];
                    }
                }
            }
            int[] paramModifiersAligned = null;
            if (this.parameterModifiers != null && numParams > 0) {
                if (this.parameterModifiers.length == numParams) {
                    paramModifiersAligned = this.parameterModifiers;
                } else {
                    paramModifiersAligned = new int[numParams];
                    int lenDiff = numParams - this.parameterModifiers.length;
                    for (int i3 = 0; i3 < this.parameterModifiers.length; ++i3) {
                        paramModifiersAligned[lenDiff + i3] = this.parameterModifiers[i3];
                    }
                }
            }
            AnnotationInfo[][] paramAnnotationInfoAligned = null;
            if (this.parameterAnnotationInfo != null && numParams > 0) {
                if (this.parameterAnnotationInfo.length == numParams) {
                    paramAnnotationInfoAligned = this.parameterAnnotationInfo;
                } else {
                    paramAnnotationInfoAligned = new AnnotationInfo[numParams][];
                    int lenDiff = numParams - this.parameterAnnotationInfo.length;
                    for (int i4 = 0; i4 < this.parameterAnnotationInfo.length; ++i4) {
                        paramAnnotationInfoAligned[lenDiff + i4] = this.parameterAnnotationInfo[i4];
                    }
                }
            }
            List<TypeSignature> paramTypeSignaturesAligned = null;
            if (paramTypeSignatures != null && numParams > 0) {
                if (paramTypeSignatures.size() == numParams) {
                    paramTypeSignaturesAligned = paramTypeSignatures;
                } else {
                    paramTypeSignaturesAligned = new ArrayList<TypeSignature>(numParams);
                    int n = numParams - paramTypeSignatures.size();
                    for (i = 0; i < n; ++i) {
                        paramTypeSignaturesAligned.add(null);
                    }
                    paramTypeSignaturesAligned.addAll(paramTypeSignatures);
                }
            }
            this.parameterInfo = new MethodParameterInfo[numParams];
            for (i = 0; i < numParams; ++i) {
                this.parameterInfo[i] = new MethodParameterInfo(this, paramAnnotationInfoAligned == null ? null : paramAnnotationInfoAligned[i], paramModifiersAligned == null ? 0 : paramModifiersAligned[i], paramTypeDescriptors == null ? null : paramTypeDescriptors.get(i), paramTypeSignaturesAligned == null ? null : paramTypeSignaturesAligned.get(i), paramNamesAligned == null ? null : paramNamesAligned[i]);
                this.parameterInfo[i].setScanResult(this.scanResult);
            }
        }
        return this.parameterInfo;
    }

    public AnnotationInfoList getAnnotationInfo() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        return this.annotationInfo == null ? AnnotationInfoList.EMPTY_LIST : AnnotationInfoList.getIndirectAnnotations(this.annotationInfo, null);
    }

    public AnnotationInfo getAnnotationInfo(String annotationName) {
        return (AnnotationInfo)this.getAnnotationInfo().get(annotationName);
    }

    public AnnotationInfoList getAnnotationInfoRepeatable(String annotationName) {
        return this.getAnnotationInfo().getRepeatable(annotationName);
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotationInfo().containsName(annotationName);
    }

    public boolean hasParameterAnnotation(String annotationName) {
        for (MethodParameterInfo methodParameterInfo : this.getParameterInfo()) {
            if (!methodParameterInfo.hasAnnotation(annotationName)) continue;
            return true;
        }
        return false;
    }

    private Class<?>[] loadParameterClasses() {
        MethodParameterInfo[] allParameterInfo = this.getParameterInfo();
        ArrayList parameterClasses = new ArrayList(allParameterInfo.length);
        for (MethodParameterInfo mpi : allParameterInfo) {
            TypeSignature parameterType = mpi.getTypeSignatureOrTypeDescriptor();
            parameterClasses.add(parameterType.loadClass());
        }
        return parameterClasses.toArray(new Class[0]);
    }

    public Method loadClassAndGetMethod() throws IllegalArgumentException {
        if (this.isConstructor()) {
            throw new IllegalArgumentException("Need to call loadClassAndGetConstructor() for constructors, not loadClassAndGetMethod()");
        }
        Class<?>[] parameterClassesArr = this.loadParameterClasses();
        try {
            return this.loadClass().getMethod(this.getName(), parameterClassesArr);
        }
        catch (NoSuchMethodException e1) {
            try {
                return this.loadClass().getDeclaredMethod(this.getName(), parameterClassesArr);
            }
            catch (NoSuchMethodException es2) {
                throw new IllegalArgumentException("Method not found: " + this.getClassName() + "." + this.getName());
            }
        }
    }

    public Constructor<?> loadClassAndGetConstructor() throws IllegalArgumentException {
        if (!this.isConstructor()) {
            throw new IllegalArgumentException("Need to call loadClassAndGetMethod() for non-constructor methods, not loadClassAndGetConstructor()");
        }
        Class<?>[] parameterClassesArr = this.loadParameterClasses();
        try {
            return this.loadClass().getConstructor(parameterClassesArr);
        }
        catch (NoSuchMethodException e1) {
            try {
                return this.loadClass().getDeclaredConstructor(parameterClassesArr);
            }
            catch (NoSuchMethodException es2) {
                throw new IllegalArgumentException("Constructor not found for class " + this.getClassName());
            }
        }
    }

    void handleRepeatableAnnotations(Set<String> allRepeatableAnnotationNames) {
        if (this.annotationInfo != null) {
            this.annotationInfo.handleRepeatableAnnotations(allRepeatableAnnotationNames, this.getClassInfo(), ClassInfo.RelType.METHOD_ANNOTATIONS, ClassInfo.RelType.CLASSES_WITH_METHOD_ANNOTATION, ClassInfo.RelType.CLASSES_WITH_NONPRIVATE_METHOD_ANNOTATION);
        }
        if (this.parameterAnnotationInfo != null) {
            for (int i = 0; i < this.parameterAnnotationInfo.length; ++i) {
                AnnotationInfo[] pai = this.parameterAnnotationInfo[i];
                if (pai == null || pai.length <= 0) continue;
                boolean hasRepeatableAnnotation = false;
                for (AnnotationInfo ai : pai) {
                    if (!allRepeatableAnnotationNames.contains(ai.getName())) continue;
                    hasRepeatableAnnotation = true;
                    break;
                }
                if (!hasRepeatableAnnotation) continue;
                AnnotationInfoList aiList = new AnnotationInfoList(pai.length);
                for (AnnotationInfo ai : pai) {
                    aiList.add(ai);
                }
                aiList.handleRepeatableAnnotations(allRepeatableAnnotationNames, this.getClassInfo(), ClassInfo.RelType.METHOD_PARAMETER_ANNOTATIONS, ClassInfo.RelType.CLASSES_WITH_METHOD_PARAMETER_ANNOTATION, ClassInfo.RelType.CLASSES_WITH_NONPRIVATE_METHOD_PARAMETER_ANNOTATION);
                this.parameterAnnotationInfo[i] = aiList.toArray(new AnnotationInfo[0]);
            }
        }
    }

    @Override
    public String getClassName() {
        return this.declaringClassName;
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.typeDescriptor != null) {
            this.typeDescriptor.setScanResult(scanResult);
        }
        if (this.typeSignature != null) {
            this.typeSignature.setScanResult(scanResult);
        }
        if (this.annotationInfo != null) {
            for (AnnotationInfo ai : this.annotationInfo) {
                ai.setScanResult(scanResult);
            }
        }
        if (this.parameterAnnotationInfo != null) {
            for (AnnotationInfo[] annotationInfoArray : this.parameterAnnotationInfo) {
                if (annotationInfoArray == null) continue;
                for (AnnotationInfo ai : annotationInfoArray) {
                    ai.setScanResult(scanResult);
                }
            }
        }
        if (this.parameterInfo != null) {
            for (AnnotationInfo[] annotationInfoArray : this.parameterInfo) {
                annotationInfoArray.setScanResult(scanResult);
            }
        }
    }

    @Override
    protected void findReferencedClassInfo(Map<String, ClassInfo> classNameToClassInfo, Set<ClassInfo> refdClassInfo, LogNode log) {
        block11: {
            block10: {
                try {
                    MethodTypeSignature methodSig = this.getTypeSignature();
                    if (methodSig != null) {
                        methodSig.findReferencedClassInfo(classNameToClassInfo, refdClassInfo, log);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (log == null) break block10;
                    log.log("Illegal type signature for method " + this.getClassName() + "." + this.getName() + ": " + this.getTypeSignatureStr());
                }
            }
            try {
                MethodTypeSignature methodDesc = this.getTypeDescriptor();
                if (methodDesc != null) {
                    methodDesc.findReferencedClassInfo(classNameToClassInfo, refdClassInfo, log);
                }
            }
            catch (IllegalArgumentException e) {
                if (log == null) break block11;
                log.log("Illegal type descriptor for method " + this.getClassName() + "." + this.getName() + ": " + this.getTypeDescriptorStr());
            }
        }
        if (this.annotationInfo != null) {
            for (AnnotationInfo ai : this.annotationInfo) {
                ai.findReferencedClassInfo(classNameToClassInfo, refdClassInfo, log);
            }
        }
        for (MethodParameterInfo mpi : this.getParameterInfo()) {
            AnnotationInfo[] aiArr = mpi.annotationInfo;
            if (aiArr == null) continue;
            for (AnnotationInfo ai : aiArr) {
                ai.findReferencedClassInfo(classNameToClassInfo, refdClassInfo, log);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodInfo)) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        return this.declaringClassName.equals(other.declaringClassName) && this.typeDescriptorStr.equals(other.typeDescriptorStr) && this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode() + this.typeDescriptorStr.hashCode() * 11 + this.declaringClassName.hashCode() * 57;
    }

    @Override
    public int compareTo(MethodInfo other) {
        int diff0 = this.declaringClassName.compareTo(other.declaringClassName);
        if (diff0 != 0) {
            return diff0;
        }
        int diff1 = this.name.compareTo(other.name);
        if (diff1 != 0) {
            return diff1;
        }
        return this.typeDescriptorStr.compareTo(other.typeDescriptorStr);
    }

    @Override
    protected void toString(boolean useSimpleNames, StringBuilder buf) {
        int i;
        List<TypeParameter> typeParameters;
        MethodTypeSignature methodType = this.getTypeSignatureOrTypeDescriptor();
        if (this.annotationInfo != null) {
            for (AnnotationInfo annotation : this.annotationInfo) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                annotation.toString(useSimpleNames, buf);
            }
        }
        if (this.modifiers != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            TypeUtils.modifiersToString(this.modifiers, TypeUtils.ModifierType.METHOD, this.isDefault(), buf);
        }
        if (!(typeParameters = methodType.getTypeParameters()).isEmpty()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append('<');
            for (int i2 = 0; i2 < typeParameters.size(); ++i2) {
                if (i2 > 0) {
                    buf.append(", ");
                }
                typeParameters.get(i2).toString(useSimpleNames, buf);
            }
            buf.append('>');
        }
        if (!this.isConstructor()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            methodType.getResultType().toStringInternal(useSimpleNames, this.annotationInfo, buf);
        }
        buf.append(' ');
        if (this.name != null) {
            buf.append(useSimpleNames ? ClassInfo.getSimpleName(this.name) : this.name);
        }
        MethodParameterInfo[] allParamInfo = this.getParameterInfo();
        boolean hasParamNames = false;
        for (MethodParameterInfo methodParamInfo : allParamInfo) {
            if (methodParamInfo.getName() == null) continue;
            hasParamNames = true;
            break;
        }
        int varArgsParamIndex = -1;
        if (this.isVarArgs()) {
            for (i = allParamInfo.length - 1; i >= 0; --i) {
                TypeSignature paramType;
                int mods = allParamInfo[i].getModifiers();
                if ((mods & 0x1000) != 0 || (mods & 0x8000) != 0 || !((paramType = allParamInfo[i].getTypeSignatureOrTypeDescriptor()) instanceof ArrayTypeSignature)) continue;
                varArgsParamIndex = i;
                break;
            }
        }
        buf.append('(');
        int numParams = allParamInfo.length;
        for (i = 0; i < numParams; ++i) {
            String paramName;
            int j;
            MethodParameterInfo paramInfo = allParamInfo[i];
            if (i > 0) {
                buf.append(", ");
            }
            if (paramInfo.annotationInfo != null) {
                for (AnnotationInfo ai : paramInfo.annotationInfo) {
                    ai.toString(useSimpleNames, buf);
                    buf.append(' ');
                }
            }
            MethodParameterInfo.modifiersToString(paramInfo.getModifiers(), buf);
            TypeSignature paramTypeSignature = paramInfo.getTypeSignatureOrTypeDescriptor();
            if (i == varArgsParamIndex) {
                if (!(paramTypeSignature instanceof ArrayTypeSignature)) {
                    throw new IllegalArgumentException("Got non-array type for last parameter of varargs method " + this.name);
                }
                ArrayTypeSignature arrayType = (ArrayTypeSignature)paramTypeSignature;
                if (arrayType.getNumDimensions() == 0) {
                    throw new IllegalArgumentException("Got a zero-dimension array type for last parameter of varargs method " + this.name);
                }
                arrayType.getElementTypeSignature().toString(useSimpleNames, buf);
                for (j = 0; j < arrayType.getNumDimensions() - 1; ++j) {
                    buf.append("[]");
                }
                buf.append("...");
            } else {
                AnnotationInfoList annotationsToExclude;
                if (paramInfo.annotationInfo == null || paramInfo.annotationInfo.length == 0) {
                    annotationsToExclude = null;
                } else {
                    annotationsToExclude = new AnnotationInfoList(paramInfo.annotationInfo.length);
                    for (j = 0; j < paramInfo.annotationInfo.length; ++j) {
                        annotationsToExclude.add(paramInfo.annotationInfo[j]);
                    }
                }
                paramTypeSignature.toStringInternal(useSimpleNames, annotationsToExclude, buf);
            }
            if (!hasParamNames || (paramName = paramInfo.getName()) == null) continue;
            buf.append(' ');
            buf.append(paramName);
        }
        buf.append(')');
        if (!methodType.getThrowsSignatures().isEmpty()) {
            buf.append(" throws ");
            for (i = 0; i < methodType.getThrowsSignatures().size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                methodType.getThrowsSignatures().get(i).toString(useSimpleNames, buf);
            }
        }
    }
}

