/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.CallStreamObserver;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@ThreadSafe
public final class BufferingStreamObserver<@UnknownKeyFor T>
implements StreamObserver<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Object POISON_PILL = new Object();
    private final @UnknownKeyFor @NonNull @Initialized LinkedBlockingDeque<T> queue;
    private final @UnknownKeyFor @NonNull @Initialized Phaser phaser;
    private final @UnknownKeyFor @NonNull @Initialized CallStreamObserver<T> outboundObserver;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> queueDrainer;
    private final @UnknownKeyFor @NonNull @Initialized int bufferSize;

    public BufferingStreamObserver(@UnknownKeyFor @NonNull @Initialized Phaser phaser, @UnknownKeyFor @NonNull @Initialized CallStreamObserver<T> outboundObserver, @UnknownKeyFor @NonNull @Initialized ExecutorService executor, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
        this.phaser = phaser;
        this.bufferSize = bufferSize;
        this.queue = new LinkedBlockingDeque(bufferSize);
        this.outboundObserver = outboundObserver;
        this.queueDrainer = executor.submit(this::drainQueue);
    }

    private void drainQueue() {
        try {
            while (true) {
                int currentPhase = this.phaser.getPhase();
                while (this.outboundObserver.isReady()) {
                    T value = this.queue.take();
                    if (value != POISON_PILL) {
                        this.outboundObserver.onNext(value);
                        continue;
                    }
                    return;
                }
                this.phaser.awaitAdvance(currentPhase);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    public void onNext(T value) {
        try {
            while (!this.queue.offer(value, 60L, TimeUnit.SECONDS)) {
                Preconditions.checkState((!this.queueDrainer.isDone() ? 1 : 0) != 0, (Object)"Stream observer has finished.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(@UnknownKeyFor @NonNull @Initialized Throwable t) {
        CallStreamObserver<T> callStreamObserver = this.outboundObserver;
        synchronized (callStreamObserver) {
            if (!this.queueDrainer.isDone()) {
                try {
                    while (!this.queueDrainer.isDone() && !this.queue.offerFirst(POISON_PILL, 60L, TimeUnit.SECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                this.waitTillFinish();
            }
            this.outboundObserver.onError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted() {
        CallStreamObserver<T> callStreamObserver = this.outboundObserver;
        synchronized (callStreamObserver) {
            if (!this.queueDrainer.isDone()) {
                try {
                    while (!this.queueDrainer.isDone() && !this.queue.offerLast(POISON_PILL, 60L, TimeUnit.SECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                this.waitTillFinish();
            }
            this.outboundObserver.onCompleted();
        }
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized int getBufferSize() {
        return this.bufferSize;
    }

    private void waitTillFinish() {
        try {
            this.queueDrainer.get();
        }
        catch (CancellationException e) {
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

