/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import java.util.function.BiConsumer;
import org.apache.beam.sdk.fn.data.CompletableFutureInboundDataClient;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.fn.data.InboundDataClient;
import org.apache.beam.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamFnDataInboundObserver
implements BiConsumer<ByteString, Boolean>,
InboundDataClient {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BeamFnDataInboundObserver.class);
    private final @UnknownKeyFor @NonNull @Initialized LogicalEndpoint endpoint;
    private final @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized ByteString> consumer;
    private final @UnknownKeyFor @NonNull @Initialized InboundDataClient readFuture;
    private @UnknownKeyFor @NonNull @Initialized long byteCounter;

    public static @UnknownKeyFor @NonNull @Initialized BeamFnDataInboundObserver forConsumer(@UnknownKeyFor @NonNull @Initialized LogicalEndpoint endpoint, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized ByteString> receiver) {
        return new BeamFnDataInboundObserver(endpoint, receiver, CompletableFutureInboundDataClient.create());
    }

    public BeamFnDataInboundObserver(@UnknownKeyFor @NonNull @Initialized LogicalEndpoint endpoint, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized ByteString> consumer, @UnknownKeyFor @NonNull @Initialized InboundDataClient readFuture) {
        this.endpoint = endpoint;
        this.consumer = consumer;
        this.readFuture = readFuture;
    }

    @Override
    public void accept(@UnknownKeyFor @NonNull @Initialized ByteString payload, @UnknownKeyFor @NonNull @Initialized Boolean isLast) {
        if (this.readFuture.isDone()) {
            return;
        }
        try {
            if (isLast.booleanValue()) {
                LOG.debug("Closing stream for {} having consumed {} bytes", (Object)this.endpoint, (Object)this.byteCounter);
                this.readFuture.complete();
                return;
            }
            this.byteCounter += (long)payload.size();
            this.consumer.accept(payload);
        }
        catch (Exception e) {
            this.readFuture.fail(e);
        }
    }

    @Override
    public void awaitCompletion() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.readFuture.awaitCompletion();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isDone() {
        return this.readFuture.isDone();
    }

    @Override
    public void cancel() {
        this.readFuture.cancel();
    }

    @Override
    public void complete() {
        this.readFuture.complete();
    }

    @Override
    public void fail(@UnknownKeyFor @NonNull @Initialized Throwable t) {
        this.readFuture.fail(t);
    }
}

