/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.BeamFnDataSizeBasedBufferingOutboundObserver;
import org.apache.beam.sdk.fn.data.BeamFnDataTimeBasedBufferingOutboundObserver;
import org.apache.beam.sdk.fn.data.CloseableFnDataReceiver;
import org.apache.beam.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface BeamFnDataBufferingOutboundObserver<@UnknownKeyFor T>
extends CloseableFnDataReceiver<T> {
    @Deprecated
    public static final @UnknownKeyFor @NonNull @Initialized String BEAM_FN_API_DATA_BUFFER_LIMIT = "beam_fn_api_data_buffer_limit=";
    @Deprecated
    public static final @UnknownKeyFor @NonNull @Initialized String BEAM_FN_API_DATA_BUFFER_SIZE_LIMIT = "beam_fn_api_data_buffer_size_limit=";
    public static final @UnknownKeyFor @NonNull @Initialized String DATA_BUFFER_SIZE_LIMIT = "data_buffer_size_limit=";
    @VisibleForTesting
    public static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BUFFER_LIMIT_BYTES = 1000000;
    @Deprecated
    public static final @UnknownKeyFor @NonNull @Initialized String BEAM_FN_API_DATA_BUFFER_TIME_LIMIT = "beam_fn_api_data_buffer_time_limit=";
    public static final @UnknownKeyFor @NonNull @Initialized String DATA_BUFFER_TIME_LIMIT_MS = "data_buffer_time_limit_ms=";
    public static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_BUFFER_LIMIT_TIME_MS = -1L;

    public static <T> @UnknownKeyFor @NonNull @Initialized BeamFnDataSizeBasedBufferingOutboundObserver<T> forLocation(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized LogicalEndpoint endpoint, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> outboundObserver) {
        int sizeLimit = BeamFnDataBufferingOutboundObserver.getSizeLimit(options);
        long timeLimit = BeamFnDataBufferingOutboundObserver.getTimeLimit(options);
        if (timeLimit > 0L) {
            return new BeamFnDataTimeBasedBufferingOutboundObserver<T>(sizeLimit, timeLimit, endpoint, coder, outboundObserver);
        }
        return new BeamFnDataSizeBasedBufferingOutboundObserver<T>(sizeLimit, endpoint, coder, outboundObserver);
    }

    public static @UnknownKeyFor @NonNull @Initialized int getSizeLimit(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        List experiments = ((ExperimentalOptions)options.as(ExperimentalOptions.class)).getExperiments();
        for (String experiment : experiments == null ? Collections.emptyList() : experiments) {
            if (experiment.startsWith(DATA_BUFFER_SIZE_LIMIT)) {
                return Integer.parseInt(experiment.substring(DATA_BUFFER_SIZE_LIMIT.length()));
            }
            if (experiment.startsWith(BEAM_FN_API_DATA_BUFFER_SIZE_LIMIT)) {
                return Integer.parseInt(experiment.substring(BEAM_FN_API_DATA_BUFFER_SIZE_LIMIT.length()));
            }
            if (!experiment.startsWith(BEAM_FN_API_DATA_BUFFER_LIMIT)) continue;
            return Integer.parseInt(experiment.substring(BEAM_FN_API_DATA_BUFFER_LIMIT.length()));
        }
        return 1000000;
    }

    public static @UnknownKeyFor @NonNull @Initialized long getTimeLimit(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        List experiments = ((ExperimentalOptions)options.as(ExperimentalOptions.class)).getExperiments();
        for (String experiment : experiments == null ? Collections.emptyList() : experiments) {
            if (experiment.startsWith(DATA_BUFFER_TIME_LIMIT_MS)) {
                return Long.parseLong(experiment.substring(DATA_BUFFER_TIME_LIMIT_MS.length()));
            }
            if (!experiment.startsWith(BEAM_FN_API_DATA_BUFFER_TIME_LIMIT)) continue;
            return Long.parseLong(experiment.substring(BEAM_FN_API_DATA_BUFFER_TIME_LIMIT.length()));
        }
        return -1L;
    }
}

