/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import java.io.InputStream;
import java.util.function.BiConsumer;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.CompletableFutureInboundDataClient;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.fn.data.InboundDataClient;
import org.apache.beam.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamFnDataInboundObserver<T>
implements BiConsumer<ByteString, Boolean>,
InboundDataClient {
    private static final Logger LOG = LoggerFactory.getLogger(BeamFnDataInboundObserver.class);
    private final LogicalEndpoint endpoint;
    private final FnDataReceiver<T> consumer;
    private final Coder<T> coder;
    private final InboundDataClient readFuture;
    private long byteCounter;
    private long counter;

    public static <T> BeamFnDataInboundObserver<T> forConsumer(LogicalEndpoint endpoint, Coder<T> coder, FnDataReceiver<T> receiver) {
        return new BeamFnDataInboundObserver<T>(endpoint, coder, receiver, CompletableFutureInboundDataClient.create());
    }

    public BeamFnDataInboundObserver(LogicalEndpoint endpoint, Coder<T> coder, FnDataReceiver<T> consumer, InboundDataClient readFuture) {
        this.endpoint = endpoint;
        this.coder = coder;
        this.consumer = consumer;
        this.readFuture = readFuture;
    }

    @Override
    public void accept(ByteString payload, Boolean isLast) {
        if (this.readFuture.isDone()) {
            return;
        }
        try {
            if (payload.isEmpty() || isLast.booleanValue()) {
                LOG.debug("Closing stream for {} having consumed {} values {} bytes", new Object[]{this.endpoint, this.counter, this.byteCounter});
                this.readFuture.complete();
                return;
            }
            this.byteCounter += (long)payload.size();
            InputStream inputStream = payload.newInput();
            while (inputStream.available() > 0) {
                ++this.counter;
                Object value = this.coder.decode(inputStream);
                this.consumer.accept(value);
            }
        }
        catch (Exception e) {
            this.readFuture.fail(e);
        }
    }

    @Override
    public void awaitCompletion() throws Exception {
        this.readFuture.awaitCompletion();
    }

    @Override
    public boolean isDone() {
        return this.readFuture.isDone();
    }

    @Override
    public void cancel() {
        this.readFuture.cancel();
    }

    @Override
    public void complete() {
        this.readFuture.complete();
    }

    @Override
    public void fail(Throwable t) {
        this.readFuture.fail(t);
    }
}

