/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.extensions.protobuf.ProtoDomain;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DynamicProtoCoder
extends ProtoCoder<DynamicMessage> {
    public static final long serialVersionUID = 1L;
    private static final String PROTO_MESSAGE_CLASS = "dynamic_proto_message_class";
    private static final String PROTO_EXTENSION_HOSTS = "dynamic_proto_extension_hosts";
    private transient ProtoDomain domain;
    private transient String messageName;
    static final TypeDescriptor<Message> MESSAGE_TYPE = new TypeDescriptor<Message>(){};

    public static DynamicProtoCoder of(Descriptors.Descriptor protoMessageDescriptor) {
        return new DynamicProtoCoder(ProtoDomain.buildFrom(protoMessageDescriptor), protoMessageDescriptor.getFullName(), (Set<Class<?>>)ImmutableSet.of());
    }

    public static DynamicProtoCoder of(ProtoDomain domain, Descriptors.Descriptor protoMessageDescriptor) {
        return new DynamicProtoCoder(domain, protoMessageDescriptor.getFullName(), (Set<Class<?>>)ImmutableSet.of());
    }

    public static DynamicProtoCoder of(ProtoDomain domain, String messageName) {
        return new DynamicProtoCoder(domain, messageName, (Set<Class<?>>)ImmutableSet.of());
    }

    public DynamicProtoCoder withExtensionsFrom(Iterable<Class<?>> moreExtensionHosts) {
        this.validateExtensions(moreExtensionHosts);
        return new DynamicProtoCoder(this.domain, this.messageName, (Set<Class<?>>)new ImmutableSet.Builder().addAll((Iterable)this.extensionHostClasses).addAll(moreExtensionHosts).build());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        DynamicProtoCoder otherCoder = (DynamicProtoCoder)((Object)other);
        return this.protoMessageClass.equals(otherCoder.protoMessageClass) && Sets.newHashSet((Iterable)this.extensionHostClasses).equals(Sets.newHashSet((Iterable)otherCoder.extensionHostClasses)) && this.domain.equals(otherCoder.domain) && this.messageName.equals(otherCoder.messageName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.protoMessageClass, this.extensionHostClasses, this.domain, this.messageName);
    }

    private DynamicProtoCoder(ProtoDomain domain, String messageName, Set<Class<?>> extensionHostClasses) {
        super(DynamicMessage.class, extensionHostClasses);
        this.domain = domain;
        this.messageName = messageName;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.domain);
        oos.writeObject(this.messageName);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.domain = (ProtoDomain)ois.readObject();
        this.messageName = (String)ois.readObject();
    }

    @Override
    protected Parser<DynamicMessage> getParser() {
        if (this.memoizedParser == null) {
            DynamicMessage protoMessageInstance = DynamicMessage.newBuilder((Descriptors.Descriptor)this.domain.getDescriptor(this.messageName)).build();
            this.memoizedParser = protoMessageInstance.getParserForType();
        }
        return this.memoizedParser;
    }

    public static CoderProvider getCoderProvider() {
        return new ProtoCoderProvider();
    }

    private static class ProtoCoderProvider
    extends CoderProvider {
        private ProtoCoderProvider() {
        }

        public <T> Coder<T> coderFor(TypeDescriptor<T> typeDescriptor, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
            if (!typeDescriptor.isSubtypeOf(MESSAGE_TYPE)) {
                throw new CannotProvideCoderException(String.format("Cannot provide %s because %s is not a subclass of %s", DynamicProtoCoder.class.getSimpleName(), typeDescriptor, Message.class.getName()));
            }
            TypeDescriptor<T> messageType = typeDescriptor;
            try {
                ProtoCoder<T> coder = DynamicProtoCoder.of(messageType);
                return coder;
            }
            catch (IllegalArgumentException e) {
                throw new CannotProvideCoderException((Throwable)e);
            }
        }
    }
}

