/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.coders;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;

class StatelessJavaSerializer
extends Serializer {
    public StatelessJavaSerializer(Kryo ignore1, Class<?> ignore2) {
    }

    public StatelessJavaSerializer() {
        this(null, null);
    }

    public void write(Kryo kryo, Output output, Object object) {
        try {
            ObjectOutputStream objectStream = new ObjectOutputStream((OutputStream)output);
            objectStream.writeObject(object);
            objectStream.flush();
        }
        catch (Exception e) {
            throw new KryoException("Error during Java serialization.", (Throwable)e);
        }
    }

    public Object read(Kryo kryo, Input input, Class type) {
        try {
            return new ObjectInputStreamWithClassLoader((InputStream)input, kryo.getClassLoader()).readObject();
        }
        catch (Exception e) {
            throw new KryoException("Error during Java deserialization.", (Throwable)e);
        }
    }

    private static class ObjectInputStreamWithClassLoader
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        ObjectInputStreamWithClassLoader(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) {
            try {
                return Class.forName(desc.getName(), false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not find class: " + desc.getName(), e);
            }
        }
    }
}

