/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.translation.SparkSessionFactory;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.spark.api.java.function.ForeachFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTranslationContext {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(AbstractTranslationContext.class);
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> datasets;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> leaves;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions serializablePipelineOptions;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> currentTransform;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private final @UnknownKeyFor @NonNull @Initialized SparkSession sparkSession;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> broadcastDataSets;

    public AbstractTranslationContext(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions options) {
        this.sparkSession = SparkSessionFactory.getOrCreateSession(options);
        this.serializablePipelineOptions = new SerializablePipelineOptions((PipelineOptions)options);
        this.datasets = new HashMap();
        this.leaves = new HashSet();
        this.broadcastDataSets = new HashMap();
    }

    public @UnknownKeyFor @NonNull @Initialized SparkSession getSparkSession() {
        return this.sparkSession;
    }

    public @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions getSerializableOptions() {
        return this.serializablePipelineOptions;
    }

    public void setCurrentTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> currentTransform) {
        this.currentTransform = currentTransform;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentTransform() {
        return this.currentTransform;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Dataset<T> emptyDataset() {
        return this.sparkSession.emptyDataset(EncoderHelpers.fromBeamCoder(VoidCoder.of()));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getDataset(@UnknownKeyFor @NonNull @Initialized PValue value) {
        Dataset<?> dataset = this.datasets.get(value);
        this.leaves.remove(dataset);
        return dataset;
    }

    public void putDatasetWildcard(@UnknownKeyFor @NonNull @Initialized PValue value, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> dataset) {
        if (!this.datasets.containsKey(value)) {
            this.datasets.put(value, dataset);
            this.leaves.add(dataset);
        }
    }

    public <T> void putDataset(@UnknownKeyFor @NonNull @Initialized PValue value, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> dataset) {
        if (!this.datasets.containsKey(value)) {
            this.datasets.put(value, dataset);
            this.leaves.add(dataset);
        }
    }

    public <ViewT, ElemT> void setSideInputDataset(@UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> value, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<ElemT>> set) {
        if (!this.broadcastDataSets.containsKey(value)) {
            this.broadcastDataSets.put(value, set);
        }
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Dataset<T> getSideInputDataSet(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> value) {
        return this.broadcastDataSets.get(value);
    }

    public @UnknownKeyFor @NonNull @Initialized PValue getInput() {
        return (PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.currentTransform));
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getInputs() {
        return this.currentTransform.getInputs();
    }

    public @UnknownKeyFor @NonNull @Initialized PValue getOutput() {
        return (PValue)Iterables.getOnlyElement(this.currentTransform.getOutputs().values());
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputs() {
        return this.currentTransform.getOutputs();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputCoders() {
        return this.currentTransform.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
    }

    public void startPipeline() {
        SparkStructuredStreamingPipelineOptions options = (SparkStructuredStreamingPipelineOptions)this.serializablePipelineOptions.get().as(SparkStructuredStreamingPipelineOptions.class);
        int datasetIndex = 0;
        for (Dataset<?> dataset : this.leaves) {
            if (options.isStreaming()) {
                DataStreamWriter dataStreamWriter = dataset.writeStream();
                if (options.getCheckpointDir() != null) {
                    dataStreamWriter = dataStreamWriter.option("checkpointLocation", options.getCheckpointDir());
                }
                this.launchStreaming(dataStreamWriter.foreach(new NoOpForeachWriter()));
                continue;
            }
            if (options.getTestMode()) {
                LOG.debug("**** dataset {} catalyst execution plans ****", (Object)(++datasetIndex));
                dataset.explain(true);
            }
            dataset.foreach((ForeachFunction & Serializable)t -> {});
        }
    }

    public abstract void launchStreaming(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DataStreamWriter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

    public static void printDatasetContent(@UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue> dataset) {
        List windowedValues = dataset.collectAsList();
        for (WindowedValue windowedValue : windowedValues) {
            LOG.debug("**** dataset content {} ****", (Object)windowedValue.toString());
        }
    }

    private static class NoOpForeachWriter<@UnknownKeyFor T>
    extends ForeachWriter<T> {
        private NoOpForeachWriter() {
        }

        public @UnknownKeyFor @NonNull @Initialized boolean open(@UnknownKeyFor @NonNull @Initialized long partitionId, @UnknownKeyFor @NonNull @Initialized long epochId) {
            return false;
        }

        public void process(T value) {
        }

        public void close(@UnknownKeyFor @NonNull @Initialized Throwable errorOrNull) {
        }
    }
}

