/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricFilter;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.spark.structuredstreaming.aggregators.NamedAggregators;
import org.apache.beam.runners.spark.structuredstreaming.metrics.BeamMetricSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatorMetric
extends BeamMetricSet {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(AggregatorMetric.class);
    private final @UnknownKeyFor @NonNull @Initialized NamedAggregators namedAggregators;

    private AggregatorMetric(@UnknownKeyFor @NonNull @Initialized NamedAggregators namedAggregators) {
        this.namedAggregators = namedAggregators;
    }

    public static @UnknownKeyFor @NonNull @Initialized AggregatorMetric of(@UnknownKeyFor @NonNull @Initialized NamedAggregators namedAggregators) {
        return new AggregatorMetric(namedAggregators);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Gauge<@UnknownKeyFor @NonNull @Initialized Double>> getValue(@UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        HashMap<String, Gauge<Double>> metrics = new HashMap<String, Gauge<Double>>();
        for (Map.Entry<String, ?> entry : this.namedAggregators.renderAll().entrySet()) {
            String name = prefix + "." + entry.getKey();
            Object rawValue = entry.getValue();
            if (rawValue == null) continue;
            try {
                Gauge<Double> gauge = this.staticGauge(rawValue);
                if (!filter.matches(name, gauge)) continue;
                metrics.put(name, gauge);
            }
            catch (NumberFormatException e) {
                LOG.warn("Metric `{}` of type {} can't be reported, conversion to double failed.", new Object[]{name, rawValue.getClass().getSimpleName(), e});
            }
        }
        return metrics;
    }

    protected @UnknownKeyFor @NonNull @Initialized Gauge<@UnknownKeyFor @NonNull @Initialized Double> staticGauge(@UnknownKeyFor @NonNull @Initialized Object rawValue) throws @UnknownKeyFor @NonNull @Initialized NumberFormatException {
        return rawValue instanceof Number ? super.staticGauge((Number)rawValue) : super.staticGauge(Double.parseDouble(rawValue.toString()));
    }
}

