/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.io.EmptyCheckpointMark;
import org.apache.beam.runners.spark.io.MicrobatchSource;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.spark.Dependency;
import org.apache.spark.HashPartitioner;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.rdd.RDD;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;

public class SourceRDD {

    private static class CheckpointableSourcePartition<@UnknownKeyFor T, @UnknownKeyFor CheckpointMarkT extends // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
    extends SourcePartition<T> {
        private final CheckpointMarkT checkpointMark;

        CheckpointableSourcePartition(@UnknownKeyFor @NonNull @Initialized int rddId, @UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized Source<T> source, CheckpointMarkT checkpointMark) {
            super(rddId, index, source);
            this.checkpointMark = checkpointMark;
        }
    }

    public static class Unbounded<@UnknownKeyFor T, @UnknownKeyFor CheckpointMarkT extends // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
    extends RDD<Tuple2<Source<T>, CheckpointMarkT>> {
        private final @UnknownKeyFor @NonNull @Initialized MicrobatchSource<T, CheckpointMarkT> microbatchSource;
        private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options;
        private final @UnknownKeyFor @NonNull @Initialized Partitioner partitioner;
        private static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Dependency<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> NIL = JavaConversions.asScalaBuffer(Collections.emptyList()).toList();

        public Unbounded(@UnknownKeyFor @NonNull @Initialized SparkContext sc, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options, @UnknownKeyFor @NonNull @Initialized MicrobatchSource<T, CheckpointMarkT> microbatchSource, @UnknownKeyFor @NonNull @Initialized int initialNumPartitions) {
            super(sc, NIL, JavaSparkContext$.MODULE$.fakeClassTag());
            this.options = options;
            this.microbatchSource = microbatchSource;
            this.partitioner = new HashPartitioner(initialNumPartitions);
        }

        public @UnknownKeyFor @NonNull @Initialized Partition @UnknownKeyFor @NonNull @Initialized [] getPartitions() {
            try {
                java.util.List<Source<T>> partitionedSources = this.microbatchSource.split(this.options.get());
                Partition[] partitions = new CheckpointableSourcePartition[partitionedSources.size()];
                for (int i = 0; i < partitionedSources.size(); ++i) {
                    partitions[i] = new CheckpointableSourcePartition<T, EmptyCheckpointMark>(this.id(), i, partitionedSources.get(i), EmptyCheckpointMark.get());
                }
                return partitions;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create partitions.", e);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized Partitioner> partitioner() {
            return Some.apply((Object)this.partitioner);
        }

        public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Source<T>, CheckpointMarkT>> compute(@UnknownKeyFor @NonNull @Initialized Partition split, @UnknownKeyFor @NonNull @Initialized TaskContext context) {
            CheckpointableSourcePartition partition = (CheckpointableSourcePartition)split;
            Tuple2 tuple2 = new Tuple2(partition.getSource(), (Object)partition.checkpointMark);
            return JavaConversions.asScalaIterator(Collections.singleton(tuple2).iterator());
        }
    }

    private static class SourcePartition<@UnknownKeyFor T>
    implements Partition {
        private final @UnknownKeyFor @NonNull @Initialized int rddId;
        private final @UnknownKeyFor @NonNull @Initialized int index;
        private final @UnknownKeyFor @NonNull @Initialized Source<T> source;

        SourcePartition(@UnknownKeyFor @NonNull @Initialized int rddId, @UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized Source<T> source) {
            this.rddId = rddId;
            this.index = index;
            this.source = source;
        }

        public @UnknownKeyFor @NonNull @Initialized int index() {
            return this.index;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return 41 * (41 + this.rddId) + this.index;
        }

        @UnknownKeyFor @NonNull @Initialized Source<T> getSource() {
            return this.source;
        }
    }

    public static class Bounded<@UnknownKeyFor T>
    extends RDD<WindowedValue<T>> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Bounded.class);
        private final @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source;
        private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options;
        private final @UnknownKeyFor @NonNull @Initialized int numPartitions;
        private final @UnknownKeyFor @NonNull @Initialized long bundleSize;
        private final @UnknownKeyFor @NonNull @Initialized String stepName;
        private final @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMapAccumulator metricsAccum;
        private static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Seq<@UnknownKeyFor @NonNull @Initialized Dependency<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> NIL = JavaConversions.asScalaBuffer(Collections.emptyList()).toList();
        private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_BUNDLE_SIZE = 0x4000000L;

        public Bounded(@UnknownKeyFor @NonNull @Initialized SparkContext sc, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options, @UnknownKeyFor @NonNull @Initialized String stepName) {
            super(sc, NIL, JavaSparkContext$.MODULE$.fakeClassTag());
            this.source = source;
            this.options = options;
            this.numPartitions = sc.defaultParallelism();
            Preconditions.checkArgument((this.numPartitions > 0 ? 1 : 0) != 0, (Object)"Number of partitions must be greater than zero.");
            this.bundleSize = ((SparkPipelineOptions)options.get().as(SparkPipelineOptions.class)).getBundleSize();
            this.stepName = stepName;
            this.metricsAccum = MetricsAccumulator.getInstance();
        }

        public @UnknownKeyFor @NonNull @Initialized Partition @UnknownKeyFor @NonNull @Initialized [] getPartitions() {
            try {
                long desiredSizeBytes;
                long l = desiredSizeBytes = this.bundleSize > 0L ? this.bundleSize : 0x4000000L;
                if (this.bundleSize == 0L) {
                    try {
                        desiredSizeBytes = this.source.getEstimatedSizeBytes(this.options.get()) / (long)this.numPartitions;
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to get estimated bundle size for source {}, using default bundle size of {} bytes.", this.source, (Object)0x4000000L);
                    }
                }
                java.util.List partitionedSources = this.source.split(desiredSizeBytes, this.options.get());
                Partition[] partitions = new SourcePartition[partitionedSources.size()];
                for (int i = 0; i < partitionedSources.size(); ++i) {
                    partitions[i] = new SourcePartition(this.id(), i, (Source)partitionedSources.get(i));
                }
                return partitions;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create partitions for source " + this.source.getClass().getSimpleName(), e);
            }
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> createReader(@UnknownKeyFor @NonNull @Initialized SourcePartition<T> partition) {
            try {
                return ((BoundedSource)((SourcePartition)partition).source).createReader(this.options.get());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create reader from a BoundedSource.", e);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> compute(@UnknownKeyFor @NonNull @Initialized Partition split, @UnknownKeyFor @NonNull @Initialized TaskContext context) {
            MetricsContainerImpl metricsContainer = this.metricsAccum.value().getContainer(this.stepName);
            BoundedSource.BoundedReader<T> reader = this.createReader((SourcePartition)split);
            ReaderToIteratorAdapter<T> readerIterator = new ReaderToIteratorAdapter<T>((MetricsContainer)metricsContainer, reader);
            return new InterruptibleIterator(context, JavaConversions.asScalaIterator(readerIterator));
        }

        @VisibleForTesting
        static class ReaderToIteratorAdapter<@UnknownKeyFor T>
        implements java.util.Iterator<WindowedValue<T>> {
            private static final @UnknownKeyFor @NonNull @Initialized boolean FAILED_TO_OBTAIN_NEXT = false;
            private static final @UnknownKeyFor @NonNull @Initialized boolean SUCCESSFULLY_OBTAINED_NEXT = true;
            private final @UnknownKeyFor @NonNull @Initialized MetricsContainer metricsContainer;
            private final // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader;
            private @UnknownKeyFor @NonNull @Initialized boolean started = false;
            private @UnknownKeyFor @NonNull @Initialized boolean closed = false;
            private @UnknownKeyFor @NonNull @Initialized WindowedValue<T> next = null;

            ReaderToIteratorAdapter(@UnknownKeyFor @NonNull @Initialized MetricsContainer metricsContainer, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader) {
                this.metricsContainer = metricsContainer;
                this.reader = reader;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private @UnknownKeyFor @NonNull @Initialized boolean tryProduceNext() {
                try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.metricsContainer);){
                    if (this.closed) {
                        boolean bl = false;
                        return bl;
                    }
                    Preconditions.checkState((this.next == null ? 1 : 0) != 0, (Object)"unexpected non-null value for next");
                    if (this.seekNext()) {
                        this.next = WindowedValue.timestampedValueInGlobalWindow((Object)this.reader.getCurrent(), (Instant)this.reader.getCurrentTimestamp());
                        boolean bl = true;
                        return bl;
                    }
                    this.close();
                    boolean bl = false;
                    return bl;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to read data.", e);
                }
            }

            private void close() {
                this.closed = true;
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            private @UnknownKeyFor @NonNull @Initialized boolean seekNext() throws @UnknownKeyFor @NonNull @Initialized IOException {
                if (!this.started) {
                    this.started = true;
                    return this.reader.start();
                }
                return !this.closed && this.reader.advance();
            }

            private @UnknownKeyFor @NonNull @Initialized WindowedValue<T> consumeCurrent() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                WindowedValue<T> current = this.next;
                this.next = null;
                return current;
            }

            private @UnknownKeyFor @NonNull @Initialized WindowedValue<T> consumeNext() {
                if (this.next == null) {
                    this.tryProduceNext();
                }
                return this.consumeCurrent();
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                return this.next != null || this.tryProduceNext();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> next() {
                return this.consumeNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

