/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.metrics;

import java.io.IOException;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.translation.streaming.Checkpoint;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaStreamingListener;
import org.apache.spark.streaming.api.java.JavaStreamingListenerBatchCompleted;
import org.apache.spark.util.AccumulatorV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAccumulator {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsAccumulator.class);
    private static final String ACCUMULATOR_NAME = "Beam.Metrics";
    private static final String ACCUMULATOR_CHECKPOINT_FILENAME = "metrics";
    private static volatile MetricsContainerStepMapAccumulator instance = null;
    private static volatile FileSystem fileSystem;
    private static volatile Path checkpointFilePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(SparkPipelineOptions opts, JavaSparkContext jsc) {
        if (instance == null) {
            Class<MetricsAccumulator> clazz = MetricsAccumulator.class;
            synchronized (MetricsAccumulator.class) {
                if (instance == null) {
                    Optional<MetricsContainerStepMap> maybeRecoveredValue;
                    Optional maybeCheckpointDir = opts.isStreaming() ? Optional.of((Object)new Checkpoint.CheckpointDir(opts.getCheckpointDir())) : Optional.absent();
                    MetricsContainerStepMap metricsContainerStepMap = new MetricsContainerStepMap();
                    MetricsContainerStepMapAccumulator accumulator = new MetricsContainerStepMapAccumulator(metricsContainerStepMap);
                    jsc.sc().register((AccumulatorV2)accumulator, ACCUMULATOR_NAME);
                    if (maybeCheckpointDir.isPresent() && (maybeRecoveredValue = MetricsAccumulator.recoverValueFromCheckpoint(jsc, (Checkpoint.CheckpointDir)maybeCheckpointDir.get())).isPresent()) {
                        accumulator = new MetricsContainerStepMapAccumulator((MetricsContainerStepMap)maybeRecoveredValue.get());
                    }
                    instance = accumulator;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                LOG.info("Instantiated metrics accumulator: " + instance.value());
            }
        } else {
            instance.reset();
        }
    }

    public static MetricsContainerStepMapAccumulator getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Metrics accumulator has not been instantiated");
        }
        return instance;
    }

    private static Optional<MetricsContainerStepMap> recoverValueFromCheckpoint(JavaSparkContext jsc, Checkpoint.CheckpointDir checkpointDir) {
        try {
            Path beamCheckpointPath = checkpointDir.getBeamCheckpointDir();
            checkpointFilePath = new Path(beamCheckpointPath, ACCUMULATOR_CHECKPOINT_FILENAME);
            fileSystem = checkpointFilePath.getFileSystem(jsc.hadoopConfiguration());
            MetricsContainerStepMap recoveredValue = (MetricsContainerStepMap)Checkpoint.readObject(fileSystem, checkpointFilePath);
            if (recoveredValue != null) {
                LOG.info("Recovered metrics from checkpoint.");
                return Optional.of((Object)recoveredValue);
            }
            LOG.info("No metrics checkpoint found.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failure while reading metrics checkpoint.", e);
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clear() {
        Class<MetricsAccumulator> clazz = MetricsAccumulator.class;
        synchronized (MetricsAccumulator.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void checkpoint() throws IOException {
        if (checkpointFilePath != null) {
            Checkpoint.writeObject(fileSystem, checkpointFilePath, instance.value());
        }
    }

    public static class AccumulatorCheckpointingSparkListener
    extends JavaStreamingListener {
        public void onBatchCompleted(JavaStreamingListenerBatchCompleted batchCompleted) {
            try {
                MetricsAccumulator.checkpoint();
            }
            catch (IOException e) {
                LOG.error("Failed to checkpoint metrics singleton.", (Throwable)e);
            }
        }
    }
}

