/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.metrics.SparkBeamMetric;
import org.apache.beam.runners.spark.translation.SparkCombineFn;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.immutable.HashMap;

public class SparkCompat {
    private SparkCompat() {
    }

    public static <T> JavaDStream<WindowedValue<T>> joinStreams(JavaStreamingContext streamingContext, List<JavaDStream<WindowedValue<T>>> dStreams) {
        try {
            if (streamingContext.sparkContext().version().startsWith("3")) {
                Method method = streamingContext.getClass().getDeclaredMethod("union", JavaDStream[].class);
                Object result = method.invoke((Object)streamingContext, new Object[]{dStreams.toArray(new JavaDStream[0])});
                return (JavaDStream)result;
            }
            Method method = streamingContext.getClass().getDeclaredMethod("union", JavaDStream.class, List.class);
            Object result = method.invoke((Object)streamingContext, dStreams.remove(0), dStreams);
            return (JavaDStream)result;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error invoking Spark union", e);
        }
    }

    public static <K, InputT, AccumT, OutputT> JavaPairRDD<K, WindowedValue<OutputT>> extractOutput(JavaPairRDD<K, SparkCombineFn.WindowedAccumulator<KV<K, InputT>, InputT, AccumT, ?>> accumulatePerKey, SparkCombineFn<KV<K, InputT>, InputT, AccumT, OutputT> sparkCombineFn) {
        try {
            if (accumulatePerKey.context().version().startsWith("3")) {
                FlatMapFunction & Serializable flatMapFunction = (FlatMapFunction & Serializable)windowedAccumulator -> sparkCombineFn.extractOutputStream((SparkCombineFn.WindowedAccumulator)windowedAccumulator).iterator();
                Method method = accumulatePerKey.getClass().getDeclaredMethod("flatMapValues", FlatMapFunction.class);
                Object result = method.invoke(accumulatePerKey, flatMapFunction);
                return (JavaPairRDD)result;
            }
            Function & Serializable flatMapFunction = (Function & Serializable)windowedAccumulator -> sparkCombineFn.extractOutputStream((SparkCombineFn.WindowedAccumulator)windowedAccumulator).collect(Collectors.toList());
            Method method = accumulatePerKey.getClass().getDeclaredMethod("flatMapValues", Function.class);
            Object result = method.invoke(accumulatePerKey, flatMapFunction);
            return (JavaPairRDD)result;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error invoking Spark flatMapValues", e);
        }
    }

    public static SparkListenerApplicationStart buildSparkListenerApplicationStart(JavaSparkContext jsc, SparkPipelineOptions options, long time, PipelineResult result) {
        String appName = ((ApplicationNameOptions)options.as(ApplicationNameOptions.class)).getAppName();
        Option appId = Option.apply((Object)jsc.getConf().getAppId());
        Option appAttemptId = Option.apply((Object)"1");
        Option driverLogs = Option.apply((Object)((Map)JavaConverters.mapAsScalaMapConverter(SparkBeamMetric.renderAllToString(result.metrics())).asScala()));
        try {
            Class<?> clazz = Class.forName(SparkListenerApplicationStart.class.getName());
            if (jsc.version().startsWith("3")) {
                Class[] parameterTypes = new Class[]{String.class, Option.class, Long.TYPE, String.class, Option.class, Option.class, Option.class};
                Constructor<?> cons = clazz.getConstructor(parameterTypes);
                Option driverAttributes = Option.apply((Object)new HashMap());
                Object[] args = new Object[]{appName, appId, time, jsc.sparkUser(), appAttemptId, driverLogs, driverAttributes};
                return (SparkListenerApplicationStart)cons.newInstance(args);
            }
            Class[] parameterTypes = new Class[]{String.class, Option.class, Long.TYPE, String.class, Option.class, Option.class};
            Constructor<?> cons = clazz.getConstructor(parameterTypes);
            Object[] args = new Object[]{appName, appId, time, jsc.sparkUser(), appAttemptId, driverLogs};
            return (SparkListenerApplicationStart)cons.newInstance(args);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error building SparkListenerApplicationStart", e);
        }
    }
}

