/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.EventLoggingListener;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.cluster.ExecutorInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.Map;

@Internal
public class SparkCommon {
    public static @Nullable EventLoggingListener startEventLoggingListener(JavaSparkContext jsc, SparkPipelineOptions pipelineOptions, long startTime) {
        EventLoggingListener eventLoggingListener = null;
        try {
            if (jsc.getConf().getBoolean("spark.eventLog.enabled", false)) {
                Tuple2[] sparkExecutors;
                eventLoggingListener = new EventLoggingListener(jsc.getConf().getAppId(), Option.apply((Object)"1"), new URI(jsc.getConf().get("spark.eventLog.dir", null)), jsc.getConf(), jsc.hadoopConfiguration());
                eventLoggingListener.initializeLogIfNecessary(false, false);
                eventLoggingListener.start();
                HashMap logUrlMap = new HashMap();
                Tuple2[] sparkMasters = jsc.getConf().getAllWithPrefix("spark.master");
                for (Tuple2 sparkExecutor : sparkExecutors = jsc.getConf().getAllWithPrefix("spark.executor.id")) {
                    eventLoggingListener.onExecutorAdded(new SparkListenerExecutorAdded(startTime, (String)sparkExecutor._2(), new ExecutorInfo((String)sparkMasters[0]._2(), 0, (Map)logUrlMap)));
                }
                return eventLoggingListener;
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("The URI syntax in the Spark config \"spark.eventLog.dir\" is not correct", e);
        }
        return eventLoggingListener;
    }
}

