/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;

class ProcessContext<FnInputT, FnOutputT, OutputT> {
    private final DoFn<FnInputT, FnOutputT> doFn;
    private final DoFnRunner<FnInputT, FnOutputT> doFnRunner;
    private final ProcessOutputManager<OutputT> outputManager;
    private final Iterator<TimerInternals.TimerData> timerDataIterator;

    ProcessContext(DoFn<FnInputT, FnOutputT> doFn, DoFnRunner<FnInputT, FnOutputT> doFnRunner, ProcessOutputManager<OutputT> outputManager, Iterator<TimerInternals.TimerData> timerDataIterator) {
        this.doFn = doFn;
        this.doFnRunner = doFnRunner;
        this.outputManager = outputManager;
        this.timerDataIterator = timerDataIterator;
    }

    Iterable<OutputT> processPartition(Iterator<WindowedValue<FnInputT>> partition) {
        if (!partition.hasNext()) {
            return new ArrayList();
        }
        return this.getOutputIterable(partition, this.doFnRunner);
    }

    private void clearOutput() {
        this.outputManager.clear();
    }

    private Iterator<OutputT> getOutputIterator() {
        return this.outputManager.iterator();
    }

    private Iterable<OutputT> getOutputIterable(Iterator<WindowedValue<FnInputT>> iter, DoFnRunner<FnInputT, FnOutputT> doFnRunner) {
        return () -> new ProcCtxtIterator(iter, doFnRunner);
    }

    private class ProcCtxtIterator
    extends AbstractIterator<OutputT> {
        private final Iterator<WindowedValue<FnInputT>> inputIterator;
        private final DoFnRunner<FnInputT, FnOutputT> doFnRunner;
        private Iterator<OutputT> outputIterator;
        private boolean isBundleStarted;
        private boolean isBundleFinished;

        ProcCtxtIterator(Iterator<WindowedValue<FnInputT>> iterator, DoFnRunner<FnInputT, FnOutputT> doFnRunner) {
            this.inputIterator = iterator;
            this.doFnRunner = doFnRunner;
            this.outputIterator = ProcessContext.this.getOutputIterator();
        }

        protected OutputT computeNext() {
            try {
                if (!this.isBundleStarted) {
                    this.isBundleStarted = true;
                    this.doFnRunner.startBundle();
                }
                while (true) {
                    if (this.outputIterator.hasNext()) {
                        return this.outputIterator.next();
                    }
                    ProcessContext.this.clearOutput();
                    if (this.inputIterator.hasNext()) {
                        this.doFnRunner.processElement(this.inputIterator.next());
                        this.outputIterator = ProcessContext.this.getOutputIterator();
                        continue;
                    }
                    if (ProcessContext.this.timerDataIterator.hasNext()) {
                        this.outputIterator = ProcessContext.this.getOutputIterator();
                        continue;
                    }
                    if (this.isBundleFinished) break;
                    this.isBundleFinished = true;
                    this.doFnRunner.finishBundle();
                    this.outputIterator = ProcessContext.this.getOutputIterator();
                }
                DoFnInvokers.invokerFor((DoFn)ProcessContext.this.doFn).invokeTeardown();
                return this.endOfData();
            }
            catch (RuntimeException re) {
                DoFnInvokers.invokerFor((DoFn)ProcessContext.this.doFn).invokeTeardown();
                throw re;
            }
        }
    }

    static interface ProcessOutputManager<T>
    extends DoFnRunners.OutputManager,
    Iterable<T> {
        public void clear();
    }
}

