/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.artifact;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.model.jobmanagement.v1.ArtifactRetrievalServiceGrpc;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.ArtifactResolver;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.runners.core.construction.DefaultArtifactResolver;
import org.apache.beam.runners.fnexecution.FnService;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.StatusException;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ArtifactRetrievalService
extends ArtifactRetrievalServiceGrpc.ArtifactRetrievalServiceImplBase
implements FnService {
    public static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BUFFER_SIZE = 0x200000;
    public static final @UnknownKeyFor @NonNull @Initialized String FILE_ARTIFACT_URN = "beam:artifact:type:file:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String URL_ARTIFACT_URN = "beam:artifact:type:url:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String EMBEDDED_ARTIFACT_URN = "beam:artifact:type:embedded:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String STAGING_TO_ARTIFACT_URN = "beam:artifact:role:staging_to:v1";
    private final @UnknownKeyFor @NonNull @Initialized ArtifactResolver resolver;
    private final @UnknownKeyFor @NonNull @Initialized int bufferSize;

    public ArtifactRetrievalService() {
        this(0x200000);
    }

    public ArtifactRetrievalService(@UnknownKeyFor @NonNull @Initialized ArtifactResolver resolver) {
        this(resolver, 0x200000);
    }

    public ArtifactRetrievalService(@UnknownKeyFor @NonNull @Initialized int bufferSize) {
        this(DefaultArtifactResolver.INSTANCE, bufferSize);
    }

    public ArtifactRetrievalService(@UnknownKeyFor @NonNull @Initialized ArtifactResolver resolver, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
        this.resolver = resolver;
        this.bufferSize = bufferSize;
    }

    public void resolveArtifacts(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ArtifactApi.ResolveArtifactsRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ArtifactApi.ResolveArtifactsResponse> responseObserver) {
        responseObserver.onNext((Object)ArtifactApi.ResolveArtifactsResponse.newBuilder().addAllReplacements((Iterable)this.resolver.resolveArtifacts(request.getArtifactsList())).build());
        responseObserver.onCompleted();
    }

    public void getArtifact(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ArtifactApi.GetArtifactRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ArtifactApi.GetArtifactResponse> responseObserver) {
        try {
            int bytesRead;
            InputStream inputStream = ArtifactRetrievalService.getArtifact(request.getArtifact());
            byte[] buffer = new byte[this.bufferSize];
            while ((bytesRead = inputStream.read(buffer)) > 0) {
                responseObserver.onNext((Object)ArtifactApi.GetArtifactResponse.newBuilder().setData(ByteString.copyFrom((byte[])buffer, (int)0, (int)bytesRead)).build());
            }
            responseObserver.onCompleted();
        }
        catch (IOException exn) {
            exn.printStackTrace();
            responseObserver.onError((Throwable)exn);
        }
        catch (UnsupportedOperationException exn) {
            responseObserver.onError((Throwable)new StatusException(Status.INVALID_ARGUMENT.withDescription(exn.getMessage())));
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream getArtifact(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation artifact) throws @UnknownKeyFor @NonNull @Initialized IOException {
        switch (artifact.getTypeUrn()) {
            case "beam:artifact:type:file:v1": {
                RunnerApi.ArtifactFilePayload payload = RunnerApi.ArtifactFilePayload.parseFrom((ByteString)artifact.getTypePayload());
                return Channels.newInputStream(FileSystems.open((ResourceId)FileSystems.matchNewResource((String)payload.getPath(), (boolean)false)));
            }
            case "beam:artifact:type:embedded:v1": {
                return RunnerApi.EmbeddedFilePayload.parseFrom((ByteString)artifact.getTypePayload()).getData().newInput();
            }
        }
        throw new UnsupportedOperationException("Unexpected artifact type: " + artifact.getTypeUrn());
    }

    @Override
    public void close() {
    }

    static {
        Preconditions.checkState((boolean)FILE_ARTIFACT_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE)));
        Preconditions.checkState((boolean)URL_ARTIFACT_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.URL)));
        Preconditions.checkState((boolean)EMBEDDED_ARTIFACT_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.EMBEDDED)));
        Preconditions.checkState((boolean)STAGING_TO_ARTIFACT_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO)));
    }
}

