/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.runners.fnexecution.control.ProcessBundleDescriptors;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerReceiverFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TimerReceiverFactory.class);
    private final HashMap<KV<String, String>, ProcessBundleDescriptors.TimerSpec> transformAndTimerIdToSpecMap = new HashMap();
    private final BiConsumer<Timer<?>, TimerInternals.TimerData> timerDataConsumer;
    private final Coder windowCoder;

    public TimerReceiverFactory(StageBundleFactory stageBundleFactory, BiConsumer<Timer<?>, TimerInternals.TimerData> timerDataConsumer, Coder windowCoder) {
        for (Map<String, ProcessBundleDescriptors.TimerSpec> transformTimerMap : stageBundleFactory.getProcessBundleDescriptor().getTimerSpecs().values()) {
            for (ProcessBundleDescriptors.TimerSpec timerSpec : transformTimerMap.values()) {
                this.transformAndTimerIdToSpecMap.put((KV<String, String>)KV.of((Object)timerSpec.transformId(), (Object)timerSpec.timerId()), timerSpec);
            }
        }
        this.timerDataConsumer = timerDataConsumer;
        this.windowCoder = windowCoder;
    }

    public <K> FnDataReceiver<Timer<K>> create(String transformId, String timerFamilyId) {
        ProcessBundleDescriptors.TimerSpec timerSpec = this.transformAndTimerIdToSpecMap.get(KV.of((Object)transformId, (Object)timerFamilyId));
        return receivedElement -> {
            Timer timer = (Timer)Preconditions.checkNotNull((Object)receivedElement, (String)"Received null Timer from SDK harness: %s", (Object)receivedElement);
            LOG.debug("Timer received: {}", (Object)timer);
            for (Object window : timer.getWindows()) {
                StateNamespace namespace = StateNamespaces.window((Coder)this.windowCoder, (BoundedWindow)((BoundedWindow)window));
                TimerInternals.TimerData timerData = TimerInternals.TimerData.of((String)TimerReceiverFactory.encodeToTimerDataTimerId(timerSpec.transformId(), timerSpec.timerId()), (StateNamespace)namespace, (Instant)(timer.getClearBit() ? BoundedWindow.TIMESTAMP_MAX_VALUE : timer.getFireTimestamp()), (Instant)(timer.getClearBit() ? BoundedWindow.TIMESTAMP_MAX_VALUE : timer.getHoldTimestamp()), (TimeDomain)timerSpec.getTimerSpec().getTimeDomain());
                this.timerDataConsumer.accept(timer, timerData);
            }
        };
    }

    public static String encodeToTimerDataTimerId(String transformId, String timerFamilyId) {
        return transformId.length() + ":" + transformId + ":" + timerFamilyId;
    }

    public static KV<String, String> decodeTimerDataTimerId(String timerDataTimerId) {
        int transformIdLengthSplit = timerDataTimerId.indexOf(":");
        if (transformIdLengthSplit <= 0) {
            throw new IllegalArgumentException(String.format("Invalid encoding, expected len(transformId):transformId:timerId as the encoding but received %s", timerDataTimerId));
        }
        int transformIdLength = Integer.parseInt(timerDataTimerId.substring(0, transformIdLengthSplit));
        String transformId = timerDataTimerId.substring(transformIdLengthSplit + 1, transformIdLengthSplit + 1 + transformIdLength);
        String timerFamilyId = timerDataTimerId.substring(transformIdLengthSplit + 1 + transformIdLength + 1);
        return KV.of((Object)transformId, (Object)timerFamilyId);
    }
}

