/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.FileStagingOptions;
import org.apache.beam.sdk.options.Hidden;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Description(value="Options that are used to configure the Dataflow pipeline worker pool.")
public interface DataflowPipelineWorkerPoolOptions
extends GcpOptions,
FileStagingOptions {
    @Description(value="Number of workers to use when executing the Dataflow job. Note that selection of an autoscaling algorithm other then \"NONE\" will affect the size of the worker pool. If left unspecified, the Dataflow service will determine the number of workers.")
    public @UnknownKeyFor @NonNull @Initialized int getNumWorkers();

    public void setNumWorkers(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="The autoscaling algorithm to use for the workerpool. NONE: does not change the size of the worker pool. BASIC (deprecated): autoscale the worker pool size up to maxNumWorkers until the job completes. THROUGHPUT_BASED: autoscale the workerpool based on throughput (up to maxNumWorkers).")
    public @UnknownKeyFor @NonNull @Initialized AutoscalingAlgorithmType getAutoscalingAlgorithm();

    public void setAutoscalingAlgorithm(@UnknownKeyFor @NonNull @Initialized AutoscalingAlgorithmType var1);

    @Description(value="The maximum number of workers to use for the workerpool. This options limits the size of the workerpool for the lifetime of the job, including pipeline updates. If left unspecified, the Dataflow service will compute a ceiling.")
    public @UnknownKeyFor @NonNull @Initialized int getMaxNumWorkers();

    public void setMaxNumWorkers(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Remote worker disk size, in gigabytes, or 0 to use the default size.")
    public @UnknownKeyFor @NonNull @Initialized int getDiskSizeGb();

    public void setDiskSizeGb(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Container image used to configure a Dataflow worker. Can only be used for official Dataflow container images. Prefer using sdkContainerImage instead.")
    @Deprecated
    @Hidden
    public @UnknownKeyFor @NonNull @Initialized String getWorkerHarnessContainerImage();

    @Deprecated
    @Hidden
    public void setWorkerHarnessContainerImage(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Container image used to configure the SDK execution environment of pipeline code on a worker. For non-portable pipelines, can only be used for official Dataflow container images.")
    public @UnknownKeyFor @NonNull @Initialized String getSdkContainerImage();

    public void setSdkContainerImage(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="GCE network for launching workers. For more information, see the reference documentation https://cloud.google.com/compute/docs/networking. Default is up to the Dataflow service.")
    public @UnknownKeyFor @NonNull @Initialized String getNetwork();

    public void setNetwork(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="GCE subnetwork for launching workers. For more information, see the reference documentation https://cloud.google.com/compute/docs/networking. Default is up to the Dataflow service.")
    public @UnknownKeyFor @NonNull @Initialized String getSubnetwork();

    public void setSubnetwork(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Machine type to create Dataflow worker VMs as. See https://cloud.google.com/compute/docs/machine-types for a list of valid options. If unset, the Dataflow service will choose a reasonable default.")
    public @UnknownKeyFor @NonNull @Initialized String getWorkerMachineType();

    public void setWorkerMachineType(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Specifies what type of persistent disk is used. The value is a full URL of a disk type resource, e.g., compute.googleapis.com/projects//zones//diskTypes/pd-ssd. For more information, see the API reference documentation for DiskTypes: https://cloud.google.com/compute/docs/reference/latest/diskTypes")
    public @UnknownKeyFor @NonNull @Initialized String getWorkerDiskType();

    public void setWorkerDiskType(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Specifies whether worker pools should be started with public IP addresses. WARNING:This feature is available only through allowlist.")
    @JsonIgnore
    public @Nullable @UnknownKeyFor @Initialized Boolean getUsePublicIps();

    public void setUsePublicIps(@Nullable @UnknownKeyFor @Initialized Boolean var1);

    @Description(value="GCE minimum CPU platform. Default is determined by GCP.")
    public @Nullable @UnknownKeyFor @Initialized String getMinCpuPlatform();

    public void setMinCpuPlatform(@UnknownKeyFor @NonNull @Initialized String var1);

    public static enum AutoscalingAlgorithmType {
        NONE("AUTOSCALING_ALGORITHM_NONE"),
        BASIC("AUTOSCALING_ALGORITHM_BASIC"),
        THROUGHPUT_BASED("AUTOSCALING_ALGORITHM_BASIC");

        private final @UnknownKeyFor @NonNull @Initialized String algorithm;

        private AutoscalingAlgorithmType(String algorithm) {
            this.algorithm = algorithm;
        }

        public @UnknownKeyFor @NonNull @Initialized String getAlgorithm() {
            return this.algorithm;
        }
    }
}

