/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.beam.runners.dataflow.CreateDataflowView;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.internal.IsmFormat;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.SystemDoFnInternal;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ForwardingMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

class BatchViewOverrides {
    BatchViewOverrides() {
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> valueInEmptyWindows(T value) {
        return new ValueInEmptyWindows(value);
    }

    private static class ValueInEmptyWindows<@UnknownKeyFor T>
    extends WindowedValue<T> {
        private final T value;

        private ValueInEmptyWindows(T value) {
            this.value = value;
        }

        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(NewT value) {
            return new ValueInEmptyWindows<NewT>(value);
        }

        public T getValue() {
            return this.value;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
            return BoundedWindow.TIMESTAMP_MIN_VALUE;
        }

        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return Collections.emptyList();
        }

        public @UnknownKeyFor @NonNull @Initialized PaneInfo getPane() {
            return PaneInfo.NO_FIRING;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("value", this.getValue()).toString();
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getValue());
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (o instanceof ValueInEmptyWindows) {
                ValueInEmptyWindows that = (ValueInEmptyWindows)((Object)o);
                return Objects.equals(that.getValue(), this.getValue());
            }
            return super.equals(o);
        }
    }

    static class TransformedMapCoder<@UnknownKeyFor K, @UnknownKeyFor V1, @UnknownKeyFor V2>
    extends StructuredCoder<TransformedMap<K, V1, V2>> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Function<V1, V2>> transformCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Map<K, V1>> originalMapCoder;

        private TransformedMapCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Function<V1, V2>> transformCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Map<K, V1>> originalMapCoder) {
            this.transformCoder = transformCoder;
            this.originalMapCoder = originalMapCoder;
        }

        public static <K, V1, V2> @UnknownKeyFor @NonNull @Initialized TransformedMapCoder<K, V1, V2> of(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Function<V1, V2>> transformCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Map<K, V1>> originalMapCoder) {
            return new TransformedMapCoder<K, V1, V2>(transformCoder, originalMapCoder);
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized TransformedMap<K, V1, V2> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.transformCoder.encode((Object)((TransformedMap)value).transform, outStream);
            this.originalMapCoder.encode((Object)((TransformedMap)value).originalMap, outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized TransformedMap<K, V1, V2> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return new TransformedMap((Function)this.transformCoder.decode(inStream), (Map)this.originalMapCoder.decode(inStream));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Arrays.asList(this.transformCoder, this.originalMapCoder);
        }

        public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            TransformedMapCoder.verifyDeterministic((Coder)this, (String)"Expected transform coder to be deterministic.", (Coder[])new Coder[]{this.transformCoder});
            TransformedMapCoder.verifyDeterministic((Coder)this, (String)"Expected map coder to be deterministic.", (Coder[])new Coder[]{this.originalMapCoder});
        }
    }

    static class TransformedMap<@UnknownKeyFor K, @UnknownKeyFor V1, @UnknownKeyFor V2>
    extends ForwardingMap<K, V2> {
        private final @UnknownKeyFor @NonNull @Initialized Function<V1, V2> transform;
        private final @UnknownKeyFor @NonNull @Initialized Map<K, V1> originalMap;
        private final @UnknownKeyFor @NonNull @Initialized Map<K, V2> transformedMap;

        TransformedMap(@UnknownKeyFor @NonNull @Initialized Function<V1, V2> transform, @UnknownKeyFor @NonNull @Initialized Map<K, V1> originalMap) {
            this.transform = transform;
            this.originalMap = Collections.unmodifiableMap(originalMap);
            this.transformedMap = Maps.transformValues(originalMap, transform);
        }

        protected @UnknownKeyFor @NonNull @Initialized Map<K, V2> delegate() {
            return this.transformedMap;
        }
    }

    static class GroupByKeyAndSortValuesOnly<@UnknownKeyFor K1, @UnknownKeyFor K2, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K1, KV<K2, V>>>, PCollection<KV<K1, Iterable<KV<K2, V>>>>> {
        GroupByKeyAndSortValuesOnly() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K1, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<K2, V>>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K1, @UnknownKeyFor @NonNull @Initialized KV<K2, V>>> input) {
            KvCoder inputCoder = (KvCoder)input.getCoder();
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)KvCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)IterableCoder.of((Coder)inputCoder.getValueCoder())));
        }
    }

    private static class GroupByWindowHashAsKeyAndWindowAsSortKey<@UnknownKeyFor T, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    extends PTransform<PCollection<T>, PCollection<KV<Integer, Iterable<KV<W, WindowedValue<T>>>>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> ismCoderForHash;

        private GroupByWindowHashAsKeyAndWindowAsSortKey(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> ismCoderForHash) {
            this.ismCoderForHash = ismCoderForHash;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<W, @UnknownKeyFor @NonNull @Initialized WindowedValue<T>>>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            PCollection rval = (PCollection)input.apply((PTransform)ParDo.of(new UseWindowHashAsKeyAndWindowAsSortKeyDoFn(this.ismCoderForHash)));
            rval.setCoder((Coder)KvCoder.of((Coder)VarIntCoder.of(), (Coder)KvCoder.of((Coder)windowCoder, (Coder)WindowedValue.FullWindowedValueCoder.of((Coder)input.getCoder(), (Coder)windowCoder))));
            return (PCollection)rval.apply(new GroupByKeyAndSortValuesOnly());
        }

        @SystemDoFnInternal
        private static class UseWindowHashAsKeyAndWindowAsSortKeyDoFn<@UnknownKeyFor T, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
        extends DoFn<T, KV<Integer, KV<W, WindowedValue<T>>>> {
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> ismCoderForHash;

            private UseWindowHashAsKeyAndWindowAsSortKeyDoFn(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> ismCoderForHash) {
                this.ismCoderForHash = ismCoderForHash;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow untypedWindow) throws @UnknownKeyFor @NonNull @Initialized Exception {
                BoundedWindow window = untypedWindow;
                c.output((Object)KV.of((Object)this.ismCoderForHash.hash((List<?>)ImmutableList.of((Object)window)), (Object)KV.of((Object)window, (Object)WindowedValue.of((Object)c.element(), (Instant)c.timestamp(), (BoundedWindow)window, (PaneInfo)c.pane()))));
            }
        }
    }

    private static class IterableWithWindowedValuesToIterable<@UnknownKeyFor V>
    implements Function<Iterable<WindowedValue<V>>, Iterable<V>>,
    Serializable {
        private static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized IterableWithWindowedValuesToIterable<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> INSTANCE = new IterableWithWindowedValuesToIterable();

        private IterableWithWindowedValuesToIterable() {
        }

        private static <V> @UnknownKeyFor @NonNull @Initialized IterableWithWindowedValuesToIterable<V> of() {
            return INSTANCE;
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public @UnknownKeyFor @NonNull @Initialized Iterable<V> apply(@Nonnull @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>> input) {
            return Iterables.transform(input, (Function)WindowedValueToValue.of());
        }
    }

    private static class WindowedValueToValue<@UnknownKeyFor V>
    implements Function<WindowedValue<V>, V>,
    Serializable {
        private static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowedValueToValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> INSTANCE = new WindowedValueToValue();

        private WindowedValueToValue() {
        }

        private static <V> @UnknownKeyFor @NonNull @Initialized WindowedValueToValue<V> of() {
            return INSTANCE;
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public V apply(@Nonnull @UnknownKeyFor @NonNull @Initialized WindowedValue<V> input) {
            return (V)input.getValue();
        }
    }

    static class BatchViewAsIterable<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollectionView<Iterable<T>>> {
        private final transient @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Iterable<T>> view;

        public BatchViewAsIterable(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized View.CreatePCollectionView<T, @UnknownKeyFor @NonNull @Initialized Iterable<T>> transform) {
            this.runner = runner;
            this.view = transform.getView();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Iterable<T>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return BatchViewAsList.applyForIterableLike(this.runner, input, this.view);
        }
    }

    static class BatchViewAsList<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollectionView<List<T>>> {
        private final transient @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> view;

        public BatchViewAsList(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized View.CreatePCollectionView<T, @UnknownKeyFor @NonNull @Initialized List<T>> transform) {
            this.runner = runner;
            this.view = transform.getView();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return BatchViewAsList.applyForIterableLike(this.runner, input, this.view);
        }

        static <T, W extends BoundedWindow, ViewT> @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> applyForIterableLike(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner, @UnknownKeyFor @NonNull @Initialized PCollection<T> input, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view) {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            IsmFormat.IsmRecordCoder<WindowedValue<T>> ismCoder = BatchViewAsList.coderForListLike((Coder<? extends BoundedWindow>)windowCoder, input.getCoder());
            if (input.getWindowingStrategy().getWindowFn() instanceof GlobalWindows) {
                PCollection reifiedPerWindowAndSorted = (PCollection)input.apply((PTransform)ParDo.of(new ToIsmRecordForGlobalWindowDoFn()));
                reifiedPerWindowAndSorted.setCoder(ismCoder);
                runner.addPCollectionRequiringIndexedFormat(reifiedPerWindowAndSorted);
                reifiedPerWindowAndSorted.apply(CreateDataflowView.forBatch(view));
                return view;
            }
            PCollection reifiedPerWindowAndSorted = (PCollection)((PCollection)input.apply(new GroupByWindowHashAsKeyAndWindowAsSortKey(ismCoder))).apply((PTransform)ParDo.of(new ToIsmRecordForNonGlobalWindowDoFn(windowCoder)));
            reifiedPerWindowAndSorted.setCoder(ismCoder);
            runner.addPCollectionRequiringIndexedFormat(reifiedPerWindowAndSorted);
            reifiedPerWindowAndSorted.apply(CreateDataflowView.forBatch(view));
            return view;
        }

        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return "BatchViewAsList";
        }

        static <T> @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> coderForListLike(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            return IsmFormat.IsmRecordCoder.of(1, 0, ImmutableList.of(windowCoder, (Object)BigEndianLongCoder.of()), WindowedValue.FullWindowedValueCoder.of(valueCoder, windowCoder));
        }

        @SystemDoFnInternal
        static class ToIsmRecordForNonGlobalWindowDoFn<@UnknownKeyFor T, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, WindowedValue<T>>>>, IsmFormat.IsmRecord<WindowedValue<T>>> {
            private final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder;

            ToIsmRecordForNonGlobalWindowDoFn(@UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                long elementsInWindow = 0L;
                Optional previousWindowStructuralValue = Optional.absent();
                for (KV value : (Iterable)((KV)c.element()).getValue()) {
                    Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)value.getKey()));
                    if (previousWindowStructuralValue.isPresent() && !previousWindowStructuralValue.get().equals(currentWindowStructuralValue)) {
                        elementsInWindow = 0L;
                    }
                    c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)value.getKey(), (Object)elementsInWindow), (WindowedValue)value.getValue()));
                    previousWindowStructuralValue = Optional.of((Object)currentWindowStructuralValue);
                    ++elementsInWindow;
                }
            }
        }

        @SystemDoFnInternal
        static class ToIsmRecordForGlobalWindowDoFn<@UnknownKeyFor T>
        extends DoFn<T, IsmFormat.IsmRecord<WindowedValue<T>>> {
            @UnknownKeyFor @NonNull @Initialized long indexInBundle;

            ToIsmRecordForGlobalWindowDoFn() {
            }

            @DoFn.StartBundle
            public void startBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.indexInBundle = 0L;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)GlobalWindow.INSTANCE, (Object)this.indexInBundle), WindowedValue.of((Object)c.element(), (Instant)c.timestamp(), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)c.pane())));
                ++this.indexInBundle;
            }
        }
    }

    static class BatchViewAsSingleton<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollectionView<T>> {
        private final transient @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<T> view;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> combineFn;
        private final @UnknownKeyFor @NonNull @Initialized int fanout;

        public BatchViewAsSingleton(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized View.CreatePCollectionView<T, T> transform, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> combineFn, @UnknownKeyFor @NonNull @Initialized int fanout) {
            this.runner = runner;
            this.view = transform.getView();
            this.combineFn = combineFn;
            this.fanout = fanout;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionView<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            input = (PCollection)input.apply((PTransform)Combine.globally(this.combineFn).withoutDefaults().withFanout(this.fanout));
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            return BatchViewAsSingleton.applyForSingleton(this.runner, input, new IsmRecordForSingularValuePerWindowDoFn(windowCoder), input.getCoder(), this.view);
        }

        static <T, FinalT, ViewT, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> applyForSingleton(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner, @UnknownKeyFor @NonNull @Initialized PCollection<T> input, @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<W, @UnknownKeyFor @NonNull @Initialized WindowedValue<T>>>>, @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecord<@UnknownKeyFor @NonNull @Initialized WindowedValue<FinalT>>> doFn, @UnknownKeyFor @NonNull @Initialized Coder<FinalT> defaultValueCoder, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view) {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            IsmFormat.IsmRecordCoder<WindowedValue<FinalT>> ismCoder = BatchViewAsSingleton.coderForSingleton((Coder<? extends BoundedWindow>)windowCoder, defaultValueCoder);
            PCollection reifiedPerWindowAndSorted = (PCollection)((PCollection)input.apply(new GroupByWindowHashAsKeyAndWindowAsSortKey(ismCoder))).apply((PTransform)ParDo.of(doFn));
            reifiedPerWindowAndSorted.setCoder(ismCoder);
            runner.addPCollectionRequiringIndexedFormat(reifiedPerWindowAndSorted);
            reifiedPerWindowAndSorted.apply(CreateDataflowView.forBatch(view));
            return view;
        }

        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return "BatchViewAsSingleton";
        }

        static <T> @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> coderForSingleton(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            return IsmFormat.IsmRecordCoder.of(1, 0, ImmutableList.of(windowCoder), WindowedValue.FullWindowedValueCoder.of(valueCoder, windowCoder));
        }

        static class IsmRecordForSingularValuePerWindowDoFn<@UnknownKeyFor T, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, WindowedValue<T>>>>, IsmFormat.IsmRecord<WindowedValue<T>>> {
            private final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder;

            IsmRecordForSingularValuePerWindowDoFn(@UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                Optional previousWindowStructuralValue = Optional.absent();
                Object previousValue = null;
                for (KV next : (Iterable)((KV)c.element()).getValue()) {
                    Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)next.getKey()));
                    Preconditions.checkState((!previousWindowStructuralValue.isPresent() || !previousWindowStructuralValue.get().equals(currentWindowStructuralValue) ? 1 : 0) != 0, (String)"Multiple values [%s, %s] found for singleton within window [%s].", previousValue, (Object)((WindowedValue)next.getValue()).getValue(), (Object)next.getKey());
                    c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)((BoundedWindow)next.getKey())), (WindowedValue)next.getValue()));
                    previousWindowStructuralValue = Optional.of((Object)currentWindowStructuralValue);
                    previousValue = ((WindowedValue)next.getValue()).getValue();
                }
            }
        }
    }

    static class BatchViewAsMultimap<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollectionView<Map<K, Iterable<V>>>> {
        private final transient @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> view;

        public BatchViewAsMultimap(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized View.CreatePCollectionView<@UnknownKeyFor @NonNull @Initialized KV<K, V>, @UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> transform) {
            this.runner = runner;
            this.view = transform.getView();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            return this.applyInternal(input);
        }

        private <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> applyInternal(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            try {
                return BatchViewAsMultimap.applyForMapLike(this.runner, input, this.view, false);
            }
            catch (Coder.NonDeterministicException e) {
                this.runner.recordViewUsesNonDeterministicKeyCoder(this);
                return this.applyForSingletonFallback(input);
            }
        }

        private <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> applyForSingletonFallback(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            KvCoder inputCoder = (KvCoder)input.getCoder();
            SerializableCoder transformCoder = SerializableCoder.of(IterableWithWindowedValuesToIterable.class);
            TransformedMapCoder finalValueCoder = TransformedMapCoder.of(transformCoder, MapCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)IterableCoder.of((Coder)WindowedValue.FullWindowedValueCoder.of((Coder)inputCoder.getValueCoder(), (Coder)windowCoder))));
            return BatchViewAsSingleton.applyForSingleton(this.runner, input, new ToMultimapDoFn(windowCoder), finalValueCoder, this.view);
        }

        private static <K, V, W extends BoundedWindow, ViewT> @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> applyForMapLike(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view, @UnknownKeyFor @NonNull @Initialized boolean uniqueKeysExpected) throws // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            KvCoder inputCoder = (KvCoder)input.getCoder();
            inputCoder.getKeyCoder().verifyDeterministic();
            IsmFormat.IsmRecordCoder<WindowedValue<V>> ismCoder = BatchViewAsMultimap.coderForMapLike((Coder<? extends BoundedWindow>)windowCoder, inputCoder.getKeyCoder(), inputCoder.getValueCoder());
            TupleTag mainOutputTag = new TupleTag();
            TupleTag outputForSizeTag = new TupleTag();
            TupleTag outputForEntrySetTag = new TupleTag();
            PCollectionTuple outputTuple = (PCollectionTuple)((PCollection)input.apply("GBKaSVForData", new GroupByKeyHashAndSortByKeyAndWindow(ismCoder))).apply((PTransform)ParDo.of(new ToIsmRecordForMapLikeDoFn(outputForSizeTag, outputForEntrySetTag, windowCoder, inputCoder.getKeyCoder(), ismCoder, uniqueKeysExpected)).withOutputTags(mainOutputTag, TupleTagList.of((List)ImmutableList.of((Object)outputForSizeTag, (Object)outputForEntrySetTag))));
            PCollection perHashWithReifiedWindows = outputTuple.get(mainOutputTag);
            perHashWithReifiedWindows.setCoder(ismCoder);
            PCollection outputForSize = outputTuple.get(outputForSizeTag);
            outputForSize.setCoder((Coder)KvCoder.of((Coder)VarIntCoder.of(), (Coder)KvCoder.of((Coder)windowCoder, (Coder)VarLongCoder.of())));
            PCollection windowMapSizeMetadata = (PCollection)((PCollection)outputForSize.apply("GBKaSVForSize", new GroupByKeyAndSortValuesOnly())).apply((PTransform)ParDo.of(new ToIsmMetadataRecordForSizeDoFn(windowCoder)));
            windowMapSizeMetadata.setCoder(ismCoder);
            PCollection outputForEntrySet = outputTuple.get(outputForEntrySetTag);
            outputForEntrySet.setCoder((Coder)KvCoder.of((Coder)VarIntCoder.of(), (Coder)KvCoder.of((Coder)windowCoder, (Coder)inputCoder.getKeyCoder())));
            PCollection windowMapKeysMetadata = (PCollection)((PCollection)outputForEntrySet.apply("GBKaSVForKeys", new GroupByKeyAndSortValuesOnly())).apply((PTransform)ParDo.of(new ToIsmMetadataRecordForKeyDoFn(inputCoder.getKeyCoder(), windowCoder)));
            windowMapKeysMetadata.setCoder(ismCoder);
            runner.addPCollectionRequiringIndexedFormat(perHashWithReifiedWindows);
            runner.addPCollectionRequiringIndexedFormat(windowMapSizeMetadata);
            runner.addPCollectionRequiringIndexedFormat(windowMapKeysMetadata);
            PCollectionList outputs = PCollectionList.of((Iterable)ImmutableList.of((Object)perHashWithReifiedWindows, (Object)windowMapSizeMetadata, (Object)windowMapKeysMetadata));
            PCollection flattenedOutputs = (PCollection)Pipeline.applyTransform((PInput)outputs, (PTransform)Flatten.pCollections());
            flattenedOutputs.apply(CreateDataflowView.forBatch(view));
            return view;
        }

        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return "BatchViewAsMultimap";
        }

        static <V> @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>> coderForMapLike(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
            return IsmFormat.IsmRecordCoder.of(1, 2, ImmutableList.of(IsmFormat.MetadataKeyCoder.of(keyCoder), windowCoder, (Object)BigEndianLongCoder.of()), WindowedValue.FullWindowedValueCoder.of(valueCoder, windowCoder));
        }

        static class ToMultimapDoFn<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, WindowedValue<KV<K, V>>>>>, IsmFormat.IsmRecord<WindowedValue<TransformedMap<K, Iterable<WindowedValue<V>>, Iterable<V>>>>> {
            private final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder;

            ToMultimapDoFn(@UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                Optional previousWindowStructuralValue = Optional.absent();
                Optional previousWindow = Optional.absent();
                ArrayListMultimap multimap = ArrayListMultimap.create();
                for (KV kv : (Iterable)((KV)c.element()).getValue()) {
                    Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)kv.getKey()));
                    if (previousWindowStructuralValue.isPresent() && !previousWindowStructuralValue.get().equals(currentWindowStructuralValue)) {
                        Map resultMap = multimap.asMap();
                        c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)((BoundedWindow)previousWindow.get())), BatchViewOverrides.valueInEmptyWindows(new TransformedMap(IterableWithWindowedValuesToIterable.of(), resultMap))));
                        multimap = ArrayListMultimap.create();
                    }
                    multimap.put(((KV)((WindowedValue)kv.getValue()).getValue()).getKey(), (Object)((WindowedValue)kv.getValue()).withValue(((KV)((WindowedValue)kv.getValue()).getValue()).getValue()));
                    previousWindowStructuralValue = Optional.of((Object)currentWindowStructuralValue);
                    previousWindow = Optional.of((Object)((BoundedWindow)kv.getKey()));
                }
                Map resultMap = multimap.asMap();
                c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)((BoundedWindow)previousWindow.get())), BatchViewOverrides.valueInEmptyWindows(new TransformedMap(IterableWithWindowedValuesToIterable.of(), resultMap))));
            }
        }

        static class ToIsmMetadataRecordForKeyDoFn<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, K>>>, IsmFormat.IsmRecord<WindowedValue<V>>> {
            private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
            private final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder;

            ToIsmMetadataRecordForKeyDoFn(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
                this.keyCoder = keyCoder;
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                Iterator iterator = ((Iterable)((KV)c.element()).getValue()).iterator();
                KV currentValue = (KV)iterator.next();
                Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)currentValue.getKey()));
                long elementsInWindow = 1L;
                while (iterator.hasNext()) {
                    KV nextValue = (KV)iterator.next();
                    Object nextWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)nextValue.getKey()));
                    c.output(IsmFormat.IsmRecord.meta(ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)currentValue.getKey(), (Object)elementsInWindow), CoderUtils.encodeToByteArray(this.keyCoder, (Object)currentValue.getValue())));
                    ++elementsInWindow;
                    if (!currentWindowStructuralValue.equals(nextWindowStructuralValue)) {
                        elementsInWindow = 1L;
                    }
                    currentValue = nextValue;
                    currentWindowStructuralValue = nextWindowStructuralValue;
                }
                c.output(IsmFormat.IsmRecord.meta(ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)currentValue.getKey(), (Object)elementsInWindow), CoderUtils.encodeToByteArray(this.keyCoder, (Object)currentValue.getValue())));
            }
        }

        static class ToIsmMetadataRecordForSizeDoFn<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, Long>>>, IsmFormat.IsmRecord<WindowedValue<V>>> {
            private final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder;

            ToIsmMetadataRecordForSizeDoFn(@UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                Iterator iterator = ((Iterable)((KV)c.element()).getValue()).iterator();
                KV currentValue = (KV)iterator.next();
                Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)currentValue.getKey()));
                long size = 0L;
                while (iterator.hasNext()) {
                    KV nextValue = (KV)iterator.next();
                    Object nextWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)nextValue.getKey()));
                    size += ((Long)currentValue.getValue()).longValue();
                    if (!currentWindowStructuralValue.equals(nextWindowStructuralValue)) {
                        c.output(IsmFormat.IsmRecord.meta(ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)currentValue.getKey(), (Object)0L), CoderUtils.encodeToByteArray((Coder)VarLongCoder.of(), (Object)size)));
                        size = 0L;
                    }
                    currentValue = nextValue;
                    currentWindowStructuralValue = nextWindowStructuralValue;
                }
                c.output(IsmFormat.IsmRecord.meta(ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)currentValue.getKey(), (Object)0L), CoderUtils.encodeToByteArray((Coder)VarLongCoder.of(), (Object)(size += ((Long)currentValue.getValue()).longValue()))));
            }
        }

        static class ToIsmRecordForMapLikeDoFn<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<KV<K, W>, WindowedValue<V>>>>, IsmFormat.IsmRecord<WindowedValue<V>>> {
            private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized KV<W, @UnknownKeyFor @NonNull @Initialized Long>>> outputForSize;
            private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized KV<W, K>>> outputForEntrySet;
            private final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder;
            private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
            private final @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>> ismCoder;
            private final @UnknownKeyFor @NonNull @Initialized boolean uniqueKeysExpected;

            ToIsmRecordForMapLikeDoFn(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized KV<W, @UnknownKeyFor @NonNull @Initialized Long>>> outputForSize, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized KV<W, K>>> outputForEntrySet, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>> ismCoder, @UnknownKeyFor @NonNull @Initialized boolean uniqueKeysExpected) {
                this.outputForSize = outputForSize;
                this.outputForEntrySet = outputForEntrySet;
                this.windowCoder = windowCoder;
                this.keyCoder = keyCoder;
                this.ismCoder = ismCoder;
                this.uniqueKeysExpected = uniqueKeysExpected;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                long currentKeyIndex = 0L;
                long currentUniqueKeyCounter = 1L;
                Iterator iterator = ((Iterable)((KV)c.element()).getValue()).iterator();
                KV currentValue = (KV)iterator.next();
                Object currentKeyStructuralValue = this.keyCoder.structuralValue(((KV)currentValue.getKey()).getKey());
                Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)((KV)currentValue.getKey()).getValue()));
                while (iterator.hasNext()) {
                    long nextUniqueKeyCounter;
                    long nextKeyIndex;
                    KV nextValue = (KV)iterator.next();
                    Object nextKeyStructuralValue = this.keyCoder.structuralValue(((KV)nextValue.getKey()).getKey());
                    Object nextWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)((KV)nextValue.getKey()).getValue()));
                    this.outputDataRecord(c, currentValue, currentKeyIndex);
                    if (!currentWindowStructuralValue.equals(nextWindowStructuralValue)) {
                        this.outputMetadataRecordForSize(c, currentValue, currentUniqueKeyCounter);
                        this.outputMetadataRecordForEntrySet(c, currentValue);
                        nextKeyIndex = 0L;
                        nextUniqueKeyCounter = 1L;
                    } else if (!currentKeyStructuralValue.equals(nextKeyStructuralValue)) {
                        this.outputMetadataRecordForEntrySet(c, currentValue);
                        nextKeyIndex = 0L;
                        nextUniqueKeyCounter = currentUniqueKeyCounter + 1L;
                    } else if (!this.uniqueKeysExpected) {
                        nextKeyIndex = currentKeyIndex + 1L;
                        nextUniqueKeyCounter = currentUniqueKeyCounter;
                    } else {
                        throw new IllegalStateException(String.format("Unique keys are expected but found key %s with values %s and %s in window %s.", ((KV)currentValue.getKey()).getKey(), ((WindowedValue)currentValue.getValue()).getValue(), ((WindowedValue)nextValue.getValue()).getValue(), ((KV)currentValue.getKey()).getValue()));
                    }
                    currentValue = nextValue;
                    currentWindowStructuralValue = nextWindowStructuralValue;
                    currentKeyStructuralValue = nextKeyStructuralValue;
                    currentKeyIndex = nextKeyIndex;
                    currentUniqueKeyCounter = nextUniqueKeyCounter;
                }
                this.outputDataRecord(c, currentValue, currentKeyIndex);
                this.outputMetadataRecordForSize(c, currentValue, currentUniqueKeyCounter);
                this.outputMetadataRecordForEntrySet(c, currentValue);
            }

            private void outputDataRecord(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<K, W>, @UnknownKeyFor @NonNull @Initialized WindowedValue<V>> value, @UnknownKeyFor @NonNull @Initialized long keyIndex) {
                IsmFormat.IsmRecord<WindowedValue> ismRecord = IsmFormat.IsmRecord.of(ImmutableList.of((Object)((KV)value.getKey()).getKey(), (Object)((KV)value.getKey()).getValue(), (Object)keyIndex), (WindowedValue)value.getValue());
                c.output(ismRecord);
            }

            private void outputMetadataRecordForSize(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<K, W>, @UnknownKeyFor @NonNull @Initialized WindowedValue<V>> value, @UnknownKeyFor @NonNull @Initialized long uniqueKeyCount) {
                c.output(this.outputForSize, (Object)KV.of((Object)this.ismCoder.hash((List<?>)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)((KV)value.getKey()).getValue())), (Object)KV.of((Object)((BoundedWindow)((KV)value.getKey()).getValue()), (Object)uniqueKeyCount)));
            }

            private void outputMetadataRecordForEntrySet(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<K, W>, @UnknownKeyFor @NonNull @Initialized WindowedValue<V>> value) {
                c.output(this.outputForEntrySet, (Object)KV.of((Object)this.ismCoder.hash((List<?>)ImmutableList.of((Object)IsmFormat.getMetadataKey(), (Object)((KV)value.getKey()).getValue())), (Object)KV.of((Object)((BoundedWindow)((KV)value.getKey()).getValue()), (Object)((KV)value.getKey()).getKey())));
            }
        }

        private static class GroupByKeyHashAndSortByKeyAndWindow<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
        extends PTransform<PCollection<KV<K, V>>, PCollection<KV<Integer, Iterable<KV<KV<K, W>, WindowedValue<V>>>>>> {
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder;

            public GroupByKeyHashAndSortByKeyAndWindow(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
                this.coder = coder;
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<K, W>, @UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
                Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
                KvCoder inputCoder = (KvCoder)input.getCoder();
                PCollection keyedByHash = (PCollection)input.apply((PTransform)ParDo.of(new GroupByKeyHashAndSortByKeyAndWindowDoFn(this.coder)));
                keyedByHash.setCoder((Coder)KvCoder.of((Coder)VarIntCoder.of(), (Coder)KvCoder.of((Coder)KvCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)windowCoder), (Coder)WindowedValue.FullWindowedValueCoder.of((Coder)inputCoder.getValueCoder(), (Coder)windowCoder))));
                return (PCollection)keyedByHash.apply(new GroupByKeyAndSortValuesOnly());
            }

            @SystemDoFnInternal
            private static class GroupByKeyHashAndSortByKeyAndWindowDoFn<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W>
            extends DoFn<KV<K, V>, KV<Integer, KV<KV<K, W>, WindowedValue<V>>>> {
                private final /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder;

                private GroupByKeyHashAndSortByKeyAndWindowDoFn(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized IsmFormat.IsmRecordCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
                    this.coder = coder;
                }

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow untypedWindow) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    BoundedWindow window = untypedWindow;
                    c.output((Object)KV.of((Object)this.coder.hash((List<?>)ImmutableList.of((Object)((KV)c.element()).getKey())), (Object)KV.of((Object)KV.of((Object)((KV)c.element()).getKey(), (Object)window), (Object)WindowedValue.of((Object)((KV)c.element()).getValue(), (Instant)c.timestamp(), (BoundedWindow)untypedWindow, (PaneInfo)c.pane()))));
                }
            }
        }
    }

    static class BatchViewAsMap<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollectionView<Map<K, V>>> {
        private final transient @UnknownKeyFor @NonNull @Initialized DataflowRunner runner;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, V>> view;

        public BatchViewAsMap(@UnknownKeyFor @NonNull @Initialized DataflowRunner runner, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized View.CreatePCollectionView<@UnknownKeyFor @NonNull @Initialized KV<K, V>, @UnknownKeyFor @NonNull @Initialized Map<K, V>> transform) {
            this.runner = runner;
            this.view = transform.getView();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            return this.applyInternal(input);
        }

        private <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, V>> applyInternal(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            try {
                return BatchViewAsMultimap.applyForMapLike(this.runner, input, this.view, true);
            }
            catch (Coder.NonDeterministicException e) {
                this.runner.recordViewUsesNonDeterministicKeyCoder(this);
                return this.applyForSingletonFallback(input);
            }
        }

        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return "BatchViewAsMap";
        }

        private <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, V>> applyForSingletonFallback(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            Coder windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
            KvCoder inputCoder = (KvCoder)input.getCoder();
            SerializableCoder transformCoder = SerializableCoder.of(WindowedValueToValue.class);
            TransformedMapCoder finalValueCoder = TransformedMapCoder.of(transformCoder, MapCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)WindowedValue.FullWindowedValueCoder.of((Coder)inputCoder.getValueCoder(), (Coder)windowCoder)));
            return BatchViewAsSingleton.applyForSingleton(this.runner, input, new ToMapDoFn(windowCoder), finalValueCoder, this.view);
        }

        static class ToMapDoFn<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
        extends DoFn<KV<Integer, Iterable<KV<W, WindowedValue<KV<K, V>>>>>, IsmFormat.IsmRecord<WindowedValue<TransformedMap<K, WindowedValue<V>, V>>>> {
            private final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder;

            ToMapDoFn(@UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
                this.windowCoder = windowCoder;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                Optional previousWindowStructuralValue = Optional.absent();
                Optional previousWindow = Optional.absent();
                HashMap<Object, WindowedValue> map = new HashMap<Object, WindowedValue>();
                for (KV kv : (Iterable)((KV)c.element()).getValue()) {
                    Object currentWindowStructuralValue = this.windowCoder.structuralValue((Object)((BoundedWindow)kv.getKey()));
                    if (previousWindowStructuralValue.isPresent() && !previousWindowStructuralValue.get().equals(currentWindowStructuralValue)) {
                        c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)((BoundedWindow)previousWindow.get())), BatchViewOverrides.valueInEmptyWindows(new TransformedMap(WindowedValueToValue.of(), map))));
                        map = new HashMap();
                    }
                    Preconditions.checkState((!map.containsKey(((KV)((WindowedValue)kv.getValue()).getValue()).getKey()) ? 1 : 0) != 0, (String)"Multiple values [%s, %s] found for single key [%s] within window [%s].", map.get(((KV)((WindowedValue)kv.getValue()).getValue()).getKey()), (Object)((KV)((WindowedValue)kv.getValue()).getValue()).getValue(), (Object)((KV)((WindowedValue)kv.getValue()).getValue()).getKey(), (Object)kv.getKey());
                    map.put(((KV)((WindowedValue)kv.getValue()).getValue()).getKey(), ((WindowedValue)kv.getValue()).withValue(((KV)((WindowedValue)kv.getValue()).getValue()).getValue()));
                    previousWindowStructuralValue = Optional.of((Object)currentWindowStructuralValue);
                    previousWindow = Optional.of((Object)((BoundedWindow)kv.getKey()));
                }
                c.output(IsmFormat.IsmRecord.of(ImmutableList.of((Object)((BoundedWindow)previousWindow.get())), BatchViewOverrides.valueInEmptyWindows(new TransformedMap(WindowedValueToValue.of(), map))));
            }
        }
    }
}

