/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.runners.fnexecution.control.DefaultExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.flink.api.java.ExecutionEnvironment;

public class FlinkExecutableStageContextFactory
implements ExecutableStageContext.Factory {
    private static final FlinkExecutableStageContextFactory instance = new FlinkExecutableStageContextFactory();
    private static final ConcurrentMap<String, DefaultExecutableStageContext.MultiInstanceFactory> jobFactories = new ConcurrentHashMap<String, DefaultExecutableStageContext.MultiInstanceFactory>();

    private FlinkExecutableStageContextFactory() {
    }

    public static FlinkExecutableStageContextFactory getInstance() {
        return instance;
    }

    public ExecutableStageContext get(JobInfo jobInfo) {
        DefaultExecutableStageContext.MultiInstanceFactory jobFactory = jobFactories.computeIfAbsent(jobInfo.jobId(), k -> {
            PortablePipelineOptions portableOptions = (PortablePipelineOptions)PipelineOptionsTranslation.fromProto((Struct)jobInfo.pipelineOptions()).as(PortablePipelineOptions.class);
            return new DefaultExecutableStageContext.MultiInstanceFactory(((Long)MoreObjects.firstNonNull((Object)portableOptions.getSdkWorkerParallelism(), (Object)1L)).intValue(), (SerializableFunction & Serializable)caller -> caller.getClass().getClassLoader() != ExecutionEnvironment.class.getClassLoader());
        });
        return jobFactory.get(jobInfo);
    }
}

