/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkRunner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.util.UserCodeException;

public class TestFlinkRunner
extends PipelineRunner<PipelineResult> {
    private FlinkRunner delegate;

    private TestFlinkRunner(FlinkPipelineOptions options) {
        options.setRunner(TestFlinkRunner.class);
        options.setShutdownSourcesOnFinalWatermark(true);
        if (options.getParallelism() == -1) {
            options.setParallelism(1);
        }
        this.delegate = FlinkRunner.fromOptions(options);
    }

    public static TestFlinkRunner fromOptions(PipelineOptions options) {
        FlinkPipelineOptions flinkOptions = (FlinkPipelineOptions)options.as(FlinkPipelineOptions.class);
        return new TestFlinkRunner(flinkOptions);
    }

    public static TestFlinkRunner create(boolean streaming) {
        FlinkPipelineOptions flinkOptions = (FlinkPipelineOptions)PipelineOptionsFactory.as(FlinkPipelineOptions.class);
        flinkOptions.setStreaming(streaming);
        return TestFlinkRunner.fromOptions(flinkOptions);
    }

    public PipelineResult run(Pipeline pipeline) {
        try {
            return this.delegate.run(pipeline);
        }
        catch (Throwable t) {
            UserCodeException innermostUserCodeException = null;
            Throwable current = t;
            while (current.getCause() != null) {
                if (current instanceof UserCodeException) {
                    innermostUserCodeException = (UserCodeException)current;
                }
                current = current.getCause();
            }
            if (innermostUserCodeException != null) {
                current = innermostUserCodeException.getCause();
            }
            if (current instanceof AssertionError) {
                throw (AssertionError)((Object)current);
            }
            throw new Pipeline.PipelineExecutionException(current);
        }
    }

    public PipelineOptions getPipelineOptions() {
        return this.delegate.getPipelineOptions();
    }
}

