/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.direct.portable.CommittedBundle;
import org.apache.beam.runners.direct.portable.EvaluationContext;
import org.apache.beam.runners.direct.portable.StepTransformResult;
import org.apache.beam.runners.direct.portable.TransformEvaluator;
import org.apache.beam.runners.direct.portable.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.portable.TransformResult;
import org.apache.beam.runners.direct.portable.UncommittedBundle;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.joda.time.Instant;

class WindowEvaluatorFactory
implements TransformEvaluatorFactory {
    private final EvaluationContext evaluationContext;

    WindowEvaluatorFactory(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    @Override
    public <InputT> TransformEvaluator<InputT> forApplication(PipelineNode.PTransformNode application, @Nullable CommittedBundle<?> inputBundle) {
        return this.createTransformEvaluator(application);
    }

    private <InputT> TransformEvaluator<InputT> createTransformEvaluator(PipelineNode.PTransformNode transform) {
        Object fn = null;
        PipelineNode.PCollectionNode outputPCollection = null;
        this.evaluationContext.createBundle(outputPCollection);
        throw new UnsupportedOperationException("Not yet migrated");
    }

    @Override
    public void cleanup() {
    }

    private static class DirectAssignContext<InputT, W extends BoundedWindow>
    extends WindowFn.AssignContext {
        private final WindowedValue<InputT> value;

        public DirectAssignContext(WindowFn<InputT, W> fn, WindowedValue<InputT> value) {
            super(fn);
            this.value = value;
        }

        public InputT element() {
            return (InputT)this.value.getValue();
        }

        public Instant timestamp() {
            return this.value.getTimestamp();
        }

        public BoundedWindow window() {
            return (BoundedWindow)Iterables.getOnlyElement(this.value.getWindows());
        }
    }

    private static class WindowIntoEvaluator<InputT>
    implements TransformEvaluator<InputT> {
        private final PipelineNode.PTransformNode transform;
        private final WindowFn<InputT, ?> windowFn;
        private final UncommittedBundle<InputT> outputBundle;

        public WindowIntoEvaluator(PipelineNode.PTransformNode transform, WindowFn<? super InputT, ?> windowFn, UncommittedBundle<InputT> outputBundle) {
            this.outputBundle = outputBundle;
            this.transform = transform;
            this.windowFn = windowFn;
        }

        @Override
        public void processElement(WindowedValue<InputT> compressedElement) throws Exception {
            for (WindowedValue element : compressedElement.explodeWindows()) {
                Collection<BoundedWindow> windows = this.assignWindows(this.windowFn, element);
                this.outputBundle.add(WindowedValue.of((Object)element.getValue(), (Instant)element.getTimestamp(), windows, (PaneInfo)element.getPane()));
            }
        }

        private <W extends BoundedWindow> Collection<? extends BoundedWindow> assignWindows(WindowFn<InputT, W> windowFn, WindowedValue<InputT> element) throws Exception {
            DirectAssignContext<InputT, W> assignContext = new DirectAssignContext<InputT, W>(windowFn, element);
            Collection windows = windowFn.assignWindows(assignContext);
            return windows;
        }

        @Override
        public TransformResult<InputT> finishBundle() throws Exception {
            return StepTransformResult.withoutHold(this.transform).addOutput(this.outputBundle, new UncommittedBundle[0]).build();
        }
    }
}

