/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.ReadTranslation;
import org.apache.beam.runners.direct.BoundedReadEvaluatorFactory;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.RootInputProvider;
import org.apache.beam.runners.direct.SourceShard;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.UnboundedReadEvaluatorFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;

final class ReadEvaluatorFactory
implements TransformEvaluatorFactory {
    final BoundedReadEvaluatorFactory boundedFactory;
    final UnboundedReadEvaluatorFactory unboundedFactory;

    public ReadEvaluatorFactory(EvaluationContext context, PipelineOptions options) {
        this.boundedFactory = new BoundedReadEvaluatorFactory(context, options);
        this.unboundedFactory = new UnboundedReadEvaluatorFactory(context, options);
    }

    @Override
    @Nullable
    public <InputT> TransformEvaluator<InputT> forApplication(AppliedPTransform<?, ?, ?> application, CommittedBundle<?> inputBundle) throws Exception {
        switch (ReadTranslation.sourceIsBounded(application)) {
            case BOUNDED: {
                return this.boundedFactory.forApplication(application, inputBundle);
            }
            case UNBOUNDED: {
                return this.unboundedFactory.forApplication(application, inputBundle);
            }
        }
        throw new IllegalArgumentException("PCollection is neither bounded nor unbounded?!?");
    }

    @Override
    public void cleanup() throws Exception {
        this.boundedFactory.cleanup();
        this.unboundedFactory.cleanup();
    }

    static <T> InputProvider<T> inputProvider(EvaluationContext context, PipelineOptions options) {
        return new InputProvider(context, options);
    }

    private static class InputProvider<T>
    implements RootInputProvider<T, SourceShard<T>, PBegin> {
        private final UnboundedReadEvaluatorFactory.InputProvider<T> unboundedInputProvider;
        private final BoundedReadEvaluatorFactory.InputProvider<T> boundedInputProvider;

        InputProvider(EvaluationContext context, PipelineOptions options) {
            this.unboundedInputProvider = new UnboundedReadEvaluatorFactory.InputProvider(context, options);
            this.boundedInputProvider = new BoundedReadEvaluatorFactory.InputProvider(context, options);
        }

        @Override
        public Collection<CommittedBundle<SourceShard<T>>> getInitialInputs(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> appliedTransform, int targetParallelism) throws Exception {
            switch (ReadTranslation.sourceIsBounded(appliedTransform)) {
                case BOUNDED: {
                    return this.boundedInputProvider.getInitialInputs(appliedTransform, targetParallelism);
                }
                case UNBOUNDED: {
                    return this.unboundedInputProvider.getInitialInputs(appliedTransform, targetParallelism);
                }
            }
            throw new IllegalArgumentException("PCollection is neither bounded nor unbounded?!?");
        }
    }
}

