/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.triggers;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.repackaged.beam_runners_core_java.com.google.common.base.Joiner;
import org.apache.beam.repackaged.beam_runners_core_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_java.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.triggers.TriggerStateMachine;

public class AfterEachStateMachine
extends TriggerStateMachine {
    private AfterEachStateMachine(List<TriggerStateMachine> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    @SafeVarargs
    public static TriggerStateMachine inOrder(TriggerStateMachine ... triggers) {
        return new AfterEachStateMachine(Arrays.asList(triggers));
    }

    public static TriggerStateMachine inOrder(Iterable<? extends TriggerStateMachine> triggers) {
        return new AfterEachStateMachine(ImmutableList.copyOf(triggers));
    }

    @Override
    public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
        if (!c.trigger().isMerging()) {
            c.trigger().firstUnfinishedSubTrigger().invokeOnElement(c);
        } else {
            for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
                subTrigger.invokeOnElement(c);
            }
        }
    }

    @Override
    public void onMerge(TriggerStateMachine.OnMergeContext context) throws Exception {
        boolean priorTriggersAllFinished = true;
        for (ExecutableTriggerStateMachine subTrigger : context.trigger().subTriggers()) {
            if (priorTriggersAllFinished) {
                subTrigger.invokeOnMerge(context);
                priorTriggersAllFinished &= context.forTrigger(subTrigger).trigger().isFinished();
                continue;
            }
            subTrigger.invokeClear(context);
        }
        this.updateFinishedState(context);
    }

    @Override
    public boolean shouldFire(TriggerStateMachine.TriggerContext context) throws Exception {
        ExecutableTriggerStateMachine firstUnfinished = context.trigger().firstUnfinishedSubTrigger();
        return firstUnfinished.invokeShouldFire(context);
    }

    @Override
    public void onFire(TriggerStateMachine.TriggerContext context) throws Exception {
        context.trigger().firstUnfinishedSubTrigger().invokeOnFire(context);
        if (context.trigger().isMerging()) {
            for (ExecutableTriggerStateMachine subTrigger : context.trigger().subTriggers()) {
                subTrigger.invokeClear(context);
            }
        }
        this.updateFinishedState(context);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterEach.inOrder(");
        Joiner.on(", ").appendTo(builder, (Iterable<?>)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }

    private void updateFinishedState(TriggerStateMachine.TriggerContext context) {
        context.trigger().setFinished(context.trigger().firstUnfinishedSubTrigger() == null);
    }
}

